/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.Serializable;
import java.io.StringWriter;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.sessions.DatabaseLogin;

public abstract class SQLStatement
implements Serializable,
Cloneable {
    protected Expression whereClause;
    protected ExpressionBuilder builder;
    protected AbstractRecord translationRow;
    protected String hintString;

    public abstract DatabaseCall buildCall(AbstractSession var1);

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public ExpressionBuilder getBuilder() {
        return this.builder;
    }

    public ExpressionBuilder getExpressionBuilder() {
        return this.builder;
    }

    public String getHintString() {
        return this.hintString;
    }

    public AbstractRecord getTranslationRow() {
        return this.translationRow;
    }

    public Expression getWhereClause() {
        return this.whereClause;
    }

    public void setHintString(String newHintString) {
        this.hintString = newHintString;
    }

    protected void setBuilder(ExpressionBuilder aBuilder) {
        this.builder = aBuilder;
    }

    public void setTranslationRow(AbstractRecord theRow) {
        this.translationRow = theRow;
    }

    public void setWhereClause(Expression expression) {
        this.whereClause = expression;
        if (expression != null) {
            this.builder = expression.getBuilder();
        }
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write(Helper.getShortClassName(this.getClass()));
        writer.write("(");
        try {
            DatabaseCall call = this.buildCall(new DatabaseSessionImpl(new DatabaseLogin()));
            writer.write(call.getSQLString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        writer.write(")");
        return writer.toString();
    }
}

