/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;

public class NonSynchronizedSubVector
extends NonSynchronizedVector {
    private Vector l;
    private int offset;
    private int size;

    public NonSynchronizedSubVector(Vector list, int fromIndex, int toIndex) {
        super(0);
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex > list.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        this.l = list;
        this.offset = fromIndex;
        this.size = toIndex - fromIndex;
    }

    @Override
    public Object set(int index, Object element) {
        return this.l.set(index + this.offset, element);
    }

    @Override
    public void setElementAt(Object obj, int index) {
        this.set(index, obj);
    }

    @Override
    public Object elementAt(int index) {
        return this.get(index);
    }

    @Override
    public Object firstElement() {
        return this.get(0);
    }

    @Override
    public Object lastElement() {
        return this.get(this.size() - 1);
    }

    @Override
    public int indexOf(Object elem, int index) {
        int size = this.size();
        if (elem == null) {
            for (int i = index; i < size; ++i) {
                if (this.get(i) != null) continue;
                return i;
            }
        } else {
            for (int i = index; i < size; ++i) {
                if (!elem.equals(this.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object elem, int index) {
        int size = this.size();
        if (index >= size) {
            throw new IndexOutOfBoundsException(index + " >= " + size);
        }
        if (elem == null) {
            for (int i = index; i >= 0; --i) {
                if (this.get(i) != null) continue;
                return i;
            }
        } else {
            for (int i = index; i >= 0; --i) {
                if (!elem.equals(this.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public Object get(int index) {
        return this.l.get(index + this.offset);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void add(int index, Object element) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.l.add(index + this.offset, element);
        ++this.size;
        ++this.modCount;
    }

    @Override
    public Object remove(int index) {
        Object result = this.l.remove(index + this.offset);
        --this.size;
        ++this.modCount;
        return result;
    }

    @Override
    public boolean addAll(Collection c) {
        return this.addAll(this.size, c);
    }

    @Override
    public boolean addAll(int index, Collection c) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        int cSize = c.size();
        if (cSize == 0) {
            return false;
        }
        this.l.addAll(this.offset + index, c);
        this.size += cSize;
        ++this.modCount;
        return true;
    }

    @Override
    public Enumeration elements() {
        return new Enumeration(){
            int count = 0;

            @Override
            public boolean hasMoreElements() {
                return this.count < NonSynchronizedSubVector.this.size();
            }

            public Object nextElement() {
                if (this.count < NonSynchronizedSubVector.this.elementCount) {
                    return NonSynchronizedSubVector.this.get(this.count++);
                }
                throw new NoSuchElementException("Vector Enumeration");
            }
        };
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size];
        System.arraycopy(this.l.toArray(), this.offset, result, 0, this.size);
        return result;
    }

    @Override
    public Object[] toArray(Object[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        System.arraycopy(this.l.toArray(), this.offset, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    @Override
    public Iterator iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator listIterator(final int index) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return new ListIterator(){
            private ListIterator i;
            {
                this.i = NonSynchronizedSubVector.this.l.listIterator(index + NonSynchronizedSubVector.this.offset);
            }

            @Override
            public boolean hasNext() {
                return this.nextIndex() < NonSynchronizedSubVector.this.size;
            }

            @Override
            public Object next() {
                if (this.hasNext()) {
                    return this.i.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasPrevious() {
                return this.previousIndex() >= 0;
            }

            public Object previous() {
                if (this.hasPrevious()) {
                    return this.i.previous();
                }
                throw new NoSuchElementException();
            }

            @Override
            public int nextIndex() {
                return this.i.nextIndex() - NonSynchronizedSubVector.this.offset;
            }

            @Override
            public int previousIndex() {
                return this.i.previousIndex() - NonSynchronizedSubVector.this.offset;
            }

            @Override
            public void remove() {
                this.i.remove();
                --NonSynchronizedSubVector.this.size;
                NonSynchronizedSubVector.this.modCount++;
            }

            public void set(Object o) {
                this.i.set(o);
            }

            public void add(Object o) {
                this.i.add(o);
                ++NonSynchronizedSubVector.this.size;
                NonSynchronizedSubVector.this.modCount++;
            }
        };
    }
}

