/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import jakarta.activation.DataHandler;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.core.queries.CoreContainerPolicy;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.ConversionManager;
import org.eclipse.persistence.internal.oxm.MappingNodeValue;
import org.eclipse.persistence.internal.oxm.Marshaller;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.Unmarshaller;
import org.eclipse.persistence.internal.oxm.XMLBinaryDataHelper;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathNode;
import org.eclipse.persistence.internal.oxm.mappings.BinaryDataCollectionMapping;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.MarshalRecord;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.internal.oxm.record.XMLReader;
import org.eclipse.persistence.internal.oxm.record.deferred.BinaryMappingContentHandler;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.XMLNullRepresentationType;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XMLBinaryDataCollectionMappingNodeValue
extends MappingNodeValue
implements ContainerValue {
    private BinaryDataCollectionMapping xmlBinaryDataCollectionMapping;
    private int index = -1;

    public XMLBinaryDataCollectionMappingNodeValue(BinaryDataCollectionMapping mapping) {
        this.xmlBinaryDataCollectionMapping = mapping;
    }

    @Override
    public void setContainerInstance(Object object, Object containerInstance) {
        this.xmlBinaryDataCollectionMapping.setAttributeValueInObject(object, containerInstance);
    }

    @Override
    public Object getContainerInstance() {
        return this.getContainerPolicy().containerInstance();
    }

    @Override
    public CoreContainerPolicy getContainerPolicy() {
        return this.xmlBinaryDataCollectionMapping.getContainerPolicy();
    }

    protected String getValueToWrite(QName schemaType, Object value, CoreAbstractSession session) {
        return (String)((ConversionManager)session.getDatasourcePlatform().getConversionManager()).convertObject(value, CoreClassConstants.STRING, schemaType);
    }

    @Override
    public boolean isOwningNode(XPathFragment xPathFragment) {
        return xPathFragment.getNextFragment() == null || xPathFragment.isAttribute();
    }

    @Override
    public boolean isWrapperAllowedAsCollectionName() {
        return true;
    }

    @Override
    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, CoreAbstractSession session, NamespaceResolver namespaceResolver) {
        Object iterator;
        if (this.xmlBinaryDataCollectionMapping.isReadOnly()) {
            return false;
        }
        Object collection = this.xmlBinaryDataCollectionMapping.getAttributeAccessor().getAttributeValueFromObject(object);
        if (null == collection) {
            AbstractNullPolicy wrapperNP = this.xmlBinaryDataCollectionMapping.getWrapperNullPolicy();
            if (wrapperNP != null && wrapperNP.getMarshalNullRepresentation() == XMLNullRepresentationType.XSI_NIL) {
                marshalRecord.nilSimple(namespaceResolver);
                return true;
            }
            return false;
        }
        CoreContainerPolicy cp = this.getContainerPolicy();
        if (!cp.hasNext(iterator = cp.iteratorFor(collection))) {
            return marshalRecord.emptyCollection(xPathFragment, namespaceResolver, this.xmlBinaryDataCollectionMapping.getWrapperNullPolicy() != null);
        }
        XPathFragment groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
        marshalRecord.closeStartGroupingElements(groupingFragment);
        int valueSize = cp.sizeFor(collection);
        if (((Marshaller)marshalRecord.getMarshaller()).isApplicationJSON() && (valueSize > 1 || !((Marshaller)marshalRecord.getMarshaller()).isReduceAnyArrays())) {
            marshalRecord.startCollection();
        }
        while (cp.hasNext(iterator)) {
            Object objectValue = cp.next(iterator, session);
            this.marshalSingleValue(xPathFragment, marshalRecord, object, objectValue, session, namespaceResolver, ObjectMarshalContext.getInstance());
        }
        if (((Marshaller)marshalRecord.getMarshaller()).isApplicationJSON() && (valueSize > 1 || !((Marshaller)marshalRecord.getMarshaller()).isReduceAnyArrays())) {
            marshalRecord.endCollection();
        }
        return true;
    }

    @Override
    public boolean startElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Attributes atts) {
        try {
            Field xmlField = (Field)this.xmlBinaryDataCollectionMapping.getField();
            XPathFragment lastFragment = xmlField.getLastXPathFragment();
            if (!lastFragment.isAttribute()) {
                BinaryMappingContentHandler handler = new BinaryMappingContentHandler(unmarshalRecord, (NodeValue)this, this.xmlBinaryDataCollectionMapping);
                Object qnameString = xPathFragment.getLocalName();
                if (xPathFragment.getPrefix() != null) {
                    qnameString = xPathFragment.getPrefix() + ":" + (String)qnameString;
                }
                handler.startElement(xPathFragment.getNamespaceURI(), xPathFragment.getLocalName(), (String)qnameString, atts);
                XMLReader xmlReader = unmarshalRecord.getXMLReader();
                xmlReader.setContentHandler(handler);
                xmlReader.setLexicalHandler(handler);
            } else if (lastFragment.isAttribute()) {
                String value = atts.getValue(lastFragment.getNamespaceURI(), lastFragment.getLocalName());
                Object fieldValue = null;
                if (this.xmlBinaryDataCollectionMapping.isSwaRef()) {
                    if (((Unmarshaller)unmarshalRecord.getUnmarshaller()).getAttachmentUnmarshaller() != null) {
                        fieldValue = this.xmlBinaryDataCollectionMapping.getAttributeClassification() == XMLBinaryDataHelper.getXMLBinaryDataHelper().DATA_HANDLER ? (Object)((Unmarshaller)unmarshalRecord.getUnmarshaller()).getAttachmentUnmarshaller().getAttachmentAsDataHandler(value) : ((Unmarshaller)unmarshalRecord.getUnmarshaller()).getAttachmentUnmarshaller().getAttachmentAsByteArray(value);
                        this.xmlBinaryDataCollectionMapping.setAttributeValueInObject(unmarshalRecord.getCurrentObject(), XMLBinaryDataHelper.getXMLBinaryDataHelper().convertObject(fieldValue, this.xmlBinaryDataCollectionMapping.getAttributeClassification(), (CoreAbstractSession)unmarshalRecord.getSession(), (CoreContainerPolicy)this.xmlBinaryDataCollectionMapping.getContainerPolicy()));
                    }
                } else {
                    fieldValue = ((ConversionManager)((CoreAbstractSession)unmarshalRecord.getSession()).getDatasourcePlatform().getConversionManager()).convertSchemaBase64ToByteArray(value);
                    this.xmlBinaryDataCollectionMapping.setAttributeValueInObject(unmarshalRecord.getCurrentObject(), XMLBinaryDataHelper.getXMLBinaryDataHelper().convertObject(fieldValue, this.xmlBinaryDataCollectionMapping.getAttributeClassification(), (CoreAbstractSession)unmarshalRecord.getSession(), (CoreContainerPolicy)this.xmlBinaryDataCollectionMapping.getContainerPolicy()));
                }
            }
            return true;
        }
        catch (SAXException ex) {
            throw XMLMarshalException.unmarshalException(ex);
        }
    }

    @Override
    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord) {
        unmarshalRecord.resetStringBuffer();
    }

    @Override
    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Object container) {
        this.endElement(xPathFragment, unmarshalRecord);
    }

    public DataHandler getDataHandlerForObjectValue(Object obj, Class classification) {
        if (classification == DataHandler.class) {
            return (DataHandler)obj;
        }
        return null;
    }

    @Override
    public boolean isContainerValue() {
        return true;
    }

    @Override
    public boolean marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object objectValue, CoreAbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        String mimeType;
        Object marshaller = marshalRecord.getMarshaller();
        if ((objectValue = this.xmlBinaryDataCollectionMapping.convertObjectValueToDataValue(objectValue, session, marshaller)) == null) {
            AbstractNullPolicy nullPolicy = this.xmlBinaryDataCollectionMapping.getNullPolicy();
            if (nullPolicy.getMarshalNullRepresentation() != XMLNullRepresentationType.ABSENT_NODE) {
                XPathNode holderXPathNode = new XPathNode();
                holderXPathNode.setXPathFragment(xPathFragment);
                marshalRecord.addGroupingElement(holderXPathNode);
                boolean returnVal = this.xmlBinaryDataCollectionMapping.getNullPolicy().directMarshal(xPathFragment, marshalRecord, object, session, namespaceResolver);
                if (returnVal) {
                    marshalRecord.endElement(xPathFragment, namespaceResolver);
                }
                marshalRecord.removeGroupingElement(holderXPathNode);
                return returnVal;
            }
            return true;
        }
        String attachmentType = mimeType = this.xmlBinaryDataCollectionMapping.getMimeType(object);
        if (mimeType == null) {
            mimeType = "";
            attachmentType = "application/octet-stream";
        }
        marshalRecord.openStartElement(xPathFragment, namespaceResolver);
        marshalRecord.closeStartElement();
        if (this.xmlBinaryDataCollectionMapping.isSwaRef() && ((Marshaller)marshaller).getAttachmentMarshaller() != null) {
            String c_id = null;
            byte[] bytes = null;
            if (this.xmlBinaryDataCollectionMapping.getAttributeElementClass() == XMLBinaryDataHelper.getXMLBinaryDataHelper().DATA_HANDLER) {
                c_id = ((Marshaller)marshaller).getAttachmentMarshaller().addSwaRefAttachment((DataHandler)objectValue);
            } else {
                XMLBinaryDataHelper.EncodedData data = XMLBinaryDataHelper.getXMLBinaryDataHelper().getBytesForBinaryValue(objectValue, (Marshaller)marshaller, this.xmlBinaryDataCollectionMapping.getMimeType(object));
                bytes = data.getData();
                c_id = ((Marshaller)marshaller).getAttachmentMarshaller().addSwaRefAttachment(bytes, 0, bytes.length);
            }
            if (c_id != null) {
                marshalRecord.characters(c_id);
            } else {
                marshalRecord.characters(((Field)this.xmlBinaryDataCollectionMapping.getField()).getSchemaType(), objectValue, mimeType, false);
            }
        } else if (marshalRecord.isXOPPackage() && !this.xmlBinaryDataCollectionMapping.shouldInlineBinaryData()) {
            XPathFragment lastFrag = ((Field)this.xmlBinaryDataCollectionMapping.getField()).getLastXPathFragment();
            String c_id = "";
            byte[] bytes = null;
            if (objectValue.getClass() == CoreClassConstants.APBYTE) {
                bytes = (byte[])objectValue;
                c_id = ((Marshaller)marshaller).getAttachmentMarshaller().addMtomAttachment(bytes, 0, bytes.length, attachmentType, lastFrag.getLocalName(), lastFrag.getNamespaceURI());
            } else if (this.xmlBinaryDataCollectionMapping.getAttributeElementClass() == XMLBinaryDataHelper.getXMLBinaryDataHelper().DATA_HANDLER) {
                c_id = ((Marshaller)marshaller).getAttachmentMarshaller().addMtomAttachment((DataHandler)objectValue, lastFrag.getLocalName(), lastFrag.getNamespaceURI());
            } else {
                XMLBinaryDataHelper.EncodedData data = XMLBinaryDataHelper.getXMLBinaryDataHelper().getBytesForBinaryValue(objectValue, (Marshaller)marshaller, this.xmlBinaryDataCollectionMapping.getMimeTypePolicy().getMimeType(object));
                bytes = data.getData();
                c_id = ((Marshaller)marshaller).getAttachmentMarshaller().addMtomAttachment(bytes, 0, bytes.length, data.getMimeType(), lastFrag.getLocalName(), lastFrag.getNamespaceURI());
            }
            if (c_id == null) {
                marshalRecord.characters(((Field)this.xmlBinaryDataCollectionMapping.getField()).getSchemaType(), objectValue, mimeType, false);
            } else {
                boolean addDeclaration = false;
                String xopPrefix = null;
                if (marshalRecord.getNamespaceResolver() != null) {
                    xopPrefix = ((NamespaceResolver)marshalRecord.getNamespaceResolver()).resolveNamespaceURI("http://www.w3.org/2004/08/xop/include");
                }
                if (xopPrefix == null) {
                    addDeclaration = true;
                    xopPrefix = ((NamespaceResolver)marshalRecord.getNamespaceResolver()).generatePrefix("xop");
                    ((NamespaceResolver)marshalRecord.getNamespaceResolver()).put(xopPrefix, "http://www.w3.org/2004/08/xop/include");
                    namespaceResolver = marshalRecord.getNamespaceResolver();
                }
                XPathFragment xopInclude = new XPathFragment(xopPrefix + ":Include");
                xopInclude.setNamespaceURI("http://www.w3.org/2004/08/xop/include");
                marshalRecord.openStartElement(xopInclude, namespaceResolver);
                marshalRecord.attribute("", "href", "href", c_id);
                if (addDeclaration) {
                    marshalRecord.namespaceDeclaration(xopPrefix, "http://www.w3.org/2004/08/xop/include");
                }
                marshalRecord.closeStartElement();
                marshalRecord.endElement(xPathFragment, namespaceResolver);
                if (addDeclaration) {
                    ((NamespaceResolver)marshalRecord.getNamespaceResolver()).removeNamespace("xop");
                }
            }
        } else {
            marshalRecord.characters(((Field)this.xmlBinaryDataCollectionMapping.getField()).getSchemaType(), objectValue, mimeType, false);
        }
        marshalRecord.endElement(xPathFragment, namespaceResolver);
        return true;
    }

    @Override
    public BinaryDataCollectionMapping getMapping() {
        return this.xmlBinaryDataCollectionMapping;
    }

    @Override
    public boolean getReuseContainer() {
        return this.getMapping().getReuseContainer();
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean isDefaultEmptyContainer() {
        return this.getMapping().isDefaultEmptyContainer();
    }
}

