/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.oxm.XMLObjectBuilder;
import org.eclipse.persistence.internal.oxm.XPathEngine;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.mappings.AnyObjectMapping;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.mappings.UnmarshalKeepAsElementPolicy;
import org.eclipse.persistence.oxm.mappings.XMLAbstractAnyMapping;
import org.eclipse.persistence.oxm.mappings.XMLAnyCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.remote.DistributedSession;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLAnyObjectMapping
extends XMLAbstractAnyMapping
implements XMLMapping,
AnyObjectMapping<AbstractSession, AttributeAccessor, ContainerPolicy, XMLConverter, ClassDescriptor, DatabaseField, XMLMarshaller, Session, UnmarshalKeepAsElementPolicy, XMLUnmarshaller, XMLRecord> {
    private XMLField field;
    private boolean useXMLRoot = false;
    private boolean areOtherMappingInThisContext = true;
    private XMLConverter converter;
    private boolean isMixedContent = true;

    @Override
    public void buildBackupClone(Object clone, Object backup, UnitOfWorkImpl unitOfWork) {
        throw DescriptorException.invalidMappingOperation(this, "buildBackupClone");
    }

    @Override
    public void buildClone(Object original, CacheKey cacheKey, Object clone, Integer refreshCascade, AbstractSession cloningSession) {
        throw DescriptorException.invalidMappingOperation(this, "buildClone");
    }

    @Override
    public void buildCloneFromRow(AbstractRecord databaseRow, JoinedAttributeManager joinManager, Object clone, CacheKey sharedCacheKey, ObjectBuildingQuery sourceQuery, UnitOfWorkImpl unitOfWork, AbstractSession executionSession) {
        throw DescriptorException.invalidMappingOperation(this, "buildCloneFromRow");
    }

    @Override
    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    @Override
    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    @Override
    public Object clone() {
        XMLAnyCollectionMapping mapping = null;
        mapping = (XMLAnyCollectionMapping)super.clone();
        mapping.setContainerPolicy(this.getContainerPolicy());
        mapping.setField(this.getField());
        return mapping;
    }

    @Override
    public ChangeRecord compareForChange(Object clone, Object backup, ObjectChangeSet owner, AbstractSession session) {
        throw DescriptorException.invalidMappingOperation(this, "compareForChange");
    }

    @Override
    public boolean compareObjects(Object firstObject, Object secondObject, AbstractSession session) {
        throw DescriptorException.invalidMappingOperation(this, "compareObjects");
    }

    @Override
    public void fixObjectReferences(Object object, Map objectDescriptors, Map processedObjects, ObjectLevelReadQuery query, DistributedSession session) {
        throw DescriptorException.invalidMappingOperation(this, "fixObjectReferences");
    }

    @Override
    public DatabaseField getField() {
        return this.field;
    }

    @Override
    public void iterate(DescriptorIterator iterator) {
        throw DescriptorException.invalidMappingOperation(this, "iterate");
    }

    public void setXPath(String xpath) {
        this.field = new XMLField(xpath);
    }

    @Override
    public void mergeChangesIntoObject(Object target, ChangeRecord changeRecord, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        throw DescriptorException.invalidMappingOperation(this, "mergeChangesIntoObject");
    }

    @Override
    public void mergeIntoObject(Object target, boolean isTargetUninitialized, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        throw DescriptorException.invalidMappingOperation(this, "mergeIntoObject");
    }

    @Override
    public void setField(DatabaseField field) {
        this.field = (XMLField)field;
    }

    @Override
    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, CacheKey cacheKey, AbstractSession executionSession, boolean isTargetProtected, Boolean[] wasCacheUsed) throws DatabaseException {
        XMLRecord record = (XMLRecord)row;
        if (this.getField() != null) {
            Object nested = record.get(this.getField());
            if (nested instanceof Vector) {
                nested = ((Vector)nested).firstElement();
            }
            if (!(nested instanceof XMLRecord)) {
                return null;
            }
            record = (XMLRecord)nested;
        }
        return this.buildObjectValuesFromDOMRecord((DOMRecord)record, executionSession, sourceQuery, joinManager);
    }

    private Object buildObjectValuesFromDOMRecord(DOMRecord record, AbstractSession session, ObjectBuildingQuery query, JoinedAttributeManager joinManager) {
        Node root = record.getDOM();
        NodeList nodes = root.getChildNodes();
        ArrayList unmappedChildren = this.getUnmappedChildNodes(nodes);
        Iterator iter = unmappedChildren.iterator();
        int i = 0;
        int length = unmappedChildren.size();
        while (iter.hasNext()) {
            Object objectValue = null;
            Node next = (Node)iter.next();
            if (next.getNodeType() == 3) {
                if (i == length - 1 || next.getNodeValue().trim().length() > 0) {
                    objectValue = next.getNodeValue();
                    objectValue = this.convertDataValueToObjectValue(objectValue, session, record.getUnmarshaller());
                    return objectValue;
                }
            } else if (next.getNodeType() == 1) {
                XMLDescriptor referenceDescriptor = null;
                DOMRecord nestedRecord = (DOMRecord)record.buildNestedRow((Element)next);
                if (!this.useXMLRoot) {
                    return this.buildObjectForNonXMLRoot(this.getDescriptor(nestedRecord, session, null), this.getConverter(), query, record, nestedRecord, joinManager, session, next, null, null);
                }
                String schemaType = ((Element)next).getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
                QName schemaTypeQName = null;
                XPathFragment frag = new XPathFragment();
                if (null != schemaType && schemaType.length() > 0) {
                    frag.setXPath(schemaType);
                    if (frag.hasNamespace()) {
                        String prefix = frag.getPrefix();
                        XMLPlatform xmlPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
                        String url = xmlPlatform.resolveNamespacePrefix(next, prefix);
                        frag.setNamespaceURI(url);
                        schemaTypeQName = new QName(url, frag.getLocalName());
                    }
                    XMLContext xmlContext = nestedRecord.getUnmarshaller().getXMLContext();
                    referenceDescriptor = xmlContext.getDescriptorByGlobalType(frag);
                }
                if (referenceDescriptor == null) {
                    try {
                        referenceDescriptor = this.getDescriptor(nestedRecord, session, new QName(nestedRecord.getNamespaceURI(), nestedRecord.getLocalName()));
                    }
                    catch (XMLMarshalException e) {
                        referenceDescriptor = null;
                    }
                }
                if (this.getKeepAsElementPolicy() == UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT || referenceDescriptor == null && this.getKeepAsElementPolicy() == UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT) {
                    Object objVal = this.buildObjectNoReferenceDescriptor(nestedRecord, this.getConverter(), session, next, null, null);
                    if (referenceDescriptor != null) {
                        return referenceDescriptor.wrapObjectInXMLRoot(objVal, next.getNamespaceURI(), next.getLocalName(), next.getPrefix(), false, record.isNamespaceAware(), record.getUnmarshaller());
                    }
                    return this.buildXMLRoot(next, objVal);
                }
                if (referenceDescriptor != null) {
                    return this.buildObjectAndWrapInXMLRoot(referenceDescriptor, this.getConverter(), query, record, nestedRecord, joinManager, session, next, null, null);
                }
                XMLRoot rootValue = this.buildXMLRootForText(next, schemaTypeQName, this.getConverter(), session, record);
                if (rootValue != null) {
                    return rootValue;
                }
            }
            ++i;
        }
        return null;
    }

    @Override
    public void writeFromObjectIntoRow(Object object, AbstractRecord row, AbstractSession session, DatabaseMapping.WriteType writeType) throws DescriptorException {
        if (this.isReadOnly()) {
            return;
        }
        Object attributeValue = this.getAttributeValueFromObject(object);
        if (attributeValue == null) {
            return;
        }
        this.writeSingleValue(attributeValue, object, (XMLRecord)row, session);
    }

    @Override
    public void writeSingleValue(Object value, Object parent, XMLRecord row, AbstractSession session) {
        DOMRecord record = (DOMRecord)row;
        Node root = record.getDOM();
        Object objectValue = value;
        objectValue = this.convertObjectValueToDataValue(objectValue, session, row.getMarshaller());
        if (this.field != null) {
            root = XPathEngine.getInstance().create((XMLField)this.getField(), root, session);
        }
        Document doc = record.getDocument();
        XMLField xmlRootField = null;
        boolean wasXMLRoot = false;
        Object originalObject = objectValue;
        Node toReplace = this.getNodeToReplace(root);
        if (this.usesXMLRoot() && objectValue instanceof XMLRoot) {
            xmlRootField = new XMLField();
            wasXMLRoot = true;
            XPathFragment frag = new XPathFragment();
            if (((XMLRoot)objectValue).getNamespaceURI() != null) {
                frag.setNamespaceURI(((XMLRoot)objectValue).getNamespaceURI());
            }
            frag.setXPath(((XMLRoot)objectValue).getLocalName());
            xmlRootField.setXPathFragment(frag);
            xmlRootField.setNamespaceResolver(row.getNamespaceResolver());
            objectValue = ((XMLRoot)objectValue).getObject();
        }
        if (objectValue instanceof String) {
            this.writeSimpleValue(xmlRootField, record, session, originalObject, objectValue, root, toReplace, wasXMLRoot);
        } else if (objectValue instanceof Node) {
            Node importedCopy = doc.importNode((Node)objectValue, true);
            root.appendChild(importedCopy);
        } else {
            DOMRecord nestedRecord;
            XMLDescriptor referenceDescriptor = (XMLDescriptor)session.getDescriptor(objectValue.getClass());
            if (referenceDescriptor == null) {
                this.writeSimpleValue(xmlRootField, record, session, originalObject, objectValue, root, toReplace, wasXMLRoot);
                return;
            }
            if (wasXMLRoot && ((XMLRoot)originalObject).getNamespaceURI() != null) {
                String prefix = referenceDescriptor.getNonNullNamespaceResolver().resolveNamespaceURI(((XMLRoot)originalObject).getNamespaceURI());
                if (prefix == null || prefix.length() == 0) {
                    prefix = row.getNamespaceResolver().resolveNamespaceURI(((XMLRoot)originalObject).getNamespaceURI());
                }
                if (prefix == null || prefix.length() == 0) {
                    xmlRootField.getXPathFragment().setGeneratedPrefix(true);
                    prefix = row.getNamespaceResolver().generatePrefix();
                }
                xmlRootField.getXPathFragment().setXPath(prefix + ":" + ((XMLRoot)originalObject).getLocalName());
            }
            if ((nestedRecord = (DOMRecord)this.buildCompositeRow(objectValue, session, referenceDescriptor, row, xmlRootField, originalObject, wasXMLRoot)) != null && toReplace != null) {
                if (nestedRecord.getDOM() != toReplace) {
                    root.replaceChild(nestedRecord.getDOM(), toReplace);
                }
            } else if (nestedRecord != null) {
                root.appendChild(nestedRecord.getDOM());
            } else if (toReplace != null) {
                root.removeChild(toReplace);
            }
        }
    }

    protected AbstractRecord buildCompositeRow(Object attributeValue, AbstractSession session, XMLDescriptor referenceDescriptor, AbstractRecord parentRow, DatabaseField field, Object originalObject, boolean wasXMLRoot) {
        String defaultRootElementString = null;
        if (referenceDescriptor != null) {
            defaultRootElementString = referenceDescriptor.getDefaultRootElement();
            if (!wasXMLRoot && defaultRootElementString == null) {
                throw XMLMarshalException.defaultRootElementNotSpecified((XMLDescriptor)this.descriptor);
            }
        }
        if (field == null && referenceDescriptor != null && defaultRootElementString != null) {
            field = referenceDescriptor.buildField(defaultRootElementString);
        }
        if (field != null && referenceDescriptor != null) {
            ((XMLRecord)parentRow).setLeafElementType(referenceDescriptor.getDefaultRootElementType());
            XMLObjectBuilder objectBuilder = (XMLObjectBuilder)referenceDescriptor.getObjectBuilder();
            XMLRecord child = (XMLRecord)objectBuilder.createRecordFor(attributeValue, (XMLField)field, (XMLRecord)parentRow, this);
            child.setNamespaceResolver(((XMLRecord)parentRow).getNamespaceResolver());
            objectBuilder.buildIntoNestedRow(child, originalObject, attributeValue, session, referenceDescriptor, (XMLField)field, wasXMLRoot);
            return child;
        }
        return null;
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        if (this.getField() != null) {
            this.setField(this.getDescriptor().buildField(this.getField()));
        }
        if (null != this.converter) {
            this.converter.initialize(this, session);
        }
    }

    @Override
    public boolean isXMLMapping() {
        return true;
    }

    @Override
    public Vector getFields() {
        return this.collectFields();
    }

    @Override
    public void setUseXMLRoot(boolean useXMLRoot) {
        this.useXMLRoot = useXMLRoot;
    }

    @Override
    public boolean usesXMLRoot() {
        return this.useXMLRoot;
    }

    private ArrayList getUnmappedChildNodes(NodeList nodes) {
        ArrayList<Node> unmappedNodes = new ArrayList<Node>();
        int length = nodes.getLength();
        for (int i = 0; i < length; ++i) {
            Node next = nodes.item(i);
            if (!this.isUnmappedContent(next)) continue;
            unmappedNodes.add(next);
        }
        return unmappedNodes;
    }

    private XPathFragment getFragmentToCompare(XMLField field, XMLField context) {
        if (field == null) {
            return null;
        }
        if (context == null) {
            return field.getXPathFragment();
        }
        XPathFragment fieldFrag = field.getXPathFragment();
        for (XPathFragment contextFrag = context.getXPathFragment(); fieldFrag != null && contextFrag != null; contextFrag = contextFrag.getNextFragment(), fieldFrag = fieldFrag.getNextFragment()) {
            if (fieldFrag.equals(contextFrag)) {
                if (contextFrag.getNextFragment() != null) continue;
                return fieldFrag.getNextFragment();
            }
            return null;
        }
        return null;
    }

    private boolean isUnmappedContent(Node node) {
        if (!this.areOtherMappingInThisContext) {
            return true;
        }
        XMLDescriptor parentDesc = (XMLDescriptor)this.getDescriptor();
        XMLField field = (XMLField)this.getField();
        Iterator<DatabaseMapping> mappings = parentDesc.getMappings().iterator();
        int mappingsInContext = 0;
        while (mappings.hasNext()) {
            XMLField nextField;
            XPathFragment frag;
            DatabaseMapping next = mappings.next();
            if (next != this && (frag = this.getFragmentToCompare(nextField = (XMLField)next.getField(), field)) != null) {
                ++mappingsInContext;
                if ((node.getNodeType() == 3 || node.getNodeType() == 4) && frag.nameIsText()) {
                    return false;
                }
                if (node.getNodeType() == 1) {
                    String nodeNS = node.getNamespaceURI();
                    String fragNS = frag.getNamespaceURI();
                    String nodeLocalName = node.getLocalName();
                    String fragLocalName = frag.getLocalName();
                    if ((nodeNS == fragNS || nodeNS != null && fragNS != null && nodeNS.equals(fragNS)) && (nodeLocalName == fragLocalName || nodeLocalName != null && fragLocalName != null && nodeLocalName.equals(fragLocalName))) {
                        return false;
                    }
                }
            }
            if (mappingsInContext != 0) continue;
            this.areOtherMappingInThisContext = false;
        }
        return true;
    }

    public Node getNodeToReplace(Node parent) {
        for (Node next = parent.getFirstChild(); next != null; next = next.getNextSibling()) {
            if (next.getNodeType() != 1 && next.getNodeType() != 3 && next.getNodeType() != 4 || !this.isUnmappedContent(next)) continue;
            return next;
        }
        return null;
    }

    private void writeSimpleValue(XMLField xmlRootField, DOMRecord row, AbstractSession session, Object originalObject, Object value, Node root, Node toReplace, boolean wasXMLRoot) {
        Document doc = row.getDocument();
        if (wasXMLRoot && ((XMLRoot)originalObject).getNamespaceURI() != null) {
            String prefix = row.getNamespaceResolver().resolveNamespaceURI(((XMLRoot)originalObject).getNamespaceURI());
            if (prefix == null || prefix.length() == 0) {
                xmlRootField.getXPathFragment().setGeneratedPrefix(true);
                prefix = row.getNamespaceResolver().generatePrefix();
            }
            xmlRootField.getXPathFragment().setXPath(prefix + ":" + ((XMLRoot)originalObject).getLocalName());
        }
        if (null == xmlRootField) {
            Text textNode = doc.createTextNode((String)value);
            if (toReplace != null) {
                root.replaceChild(textNode, toReplace);
            } else {
                root.appendChild(textNode);
            }
        } else {
            QName qname = ((XMLRoot)originalObject).getSchemaType();
            if (qname != null && !qname.equals(XMLConstants.STRING_QNAME)) {
                xmlRootField.setSchemaType(qname);
                xmlRootField.setIsTypedTextField(true);
                xmlRootField.addJavaConversion(value.getClass(), qname);
            }
            Node node = XPathEngine.getInstance().create(xmlRootField, root, value, session);
        }
    }

    public XMLConverter getConverter() {
        return this.converter;
    }

    @Override
    public void setConverter(XMLConverter converter) {
        this.converter = converter;
    }

    @Override
    public boolean isMixedContent() {
        return this.isMixedContent;
    }

    @Override
    public void setMixedContent(boolean mixed) {
        this.isMixedContent = mixed;
    }

    @Override
    public Object convertObjectValueToDataValue(Object value, Session session, XMLMarshaller marshaller) {
        if (null != this.converter) {
            return this.converter.convertObjectValueToDataValue(value, session, marshaller);
        }
        return value;
    }

    @Override
    public Object convertDataValueToObjectValue(Object fieldValue, Session session, XMLUnmarshaller unmarshaller) {
        if (null != this.converter) {
            return this.converter.convertDataValueToObjectValue(fieldValue, session, unmarshaller);
        }
        return fieldValue;
    }
}

