/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.DataHelper;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.impl.HelperProvider;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.sdo.SDOConstants;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.SDOTypeHelper;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;

public class SDODataHelper
implements DataHelper {
    private HelperContext aHelperContext;

    public SDODataHelper() {
    }

    public SDODataHelper(HelperContext aContext) {
        this.aHelperContext = aContext;
    }

    private XMLConversionManager getXMLConversionManager() {
        return ((SDOXMLHelper)this.getHelperContext().getXMLHelper()).getXmlConversionManager();
    }

    public void setTimeZone(TimeZone timeZone) {
        if (null == timeZone) {
            this.getXMLConversionManager().setTimeZone(TimeZone.getTimeZone("GMT"));
        } else {
            this.getXMLConversionManager().setTimeZone(timeZone);
        }
    }

    public void setTimeZoneQualified(boolean timeZoneQualified) {
        this.getXMLConversionManager().setTimeZoneQualified(timeZoneQualified);
    }

    private Calendar toCalendar(Duration dur, Locale loc) {
        Calendar cal = loc == null ? Calendar.getInstance(this.getXMLConversionManager().getTimeZone()) : Calendar.getInstance(this.getXMLConversionManager().getTimeZone(), loc);
        cal.setTimeInMillis(dur.getTimeInMillis(cal));
        cal.set(1, dur.getYears());
        cal.set(2, dur.getMonths() - 1);
        cal.set(5, dur.getDays());
        cal.set(11, dur.getHours());
        cal.set(12, dur.getMinutes());
        cal.set(13, dur.getSeconds());
        return cal;
    }

    @Override
    public Calendar toCalendar(String dateString) {
        return this.toCalendar(dateString, null);
    }

    @Override
    public Calendar toCalendar(String dateString, Locale locale) {
        GregorianCalendar cal;
        if (null == dateString) {
            return null;
        }
        if (dateString.startsWith("P")) {
            return this.toCalendar(this.getXMLConversionManager().convertStringToDuration(dateString), locale);
        }
        XMLGregorianCalendar xgc = this.getXMLConversionManager().convertStringToXMLGregorianCalendar(dateString);
        if (xgc.getTimezone() == Integer.MIN_VALUE) {
            cal = xgc.toGregorianCalendar(this.getXMLConversionManager().getTimeZone(), locale, null);
            cal.clear(15);
        } else {
            cal = xgc.toGregorianCalendar(xgc.getTimeZone(xgc.getTimezone()), locale, null);
        }
        return cal;
    }

    @Override
    public Date toDate(String dateString) {
        if (null == dateString) {
            return null;
        }
        if (dateString.startsWith("P")) {
            Calendar cal = this.toCalendar(this.getXMLConversionManager().convertStringToDuration(dateString), null);
            return cal.getTime();
        }
        try {
            return this.getXMLConversionManager().convertStringToDate(dateString, null);
        }
        catch (ConversionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public String toDateTime(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        boolean wasTimezoneQualified = this.getXMLConversionManager().isTimeZoneQualified();
        this.getXMLConversionManager().setTimeZoneQualified(false);
        String s = this.getXMLConversionManager().stringFromCalendar(calendar, XMLConstants.DATE_TIME_QNAME);
        this.getXMLConversionManager().setTimeZoneQualified(wasTimezoneQualified);
        return s;
    }

    @Override
    public String toDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return this.getXMLConversionManager().stringFromDate(date, XMLConstants.DATE_TIME_QNAME);
    }

    @Override
    public String toDay(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        boolean wasTimezoneQualified = this.getXMLConversionManager().isTimeZoneQualified();
        this.getXMLConversionManager().setTimeZoneQualified(false);
        String s = this.getXMLConversionManager().stringFromCalendar(calendar, XMLConstants.G_DAY_QNAME);
        this.getXMLConversionManager().setTimeZoneQualified(wasTimezoneQualified);
        return s;
    }

    @Override
    public String toDay(Date date) {
        if (date == null) {
            return null;
        }
        return this.getXMLConversionManager().stringFromDate(date, XMLConstants.G_DAY_QNAME);
    }

    @Override
    public String toDuration(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        StringBuffer dur = new StringBuffer();
        dur.append("P");
        dur.append(calendar.get(1));
        dur.append("Y");
        dur.append(calendar.get(2) + 1);
        dur.append("M");
        dur.append(calendar.get(5));
        dur.append("DT");
        dur.append(calendar.get(10));
        dur.append("H");
        dur.append(calendar.get(12));
        dur.append("M");
        float s = calendar.get(13) * 1000 + calendar.get(14);
        dur.append(s / 1000.0f);
        dur.append("S");
        return dur.toString();
    }

    @Override
    public String toDuration(Date date) {
        if (date == null) {
            return null;
        }
        Calendar outPut = Calendar.getInstance();
        outPut.setTime(date);
        outPut.setTimeZone(TimeZone.getTimeZone("GMT"));
        return this.toDuration(outPut);
    }

    @Override
    public String toMonth(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        boolean wasTimezoneQualified = this.getXMLConversionManager().isTimeZoneQualified();
        this.getXMLConversionManager().setTimeZoneQualified(false);
        String s = this.getXMLConversionManager().stringFromCalendar(calendar, XMLConstants.G_MONTH_QNAME);
        this.getXMLConversionManager().setTimeZoneQualified(wasTimezoneQualified);
        return s;
    }

    @Override
    public String toMonth(Date date) {
        if (date == null) {
            return null;
        }
        boolean wasTimezoneQualified = this.getXMLConversionManager().isTimeZoneQualified();
        this.getXMLConversionManager().setTimeZoneQualified(false);
        String s = this.getXMLConversionManager().stringFromDate(date, XMLConstants.G_MONTH_QNAME);
        this.getXMLConversionManager().setTimeZoneQualified(wasTimezoneQualified);
        return s;
    }

    @Override
    public String toMonthDay(Calendar calendar) {
        int month;
        if (calendar == null) {
            return null;
        }
        Object monthDay = "--";
        boolean isSetZoneOffset = calendar.isSet(15);
        if (!calendar.isSet(2) || !calendar.isSet(5)) {
            // empty if block
        }
        if ((month = calendar.get(2) + 1) < 10) {
            monthDay = (String)monthDay + "0";
        }
        monthDay = (String)monthDay + month + "-";
        int day = calendar.get(5);
        if (day < 10) {
            monthDay = (String)monthDay + "0";
        }
        monthDay = (String)monthDay + day;
        if (isSetZoneOffset) {
            int zoneOffset = calendar.get(15);
            if (0 != zoneOffset) {
                if (zoneOffset > 0) {
                    monthDay = (String)monthDay + "+";
                } else {
                    monthDay = (String)monthDay + "-";
                    zoneOffset *= -1;
                }
                double hours = (double)zoneOffset / 3600000.0;
                if (hours < 10.0) {
                    monthDay = (String)monthDay + "0";
                }
                monthDay = (String)monthDay + (int)hours + ":";
                int minutes = (int)((hours - (double)((int)hours)) * 60.0);
                if (minutes < 10) {
                    monthDay = (String)monthDay + "0";
                }
                monthDay = (String)monthDay + minutes;
            } else {
                monthDay = (String)monthDay + "Z";
            }
        }
        return monthDay;
    }

    @Override
    public String toMonthDay(Date date) {
        if (null == date) {
            return null;
        }
        GregorianCalendar dateCalendar = new GregorianCalendar(this.getXMLConversionManager().getTimeZone());
        dateCalendar.clear();
        dateCalendar.setTime(date);
        dateCalendar.clear(15);
        return this.toMonthDay(dateCalendar);
    }

    @Override
    public String toTime(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        boolean wasTimezoneQualified = this.getXMLConversionManager().isTimeZoneQualified();
        this.getXMLConversionManager().setTimeZoneQualified(false);
        String s = this.getXMLConversionManager().stringFromCalendar(calendar, XMLConstants.TIME_QNAME);
        this.getXMLConversionManager().setTimeZoneQualified(wasTimezoneQualified);
        return s;
    }

    @Override
    public String toTime(Date date) {
        if (date == null) {
            return null;
        }
        return this.getXMLConversionManager().stringFromDate(date, XMLConstants.TIME_QNAME);
    }

    @Override
    public String toYear(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        boolean wasTimezoneQualified = this.getXMLConversionManager().isTimeZoneQualified();
        this.getXMLConversionManager().setTimeZoneQualified(false);
        String s = this.getXMLConversionManager().stringFromCalendar(calendar, XMLConstants.G_YEAR_QNAME);
        this.getXMLConversionManager().setTimeZoneQualified(wasTimezoneQualified);
        return s;
    }

    @Override
    public String toYear(Date date) {
        if (date == null) {
            return null;
        }
        return this.getXMLConversionManager().stringFromDate(date, XMLConstants.G_YEAR_QNAME);
    }

    @Override
    public String toYearMonth(Date date) {
        if (date == null) {
            return null;
        }
        return this.getXMLConversionManager().stringFromDate(date, XMLConstants.G_YEAR_MONTH_QNAME);
    }

    @Override
    public String toYearMonthDay(Date date) {
        if (date == null) {
            return null;
        }
        return this.getXMLConversionManager().stringFromDate(date, XMLConstants.DATE_QNAME);
    }

    @Override
    public String toYearMonth(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        boolean wasTimezoneQualified = this.getXMLConversionManager().isTimeZoneQualified();
        this.getXMLConversionManager().setTimeZoneQualified(false);
        String s = this.getXMLConversionManager().stringFromCalendar(calendar, XMLConstants.G_YEAR_MONTH_QNAME);
        this.getXMLConversionManager().setTimeZoneQualified(wasTimezoneQualified);
        return s;
    }

    @Override
    public String toYearMonthDay(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        boolean wasTimezoneQualified = this.getXMLConversionManager().isTimeZoneQualified();
        this.getXMLConversionManager().setTimeZoneQualified(false);
        String s = this.getXMLConversionManager().stringFromCalendar(calendar, XMLConstants.DATE_QNAME);
        this.getXMLConversionManager().setTimeZoneQualified(wasTimezoneQualified);
        return s;
    }

    private void setCalendar(Calendar c, int i, int data) {
        switch (i) {
            case 0: {
                c.set(1, data);
                break;
            }
            case 1: {
                c.set(2, data - 1);
                break;
            }
            case 2: {
                c.set(5, data);
                break;
            }
            case 3: {
                c.set(10, data);
                break;
            }
            case 4: {
                c.set(12, data);
                break;
            }
            case 5: {
                c.set(13, data);
                break;
            }
            case 6: {
                c.set(14, data);
            }
        }
    }

    public Object convertValue(Object value, Class convertClass, QName schemaType) {
        return this.getXMLConversionManager().convertObject(value, convertClass, schemaType);
    }

    public Object convertFromStringValue(String value, Class convertClass) {
        if (convertClass == ClassConstants.UTILDATE) {
            return this.toDate(value);
        }
        if (convertClass == ClassConstants.CALENDAR) {
            return this.toCalendar(value);
        }
        if (value == "" && (convertClass == ClassConstants.LONG || convertClass == ClassConstants.SHORT || convertClass == ClassConstants.INTEGER || convertClass == ClassConstants.FLOAT || convertClass == ClassConstants.DOUBLE || convertClass == ClassConstants.BOOLEAN || convertClass == ClassConstants.CHAR || convertClass == ClassConstants.QNAME)) {
            return null;
        }
        return this.getXMLConversionManager().convertObject(value, convertClass);
    }

    public Object convertFromStringValue(String value, Type sdoType) {
        return this.convertFromStringValue(value, sdoType, null);
    }

    public Object convertFromStringValue(String value, Type sdoType, QName schemaType) {
        Class convertClass = ((SDOTypeHelper)this.getHelperContext().getTypeHelper()).getJavaWrapperTypeForSDOType(sdoType);
        if (convertClass != null) {
            if (schemaType == null) {
                return ((SDODataHelper)this.getHelperContext().getDataHelper()).convertFromStringValue(value, convertClass);
            }
            return ((SDODataHelper)this.getHelperContext().getDataHelper()).convertFromStringValue(value, convertClass, schemaType);
        }
        return value;
    }

    public Object convertFromStringValue(String value, Class convertClass, QName schemaType) {
        if (convertClass == ClassConstants.UTILDATE) {
            return this.toDate(value);
        }
        if (convertClass == ClassConstants.CALENDAR) {
            return this.toCalendar(value);
        }
        return this.getXMLConversionManager().convertObject(value, convertClass, schemaType);
    }

    public String convertToStringValue(Object value, Type sdoType) {
        return this.convertToStringValue(value, sdoType, null);
    }

    private String convertToStringValue(Object value, Type sdoType, QName xsdType) {
        if (value.getClass() == ClassConstants.CALENDAR) {
            if (sdoType.equals(SDOConstants.SDO_DATETIME)) {
                return this.toDateTime((Calendar)value);
            }
            if (sdoType.equals(SDOConstants.SDO_TIME)) {
                return this.toTime((Calendar)value);
            }
            if (sdoType.equals(SDOConstants.SDO_DAY)) {
                return this.toDay((Calendar)value);
            }
            if (sdoType.equals(SDOConstants.SDO_DURATION)) {
                return this.toDuration((Calendar)value);
            }
            if (sdoType.equals(SDOConstants.SDO_MONTH)) {
                return this.toMonth((Calendar)value);
            }
            if (sdoType.equals(SDOConstants.SDO_MONTHDAY)) {
                return this.toMonthDay((Calendar)value);
            }
            if (sdoType.equals(SDOConstants.SDO_YEAR)) {
                return this.toYear((Calendar)value);
            }
            if (sdoType.equals(SDOConstants.SDO_YEARMONTH)) {
                return this.toYearMonth((Calendar)value);
            }
            if (sdoType.equals(SDOConstants.SDO_YEARMONTHDAY)) {
                return this.toYearMonthDay((Calendar)value);
            }
        } else if (value.getClass() == ClassConstants.UTILDATE) {
            if (sdoType.equals(SDOConstants.SDO_DATETIME)) {
                return this.toDateTime((Date)value);
            }
            if (sdoType.equals(SDOConstants.SDO_TIME)) {
                return this.toTime((Date)value);
            }
            if (sdoType.equals(SDOConstants.SDO_DAY)) {
                return this.toDay((Date)value);
            }
            if (sdoType.equals(SDOConstants.SDO_DURATION)) {
                return this.toDuration((Date)value);
            }
            if (sdoType.equals(SDOConstants.SDO_MONTH)) {
                return this.toMonth((Date)value);
            }
            if (sdoType.equals(SDOConstants.SDO_MONTHDAY)) {
                return this.toMonthDay((Date)value);
            }
            if (sdoType.equals(SDOConstants.SDO_YEAR)) {
                return this.toYear((Date)value);
            }
            if (sdoType.equals(SDOConstants.SDO_YEARMONTH)) {
                return this.toYearMonth((Date)value);
            }
            if (sdoType.equals(SDOConstants.SDO_YEARMONTHDAY)) {
                return this.toYearMonthDay((Date)value);
            }
        } else if (value.getClass().getName().equals("jakarta.activation.DataHandler")) {
            try {
                Class binaryDataHelper = PrivilegedAccessHelper.getClassForName("org.eclipse.persistence.internal.oxm.XMLBinaryDataHelper");
                Method getHelperMethod = PrivilegedAccessHelper.getMethod(binaryDataHelper, "getXMLBinaryDataHelper", new Class[0], false);
                Method stringToDataHandlerMethod = PrivilegedAccessHelper.getMethod(binaryDataHelper, "stringFromDataHandler", new Class[]{Object.class, QName.class, CoreAbstractSession.class}, false);
                Object helper = PrivilegedAccessHelper.invokeMethod(getHelperMethod, binaryDataHelper, new Object[0]);
                String result = (String)PrivilegedAccessHelper.invokeMethod(stringToDataHandlerMethod, helper, new Object[]{value, xsdType, ((SDOXMLHelper)this.getHelperContext().getXMLHelper()).getXmlContext().getSession()});
                return result;
            }
            catch (Exception ex) {
                return (String)this.getXMLConversionManager().convertObject(value, ClassConstants.STRING, xsdType);
            }
        }
        return (String)this.getXMLConversionManager().convertObject(value, ClassConstants.STRING, xsdType);
    }

    @Override
    public Object convert(Type type, Object value) {
        Class convertClass = null;
        if (((SDOType)type).isDataType()) {
            convertClass = type.getInstanceClass();
        }
        if (value.getClass() == ClassConstants.STRING) {
            return this.convertFromStringValue((String)value, type);
        }
        if (convertClass == ClassConstants.STRING) {
            return this.convertToStringValue(value, type);
        }
        try {
            return this.getXMLConversionManager().convertObject(value, convertClass);
        }
        catch (ConversionException e) {
            throw new IllegalArgumentException(SDOException.conversionError(e));
        }
    }

    @Override
    public Object convert(Property property, Object value) {
        if (null == property) {
            throw new IllegalArgumentException(SDOException.conversionError(null));
        }
        try {
            Type convertType = property.getType();
            if (property.isMany()) {
                if (value == null) {
                    return null;
                }
                if (!(value instanceof List)) {
                    throw new IllegalArgumentException(SDOException.conversionError(null));
                }
                List theList = (List)value;
                Object nextItem = null;
                for (int i = 0; i < theList.size(); ++i) {
                    nextItem = theList.get(i);
                    theList.set(i, this.convert(convertType, nextItem));
                }
                return theList;
            }
            return this.convert(convertType, value);
        }
        catch (ConversionException e) {
            throw SDOException.invalidPropertyValue(property.getName(), property.getType().getURI() + "#" + property.getType().getName(), value.getClass().getName(), value.toString(), e);
        }
    }

    public Object convertValueToClass(Property prop, Object valueToConvert, Class convertToClass) {
        try {
            if (valueToConvert == null) {
                return null;
            }
            if (convertToClass == ClassConstants.STRING) {
                return this.convertToStringValue(valueToConvert, prop.getType(), ((SDOProperty)prop).getXsdType());
            }
            SDOProperty sdoProp = (SDOProperty)prop;
            DatabaseMapping xmlMapping = sdoProp.getXmlMapping();
            if (xmlMapping != null && xmlMapping.isDirectToFieldMapping() && sdoProp.getXsdType() != null) {
                return this.getXMLConversionManager().convertObject(valueToConvert, convertToClass, sdoProp.getXsdType());
            }
            return this.getXMLConversionManager().convertObject(valueToConvert, convertToClass);
        }
        catch (ConversionException e) {
            throw new IllegalArgumentException(SDOException.conversionError(e));
        }
    }

    public HelperContext getHelperContext() {
        if (null == this.aHelperContext) {
            this.aHelperContext = HelperProvider.getDefaultContext();
        }
        return this.aHelperContext;
    }

    public void setHelperContext(HelperContext helperContext) {
        this.aHelperContext = helperContext;
    }
}

