/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.features;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.ItemLinks;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.LinkV2;

public final class ItemLinksBuilder {
    private final List<LinkV2> links = new ArrayList<LinkV2>();

    public ItemLinksBuilder addSelf(String href) {
        this.links.add(new LinkV2("self", href));
        return this;
    }

    public ItemLinksBuilder addCanonical(String href) {
        this.links.add(new LinkV2("canonical", href));
        return this;
    }

    public ItemLinksBuilder addCanonical(String href, String mediaType) {
        this.links.add(new LinkV2("canonical", href, mediaType));
        return this;
    }

    public ItemLinksBuilder addNext(String href) {
        this.links.add(new LinkV2("next", href));
        return this;
    }

    public ItemLinksBuilder addPrev(String href) {
        this.links.add(new LinkV2("prev", href));
        return this;
    }

    public ItemLinksBuilder addAlternate(String href) {
        this.links.add(new LinkV2("alternate", href, "application/schema+json"));
        return this;
    }

    public ItemLinksBuilder addDescribes(String href) {
        this.links.add(new LinkV2("describes", href));
        return this;
    }

    public ItemLinksBuilder addDescribedBy(String href) {
        this.links.add(new LinkV2("describedby", href));
        return this;
    }

    public ItemLinksBuilder addCreate(String href) {
        this.links.add(new LinkV2("create", href, null, "PUT"));
        return this;
    }

    public ItemLinksBuilder addFind(String href) {
        this.links.add(new LinkV2("find", href, null, "GET"));
        return this;
    }

    public ItemLinksBuilder addUpdate(String href) {
        this.links.add(new LinkV2("update", href, null, "POST"));
        return this;
    }

    public ItemLinksBuilder addDelete(String href) {
        this.links.add(new LinkV2("delete", href, null, "DELETE"));
        return this;
    }

    public ItemLinksBuilder addExecute(String href, String method) {
        this.links.add(new LinkV2("execute", href, null, method));
        return this;
    }

    public ItemLinks build() {
        ItemLinks itemLinks = new ItemLinks();
        itemLinks.setLinks(this.links);
        return itemLinks;
    }

    public List<LinkV2> getList() {
        return this.links;
    }
}

