/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.javamodel.xjc;

import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationClassValue;
import com.sun.codemodel.JAnnotationStringValue;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAnnotationValue;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JType;
import jakarta.xml.bind.annotation.XmlEnum;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.jaxb.javamodel.AnnotationProxy;
import org.eclipse.persistence.jaxb.javamodel.JavaAnnotation;

public class XJCJavaAnnotationImpl
implements JavaAnnotation {
    private JAnnotationUse xjcAnnotation;
    private DynamicClassLoader dynamicClassLoader;

    public XJCJavaAnnotationImpl(JAnnotationUse annotation, DynamicClassLoader loader) {
        this.xjcAnnotation = annotation;
        this.dynamicClassLoader = loader;
    }

    public Annotation getJavaAnnotation() {
        try {
            HashMap<String, Object> components = new HashMap<String, Object>();
            Class<?> annotationClass = this.getJavaAnnotationClass();
            Method[] methods = annotationClass.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                components.put(methods[i].getName(), methods[i].getDefaultValue());
            }
            Map memberValues = this.xjcAnnotation.getAnnotationMembers();
            if (memberValues == null) {
                return AnnotationProxy.getProxy(components, annotationClass, this.dynamicClassLoader, XMLConversionManager.getDefaultManager());
            }
            boolean isXmlEnum = annotationClass.equals(XmlEnum.class);
            for (String key : memberValues.keySet()) {
                JAnnotationValue xjcValue = (JAnnotationValue)memberValues.get(key);
                if (xjcValue instanceof JAnnotationArrayMember) {
                    Collection values = ((JAnnotationArrayMember)xjcValue).annotations2();
                    ArrayList<Object> valuesArray = new ArrayList<Object>(values.size());
                    for (JAnnotationValue val : values) {
                        if (val instanceof JAnnotationUse) {
                            JAnnotationUse xjcAnno = (JAnnotationUse)val;
                            XJCJavaAnnotationImpl anno = new XJCJavaAnnotationImpl(xjcAnno, this.dynamicClassLoader);
                            valuesArray.add(anno.getJavaAnnotation());
                            continue;
                        }
                        if (val instanceof JAnnotationStringValue) {
                            JAnnotationStringValue value = (JAnnotationStringValue)val;
                            valuesArray.add(value.toString());
                            continue;
                        }
                        if (val instanceof JAnnotationClassValue) {
                            JAnnotationClassValue cval = (JAnnotationClassValue)val;
                            valuesArray.add(this.getValueFromClsValue(cval, isXmlEnum));
                            continue;
                        }
                        throw new RuntimeException("got " + val.getClass().getName());
                    }
                    components.put(key, valuesArray.toArray(new Object[0]));
                    continue;
                }
                if (xjcValue instanceof JAnnotationStringValue) {
                    JAnnotationStringValue value = (JAnnotationStringValue)xjcValue;
                    components.put(key, value.toString());
                    continue;
                }
                if (xjcValue instanceof JAnnotationClassValue) {
                    JAnnotationClassValue cval = (JAnnotationClassValue)xjcValue;
                    components.put(key, this.getValueFromClsValue(cval, isXmlEnum));
                    continue;
                }
                throw new RuntimeException("got " + xjcValue.getClass().getName());
            }
            return AnnotationProxy.getProxy(components, annotationClass, this.dynamicClassLoader, XMLConversionManager.getDefaultManager());
        }
        catch (Exception e) {
            return null;
        }
    }

    public Class<?> getJavaAnnotationClass() {
        try {
            return Class.forName(this.getName());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public Map<Object, Object> getComponents() {
        throw new UnsupportedOperationException("getComponents");
    }

    @Override
    public String getName() {
        return this.xjcAnnotation.getAnnotationClass().binaryName();
    }

    private Object getValueFromClsValue(JAnnotationClassValue value, boolean isXmlEnum) {
        JClass cls = value.type();
        for (JType param : cls.getTypeParameters()) {
            String name = param.boxify().fullName();
            this.getTempClass(name, isXmlEnum);
        }
        Class<?> tempDynClass = this.getTempClass(cls.fullName(), isXmlEnum);
        if (tempDynClass.isEnum() && !isXmlEnum) {
            return Enum.valueOf(tempDynClass.asSubclass(Enum.class), value.value());
        }
        return tempDynClass;
    }

    private Class<?> getTempClass(String name, boolean isXmlEnum) {
        Class<Object> tempDynClass;
        try {
            tempDynClass = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            tempDynClass = isXmlEnum ? String.class : this.dynamicClassLoader.createDynamicClass(name);
        }
        return tempDynClass;
    }
}

