/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.utility.iterable.ListIterable;
import org.eclipse.persistence.jpa.jpql.utility.iterable.SnapshotCloneListIterable;

public abstract class AbstractPathExpression
extends AbstractExpression {
    private boolean endsWithDot;
    private AbstractExpression identificationVariable;
    private List<String> paths;
    private int pathSize = -1;
    private boolean startsWithDot;

    protected AbstractPathExpression(AbstractExpression parent, AbstractExpression identificationVariable) {
        super(parent);
        this.identificationVariable = identificationVariable;
        this.identificationVariable.setParent(this);
    }

    public AbstractPathExpression(AbstractExpression parent, AbstractExpression identificationVariable, String paths) {
        super(parent, paths);
        this.identificationVariable = identificationVariable;
        this.identificationVariable.setParent(this);
    }

    protected AbstractPathExpression(AbstractExpression parent, String paths) {
        super(parent, paths);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getIdentificationVariable().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        this.checkPaths();
        children.add(this.identificationVariable);
    }

    @Override
    protected final void addOrderedChildrenTo(List<Expression> children) {
        this.checkPaths();
        if (!this.hasVirtualIdentificationVariable()) {
            children.add(this.identificationVariable);
        }
        children.add(this.buildStringExpression(this.getText()));
    }

    private void checkPaths() {
        if (this.paths != null) {
            return;
        }
        this.paths = new ArrayList<String>();
        String text = this.getText();
        char character = '\u0000';
        StringBuilder singlePath = new StringBuilder();
        int count = text.length();
        for (int index = 0; index < count; ++index) {
            character = text.charAt(index);
            if (index == 0) {
                if (this.identificationVariable == null) {
                    boolean bl = this.startsWithDot = character == '.';
                    if (this.startsWithDot) continue;
                    singlePath.append(character);
                    continue;
                }
                if (!this.identificationVariable.isNull() && !this.identificationVariable.isVirtual()) {
                    this.paths.add(this.identificationVariable.toParsedText());
                    continue;
                }
                singlePath.append(character);
                continue;
            }
            if (character != '.') {
                singlePath.append(character);
                continue;
            }
            this.paths.add(singlePath.toString());
            singlePath.setLength(0);
        }
        boolean bl = this.endsWithDot = character == '.';
        if (!singlePath.isEmpty()) {
            this.paths.add(singlePath.toString());
        }
        this.pathSize = this.paths.size();
        if (this.identificationVariable == null) {
            this.identificationVariable = this.startsWithDot || !this.endsWithDot && this.pathSize == 1 ? this.buildNullExpression() : new IdentificationVariable(this, this.paths.get(0));
        }
    }

    public final boolean endsWithDot() {
        this.checkPaths();
        return this.endsWithDot;
    }

    @Override
    public final JPQLQueryBNF findQueryBNF(Expression expression) {
        if (this.identificationVariable != null && this.identificationVariable.isAncestor(expression)) {
            return this.getQueryBNF("general_identification_variable");
        }
        return super.findQueryBNF(expression);
    }

    public final Expression getIdentificationVariable() {
        this.checkPaths();
        return this.identificationVariable;
    }

    public final String getPath(int index) {
        this.checkPaths();
        return this.paths.get(index);
    }

    public final boolean hasIdentificationVariable() {
        this.checkPaths();
        return !this.identificationVariable.isNull() && !this.identificationVariable.isVirtual();
    }

    public final boolean hasVirtualIdentificationVariable() {
        this.checkPaths();
        return this.identificationVariable.isVirtual();
    }

    public final boolean hasImplicitIdentificationVariable() {
        this.checkPaths();
        return this.identificationVariable.isVirtual() && !this.paths.get(0).equals("this");
    }

    @Override
    protected final void parse(WordParser wordParser, boolean tolerant) {
        wordParser.moveForward(this.getText());
    }

    public final ListIterable<String> paths() {
        this.checkPaths();
        return new SnapshotCloneListIterable<String>(this.paths);
    }

    public final int pathSize() {
        this.checkPaths();
        return this.pathSize;
    }

    protected final void setVirtualIdentificationVariable(String variableName) {
        this.identificationVariable = new IdentificationVariable(this, variableName, true);
        this.rebuildActualText();
        this.rebuildParsedText();
    }

    public final boolean startsWithDot() {
        return this.startsWithDot;
    }

    public String toParsedText(int startIndex, int stopIndex) {
        this.checkPaths();
        StringBuilder writer = new StringBuilder();
        for (int index = startIndex; index < stopIndex; ++index) {
            writer.append(this.paths.get(index));
            if (index >= stopIndex - 1) continue;
            writer.append('.');
        }
        return writer.toString();
    }

    @Override
    protected final void toParsedText(StringBuilder writer, boolean actual) {
        this.checkPaths();
        if (this.startsWithDot) {
            writer.append('.');
        }
        int count = this.pathSize();
        for (int index = 0; index < count; ++index) {
            if (index > 0) {
                writer.append('.');
            }
            if (index == 0 && this.hasIdentificationVariable()) {
                this.identificationVariable.toParsedText(writer, actual);
                continue;
            }
            writer.append(this.paths.get(index));
        }
        if (this.endsWithDot) {
            writer.append('.');
        }
    }
}

