/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.querydef;

import jakarta.persistence.criteria.CollectionJoin;
import jakarta.persistence.criteria.Fetch;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.ListJoin;
import jakarta.persistence.criteria.MapJoin;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.SetJoin;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.CollectionAttribute;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.ListAttribute;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.MapAttribute;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.SetAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import jakarta.persistence.metamodel.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jpa.querydef.AbstractQueryImpl;
import org.eclipse.persistence.internal.jpa.querydef.BasicCollectionJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.BasicListJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.BasicMapJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.BasicSetJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.CollectionJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.ExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.JoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.ListJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.MapJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.PathImpl;
import org.eclipse.persistence.internal.jpa.querydef.SetJoinImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;

public class FromImpl<Z, X>
extends PathImpl<X>
implements From<Z, X> {
    protected ManagedType managedType;
    protected Set<Join<X, ?>> joins;
    protected Set<Fetch<X, ?>> fetches;
    protected boolean isJoin = false;
    protected boolean isFetch = false;
    protected FromImpl correlatedParent;

    public <T> FromImpl(Path<Z> parentPath, ManagedType managedType, Metamodel metamodel, Class<X> javaClass, Expression expressionNode, Bindable<T> modelArtifact) {
        super(parentPath, metamodel, javaClass, expressionNode, modelArtifact);
        this.managedType = managedType;
        this.joins = new LinkedHashSet();
        this.fetches = new LinkedHashSet();
    }

    public <T> FromImpl(Path<Z> parentPath, ManagedType managedType, Metamodel metamodel, Class<X> javaClass, Expression expressionNode, Bindable<T> modelArtifact, FromImpl correlatedParent) {
        this(parentPath, managedType, metamodel, javaClass, expressionNode, modelArtifact);
        this.correlatedParent = correlatedParent;
    }

    public Set<Fetch<X, ?>> getFetches() {
        return this.fetches;
    }

    public boolean isCorrelated() {
        return this.correlatedParent != null;
    }

    public From<Z, X> getCorrelationParent() {
        if (this.correlatedParent == null) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage("cannot_get_from_non_correlated_query"));
        }
        return this.correlatedParent;
    }

    public <Y> Fetch<X, Y> fetch(SingularAttribute<? super X, Y> assoc) {
        return this.fetch(assoc, JoinType.INNER);
    }

    public <Y> Fetch<X, Y> fetch(SingularAttribute<? super X, Y> assoc, JoinType jt) {
        if (assoc.getType().getPersistenceType().equals((Object)Type.PersistenceType.BASIC)) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage("CAN_NOT_JOIN_TO_BASIC"));
        }
        Class clazz = assoc.getBindableJavaType();
        JoinImpl join = null;
        QueryKeyExpression exp = ((ObjectExpression)this.currentNode).newDerivedExpressionNamed(assoc.getName());
        if (jt.equals((Object)JoinType.LEFT)) {
            exp.doUseOuterJoin();
        } else {
            if (jt.equals((Object)JoinType.RIGHT)) {
                throw new UnsupportedOperationException(ExceptionLocalization.buildMessage("RIGHT_JOIN_NOT_SUPPORTED"));
            }
            exp.doNotUseOuterJoin();
        }
        join = new JoinImpl(this, this.metamodel.managedType(clazz), this.metamodel, clazz, (Expression)exp, assoc, jt);
        this.fetches.add(join);
        ((FromImpl)join).isFetch = true;
        return join;
    }

    public <Y> Fetch<X, Y> fetch(PluralAttribute<? super X, ?, Y> assoc) {
        return this.fetch(assoc, JoinType.INNER);
    }

    public <Y> Fetch<X, Y> fetch(PluralAttribute<? super X, ?, Y> assoc, JoinType jt) {
        Expression node;
        if (jt.equals((Object)JoinType.LEFT)) {
            node = this.currentNode.anyOfAllowingNone(assoc.getName());
        } else {
            if (jt.equals((Object)JoinType.RIGHT)) {
                throw new UnsupportedOperationException(ExceptionLocalization.buildMessage("RIGHT_JOIN_NOT_SUPPORTED"));
            }
            node = this.currentNode.anyOf(assoc.getName());
        }
        JoinImpl fetch = assoc.getElementType().getPersistenceType().equals((Object)Type.PersistenceType.BASIC) ? (assoc.getCollectionType().equals((Object)PluralAttribute.CollectionType.COLLECTION) ? new BasicCollectionJoinImpl(this, this.metamodel, assoc.getBindableJavaType(), node, assoc, jt) : (assoc.getCollectionType().equals((Object)PluralAttribute.CollectionType.LIST) ? new BasicListJoinImpl(this, this.metamodel, assoc.getBindableJavaType(), node, assoc, jt) : (assoc.getCollectionType().equals((Object)PluralAttribute.CollectionType.SET) ? new BasicSetJoinImpl(this, this.metamodel, assoc.getBindableJavaType(), node, assoc, jt) : new BasicMapJoinImpl(this, this.metamodel, assoc.getBindableJavaType(), node, assoc, jt)))) : (assoc.getCollectionType().equals((Object)PluralAttribute.CollectionType.COLLECTION) ? new CollectionJoinImpl(this, this.metamodel.managedType(assoc.getBindableJavaType()), this.metamodel, assoc.getBindableJavaType(), node, assoc, jt) : (assoc.getCollectionType().equals((Object)PluralAttribute.CollectionType.LIST) ? new ListJoinImpl(this, this.metamodel.managedType(assoc.getBindableJavaType()), this.metamodel, assoc.getBindableJavaType(), node, assoc, jt) : (assoc.getCollectionType().equals((Object)PluralAttribute.CollectionType.SET) ? new SetJoinImpl(this, this.metamodel.managedType(assoc.getBindableJavaType()), this.metamodel, assoc.getBindableJavaType(), node, assoc, jt) : new MapJoinImpl(this, this.metamodel.managedType(assoc.getBindableJavaType()), this.metamodel, assoc.getBindableJavaType(), node, assoc, jt))));
        this.fetches.add(fetch);
        ((FromImpl)fetch).isFetch = true;
        return fetch;
    }

    public <T, Y> Fetch<T, Y> fetch(String assocName) {
        return this.fetch(assocName, JoinType.INNER);
    }

    public <T, Y> Fetch<T, Y> fetch(String assocName, JoinType jt) {
        Attribute attribute = this.managedType.getAttribute(assocName);
        if (attribute.isCollection()) {
            return this.fetch((PluralAttribute)attribute, jt);
        }
        return this.fetch((SingularAttribute)attribute, jt);
    }

    public Set<Join<X, ?>> getJoins() {
        return this.joins;
    }

    @Override
    public <Y> Path<Y> get(SingularAttribute<? super X, Y> att) {
        if (att.getPersistentAttributeType().equals((Object)Attribute.PersistentAttributeType.BASIC)) {
            return new PathImpl(this, this.metamodel, att.getBindableJavaType(), this.currentNode.get(att.getName()), (Bindable)att);
        }
        Class clazz = att.getBindableJavaType();
        JoinImpl join = new JoinImpl(this, this.metamodel.managedType(clazz), this.metamodel, clazz, this.currentNode.get(att.getName()), att);
        this.joins.add(join);
        return join;
    }

    @Override
    public <E, C extends Collection<E>> jakarta.persistence.criteria.Expression<C> get(PluralAttribute<? super X, C, E> collection) {
        return new ExpressionImpl<Class>(this.metamodel, Class.class, this.currentNode.anyOf(collection.getName()));
    }

    @Override
    public <K, V, M extends Map<K, V>> jakarta.persistence.criteria.Expression<M> get(MapAttribute<? super X, K, V> map) {
        return new ExpressionImpl<Class>(this.metamodel, Class.class, this.currentNode.anyOf(map.getName()));
    }

    @Override
    public jakarta.persistence.criteria.Expression<Class<? extends X>> type() {
        return new ExpressionImpl<Class<? extends X>>(this.metamodel, ClassConstants.CLASS, this.currentNode.type());
    }

    @Override
    public <Y> Path<Y> get(String attName) {
        JoinImpl join;
        Attribute attribute = this.managedType.getAttribute(attName);
        if (attribute.isCollection()) {
            join = !((PluralAttribute)attribute).getElementType().getPersistenceType().equals((Object)Type.PersistenceType.BASIC) ? (((PluralAttribute)attribute).getCollectionType().equals((Object)PluralAttribute.CollectionType.COLLECTION) ? new CollectionJoinImpl(this, this.metamodel.managedType(((PluralAttribute)attribute).getBindableJavaType()), this.metamodel, ((PluralAttribute)attribute).getBindableJavaType(), this.currentNode.anyOf(attribute.getName()), (Bindable)attribute) : (((PluralAttribute)attribute).getCollectionType().equals((Object)PluralAttribute.CollectionType.LIST) ? new ListJoinImpl(this, this.metamodel.managedType(((PluralAttribute)attribute).getBindableJavaType()), this.metamodel, ((PluralAttribute)attribute).getBindableJavaType(), this.currentNode.anyOf(attribute.getName()), (Bindable)attribute) : (((PluralAttribute)attribute).getCollectionType().equals((Object)PluralAttribute.CollectionType.SET) ? new SetJoinImpl(this, this.metamodel.managedType(((PluralAttribute)attribute).getBindableJavaType()), this.metamodel, ((PluralAttribute)attribute).getBindableJavaType(), this.currentNode.anyOf(attribute.getName()), (Bindable)attribute) : new MapJoinImpl(this, this.metamodel.managedType(((PluralAttribute)attribute).getBindableJavaType()), this.metamodel, ((PluralAttribute)attribute).getBindableJavaType(), this.currentNode.anyOf(attribute.getName()), (Bindable)attribute)))) : (((PluralAttribute)attribute).getCollectionType().equals((Object)PluralAttribute.CollectionType.COLLECTION) ? new BasicCollectionJoinImpl(this, this.metamodel, ((PluralAttribute)attribute).getBindableJavaType(), this.currentNode.anyOf(attribute.getName()), (Bindable)attribute) : (((PluralAttribute)attribute).getCollectionType().equals((Object)PluralAttribute.CollectionType.LIST) ? new BasicListJoinImpl(this, this.metamodel, ((PluralAttribute)attribute).getBindableJavaType(), this.currentNode.anyOf(attribute.getName()), (Bindable)attribute) : (((PluralAttribute)attribute).getCollectionType().equals((Object)PluralAttribute.CollectionType.SET) ? new BasicSetJoinImpl(this, this.metamodel, ((PluralAttribute)attribute).getBindableJavaType(), this.currentNode.anyOf(attribute.getName()), (Bindable)attribute) : new BasicMapJoinImpl(this, this.metamodel, ((PluralAttribute)attribute).getBindableJavaType(), this.currentNode.anyOf(attribute.getName()), (Bindable)attribute))));
        } else {
            Class clazz = ((SingularAttribute)attribute).getBindableJavaType();
            if (((SingularAttribute)attribute).getType().getPersistenceType().equals((Object)Type.PersistenceType.BASIC)) {
                return new PathImpl(this, this.metamodel, clazz, this.currentNode.get(attribute.getName()), (Bindable)attribute);
            }
            join = new JoinImpl(this, this.metamodel.managedType(clazz), this.metamodel, clazz, this.currentNode.get(attribute.getName()), (Bindable)attribute);
        }
        this.joins.add(join);
        return join;
    }

    public <Y> Join<X, Y> join(SingularAttribute<? super X, Y> attribute) {
        return this.join(attribute, JoinType.INNER);
    }

    public <Y> Join<X, Y> join(SingularAttribute<? super X, Y> attribute, JoinType jt) {
        if (attribute.getType().getPersistenceType().equals((Object)Type.PersistenceType.BASIC)) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage("CAN_NOT_JOIN_TO_BASIC"));
        }
        Class clazz = attribute.getBindableJavaType();
        JoinImpl join = null;
        QueryKeyExpression exp = ((ObjectExpression)this.currentNode).newDerivedExpressionNamed(attribute.getName());
        if (jt.equals((Object)JoinType.LEFT)) {
            exp.doUseOuterJoin();
        } else {
            if (jt.equals((Object)JoinType.RIGHT)) {
                throw new UnsupportedOperationException(ExceptionLocalization.buildMessage("RIGHT_JOIN_NOT_SUPPORTED"));
            }
            exp.doNotUseOuterJoin();
        }
        join = new JoinImpl(this, this.metamodel.managedType(clazz), this.metamodel, clazz, (Expression)exp, attribute, jt);
        this.joins.add(join);
        ((FromImpl)join).isJoin = true;
        return join;
    }

    public <Y> CollectionJoin<X, Y> join(CollectionAttribute<? super X, Y> collection) {
        return this.join(collection, JoinType.INNER);
    }

    public <Y> SetJoin<X, Y> join(SetAttribute<? super X, Y> set) {
        return this.join(set, JoinType.INNER);
    }

    public <Y> ListJoin<X, Y> join(ListAttribute<? super X, Y> list) {
        return this.join(list, JoinType.INNER);
    }

    public <K, V> MapJoin<X, K, V> join(MapAttribute<? super X, K, V> map) {
        return this.join(map, JoinType.INNER);
    }

    public <Y> CollectionJoin<X, Y> join(CollectionAttribute<? super X, Y> collection, JoinType jt) {
        Expression node;
        Class clazz = collection.getBindableJavaType();
        CollectionJoinImpl join = null;
        if (jt.equals((Object)JoinType.INNER)) {
            node = this.currentNode.anyOf(collection.getName());
        } else {
            if (jt.equals((Object)JoinType.RIGHT)) {
                throw new UnsupportedOperationException(ExceptionLocalization.buildMessage("RIGHT_JOIN_NOT_SUPPORTED"));
            }
            node = this.currentNode.anyOfAllowingNone(collection.getName());
        }
        join = collection.getElementType().getPersistenceType().equals((Object)Type.PersistenceType.BASIC) ? new BasicCollectionJoinImpl(this, this.metamodel, clazz, node, collection, jt) : new CollectionJoinImpl(this, this.metamodel.managedType(clazz), this.metamodel, clazz, node, collection, jt);
        this.joins.add(join);
        ((FromImpl)join).isJoin = true;
        return join;
    }

    public <Y> SetJoin<X, Y> join(SetAttribute<? super X, Y> set, JoinType jt) {
        Expression node;
        Class clazz = set.getBindableJavaType();
        SetJoinImpl join = null;
        if (jt.equals((Object)JoinType.INNER)) {
            node = this.currentNode.anyOf(set.getName());
        } else {
            if (jt.equals((Object)JoinType.RIGHT)) {
                throw new UnsupportedOperationException(ExceptionLocalization.buildMessage("RIGHT_JOIN_NOT_SUPPORTED"));
            }
            node = this.currentNode.anyOfAllowingNone(set.getName());
        }
        join = set.getElementType().getPersistenceType().equals((Object)Type.PersistenceType.BASIC) ? new BasicSetJoinImpl(this, this.metamodel, clazz, node, set, jt) : new SetJoinImpl(this, this.metamodel.managedType(clazz), this.metamodel, clazz, node, set, jt);
        this.joins.add(join);
        ((FromImpl)join).isJoin = true;
        return join;
    }

    public <Y> ListJoin<X, Y> join(ListAttribute<? super X, Y> list, JoinType jt) {
        Expression node;
        Class clazz = list.getBindableJavaType();
        ListJoinImpl join = null;
        if (jt.equals((Object)JoinType.INNER)) {
            node = this.currentNode.anyOf(list.getName());
        } else {
            if (jt.equals((Object)JoinType.RIGHT)) {
                throw new UnsupportedOperationException(ExceptionLocalization.buildMessage("RIGHT_JOIN_NOT_SUPPORTED"));
            }
            node = this.currentNode.anyOfAllowingNone(list.getName());
        }
        join = list.getElementType().getPersistenceType().equals((Object)Type.PersistenceType.BASIC) ? new BasicListJoinImpl(this, this.metamodel, clazz, node, list, jt) : new ListJoinImpl(this, this.metamodel.managedType(clazz), this.metamodel, clazz, node, list, jt);
        this.joins.add(join);
        ((FromImpl)join).isJoin = true;
        return join;
    }

    public <K, V> MapJoin<X, K, V> join(MapAttribute<? super X, K, V> map, JoinType jt) {
        Expression node;
        Class clazz = map.getBindableJavaType();
        MapJoinImpl join = null;
        if (jt.equals((Object)JoinType.INNER)) {
            node = this.currentNode.anyOf(map.getName());
        } else {
            if (jt.equals((Object)JoinType.RIGHT)) {
                throw new UnsupportedOperationException(ExceptionLocalization.buildMessage("RIGHT_JOIN_NOT_SUPPORTED"));
            }
            node = this.currentNode.anyOfAllowingNone(map.getName());
        }
        join = map.getElementType().getPersistenceType().equals((Object)Type.PersistenceType.BASIC) ? new BasicMapJoinImpl(this, this.metamodel, clazz, node, map, jt) : new MapJoinImpl(this, this.metamodel.managedType(clazz), this.metamodel, clazz, node, map, jt);
        this.joins.add(join);
        ((FromImpl)join).isJoin = true;
        return join;
    }

    public <T, Y> Join<T, Y> join(String attributeName) {
        return this.join(attributeName, JoinType.INNER);
    }

    public <T, Y> Join<T, Y> join(String attributeName, JoinType jt) {
        Attribute attribute = this.managedType.getAttribute(attributeName);
        if (attribute.isCollection()) {
            Expression node;
            if (jt.equals((Object)JoinType.INNER)) {
                node = this.currentNode.anyOf(attribute.getName());
            } else {
                if (jt.equals((Object)JoinType.RIGHT)) {
                    throw new UnsupportedOperationException(ExceptionLocalization.buildMessage("RIGHT_JOIN_NOT_SUPPORTED"));
                }
                node = this.currentNode.anyOfAllowingNone(attribute.getName());
            }
            JoinImpl join = ((PluralAttribute)attribute).getElementType().getPersistenceType().equals((Object)Type.PersistenceType.BASIC) ? (((PluralAttribute)attribute).getCollectionType().equals((Object)PluralAttribute.CollectionType.COLLECTION) ? new BasicCollectionJoinImpl(this, this.metamodel, ((PluralAttribute)attribute).getBindableJavaType(), node, (Bindable)attribute, jt) : (((PluralAttribute)attribute).getCollectionType().equals((Object)PluralAttribute.CollectionType.LIST) ? new BasicListJoinImpl(this, this.metamodel, ((PluralAttribute)attribute).getBindableJavaType(), node, (Bindable)attribute, jt) : (((PluralAttribute)attribute).getCollectionType().equals((Object)PluralAttribute.CollectionType.SET) ? new BasicSetJoinImpl(this, this.metamodel, ((PluralAttribute)attribute).getBindableJavaType(), node, (Bindable)attribute, jt) : new BasicMapJoinImpl(this, this.metamodel, ((PluralAttribute)attribute).getBindableJavaType(), node, (Bindable)attribute, jt)))) : (((PluralAttribute)attribute).getCollectionType().equals((Object)PluralAttribute.CollectionType.COLLECTION) ? new CollectionJoinImpl(this, this.metamodel.managedType(((PluralAttribute)attribute).getBindableJavaType()), this.metamodel, ((PluralAttribute)attribute).getBindableJavaType(), node, (Bindable)attribute, jt) : (((PluralAttribute)attribute).getCollectionType().equals((Object)PluralAttribute.CollectionType.LIST) ? new ListJoinImpl(this, this.metamodel.managedType(((PluralAttribute)attribute).getBindableJavaType()), this.metamodel, ((PluralAttribute)attribute).getBindableJavaType(), node, (Bindable)attribute, jt) : (((PluralAttribute)attribute).getCollectionType().equals((Object)PluralAttribute.CollectionType.SET) ? new SetJoinImpl(this, this.metamodel.managedType(((PluralAttribute)attribute).getBindableJavaType()), this.metamodel, ((PluralAttribute)attribute).getBindableJavaType(), node, (Bindable)attribute, jt) : new MapJoinImpl(this, this.metamodel.managedType(((PluralAttribute)attribute).getBindableJavaType()), this.metamodel, ((PluralAttribute)attribute).getBindableJavaType(), node, (Bindable)attribute, jt))));
            this.joins.add(join);
            ((FromImpl)join).isJoin = true;
            return join;
        }
        return this.join((SingularAttribute)attribute, jt);
    }

    public <Y> Join<X, Y> join(Class<Y> entityClass) {
        return this.join(entityClass, JoinType.INNER);
    }

    public <Y> Join<X, Y> join(Class<Y> entityClass, JoinType joinType) {
        JoinImpl join = null;
        for (Attribute attribute : this.managedType.getAttributes()) {
            if (!(attribute instanceof SingularAttribute) || !((SingularAttribute)attribute).getBindableJavaType().isAssignableFrom(entityClass)) continue;
            SingularAttribute singularAttribute = (SingularAttribute)attribute;
            if (join != null) continue;
            QueryKeyExpression exp = ((ObjectExpression)this.currentNode).newDerivedExpressionNamed(singularAttribute.getName());
            switch (joinType) {
                case LEFT: {
                    exp.doUseOuterJoin();
                    break;
                }
                case RIGHT: {
                    throw new UnsupportedOperationException(ExceptionLocalization.buildMessage("RIGHT_JOIN_NOT_SUPPORTED"));
                }
                case INNER: {
                    exp.doNotUseOuterJoin();
                }
            }
            join = new JoinImpl(this, this.managedType, this.metamodel, entityClass, (Expression)exp, singularAttribute, joinType);
            this.joins.add(join);
            join.isJoin = true;
        }
        if (join == null) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage("no_key_in_entity", new String[]{entityClass.getName(), this.managedType.getJavaType().getName()}));
        }
        return join;
    }

    public <Y> Join<X, Y> join(EntityType<Y> entity) {
        return this.join(entity, JoinType.INNER);
    }

    public <Y> Join<X, Y> join(EntityType<Y> entity, JoinType joinType) {
        return this.join(entity.getJavaType(), joinType);
    }

    public <T, Y> CollectionJoin<T, Y> joinCollection(String attributeName) {
        return this.joinCollection(attributeName, JoinType.INNER);
    }

    public <T, Y> CollectionJoin<T, Y> joinCollection(String attributeName, JoinType jt) {
        try {
            return (CollectionJoin)this.join(attributeName, jt);
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_attribute_not_collection", new Object[]{attributeName, this.managedType.getJavaType().getName()}), ex);
        }
    }

    public <T, Y> ListJoin<T, Y> joinList(String attributeName) {
        return this.joinList(attributeName, JoinType.INNER);
    }

    public <T, Y> ListJoin<T, Y> joinList(String attributeName, JoinType jt) {
        try {
            return (ListJoin)this.join(attributeName, jt);
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_attribute_not_list", new Object[]{attributeName, this.managedType.getJavaType().getName()}), ex);
        }
    }

    public <T, K, Y> MapJoin<T, K, Y> joinMap(String attributeName) {
        return this.joinMap(attributeName, JoinType.INNER);
    }

    public <T, K, Y> MapJoin<T, K, Y> joinMap(String attributeName, JoinType jt) {
        try {
            return (MapJoin)this.join(attributeName, jt);
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_attribute_not_map", new Object[]{attributeName, this.managedType.getJavaType().getName()}), ex);
        }
    }

    public <T, Y> SetJoin<T, Y> joinSet(String attributeName) {
        return this.joinSet(attributeName, JoinType.INNER);
    }

    public <T, Y> SetJoin<T, Y> joinSet(String attributeName, JoinType jt) {
        try {
            return (SetJoin)this.join(attributeName, jt);
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_attribute_not_set", new Object[]{attributeName, this.managedType.getJavaType().getName()}), ex);
        }
    }

    public void findJoins(AbstractQueryImpl query) {
        Stack<FromImpl<Object, Object>> stack = new Stack<FromImpl<Object, Object>>();
        stack.push(this);
        while (!stack.isEmpty()) {
            FromImpl currentJoin = (FromImpl)stack.pop();
            stack.addAll(currentJoin.getJoins());
            if (!currentJoin.isJoin) continue;
            query.addJoin(currentJoin);
        }
    }

    public List<Expression> findJoinFetches() {
        ArrayList<Expression> fetches = new ArrayList<Expression>();
        Stack<FromImpl<Object, Object>> stack = new Stack<FromImpl<Object, Object>>();
        stack.push(this);
        while (!stack.isEmpty()) {
            FromImpl currentFetch = (FromImpl)stack.pop();
            stack.addAll(currentFetch.getFetches());
            if (!currentFetch.isFetch) continue;
            fetches.add(currentFetch.getCurrentNode());
        }
        return fetches;
    }

    @Override
    public boolean isFrom() {
        return true;
    }
}

