/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.security;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.localization.LoggingLocalization;
import org.eclipse.persistence.internal.security.JCEEncryptor;

public final class JCEEncryptorCmd {
    private JCEEncryptor jceEncryptor = new JCEEncryptor();
    private static final String DES_ECB = "DES/ECB/PKCS5Padding";
    private final Cipher decryptCipherDES_ECB = Cipher.getInstance("DES/ECB/PKCS5Padding");
    private static final String AES_ECB = "AES/ECB/PKCS5Padding";
    private final Cipher decryptCipherAES_ECB;
    private static final String AES_CBC = "AES/CBC/PKCS5Padding";
    private final Cipher decryptCipherAES_CBC;

    public JCEEncryptorCmd() throws Exception {
        this.decryptCipherDES_ECB.init(2, Synergizer.getDESMultitasker());
        this.decryptCipherAES_ECB = Cipher.getInstance(AES_ECB);
        this.decryptCipherAES_ECB.init(2, Synergizer.getAESMultitasker());
        SecretKey sk = Synergizer.getAESCBCMultitasker();
        IvParameterSpec iv = Synergizer.getIvSpec();
        this.decryptCipherAES_CBC = Cipher.getInstance(AES_CBC);
        this.decryptCipherAES_CBC.init(2, (Key)sk, iv);
    }

    public static void main(String[] args) throws Exception {
        JCEEncryptorCmd encryptorCmd = new JCEEncryptorCmd();
        encryptorCmd.start(args);
    }

    private void start(String[] args) throws Exception {
        if (args.length < 2 || !args[0].equals("-ip")) {
            System.out.println(LoggingLocalization.buildMessage("encryptor_script_usage", null) + "\n" + LoggingLocalization.buildMessage("encryptor_script_description", null));
        } else {
            System.out.println(LoggingLocalization.buildMessage("encryptor_script_output", new Object[]{this.jceEncryptor.encryptPassword(this.decryptPassword(args[1]))}));
        }
    }

    public String decryptPassword(String encryptedPwd) throws Exception {
        String password;
        block20: {
            password = null;
            byte[] bytePassword = null;
            try {
                password = this.jceEncryptor.decryptPassword(encryptedPwd);
            }
            catch (Exception u) {
                try {
                    bytePassword = Helper.buildBytesFromHexString(encryptedPwd);
                    password = new String(this.decryptCipherAES_CBC.doFinal(bytePassword), StandardCharsets.UTF_8);
                }
                catch (Exception w) {
                    try (ObjectInputStream oisAes = new ObjectInputStream(new CipherInputStream(new ByteArrayInputStream(bytePassword), this.decryptCipherAES_ECB));){
                        password = (String)oisAes.readObject();
                    }
                    catch (Exception x) {
                        try (ObjectInputStream oisDes = new ObjectInputStream(new CipherInputStream(new ByteArrayInputStream(bytePassword), this.decryptCipherDES_ECB));){
                            password = (String)oisDes.readObject();
                        }
                        catch (ArrayIndexOutOfBoundsException y) {
                            password = encryptedPwd;
                        }
                        catch (Exception z) {
                            if (z.getCause() instanceof IllegalBlockSizeException) {
                                password = encryptedPwd;
                                break block20;
                            }
                            throw ValidationException.errorDecryptingPassword(z);
                        }
                    }
                }
            }
        }
        return password;
    }

    private static class Synergizer {
        private Synergizer() {
        }

        private static SecretKey getDESMultitasker() throws Exception {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("DES");
            return factory.generateSecret(new DESKeySpec(Helper.buildBytesFromHexString("E60B80C7AEC78038")));
        }

        private static SecretKey getAESMultitasker() throws Exception {
            return new SecretKeySpec(Helper.buildBytesFromHexString("3E7CFEF156E712906E1F603B59463C67"), "AES");
        }

        private static SecretKey getAESCBCMultitasker() throws Exception {
            return new SecretKeySpec(Helper.buildBytesFromHexString("2DB7354A48F1CA7B48ACA247540FC923"), "AES");
        }

        private static IvParameterSpec getIvSpec() {
            byte[] b = new byte[]{-26, 124, -99, 32, -37, -58, -93, 100, 126, -55, -21, 48, -86, 97, 12, 113};
            return new IvParameterSpec(b);
        }
    }
}

