/*
 * Copyright (c) 2011, 2024 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */

// Contributors:
//     03/24/2011-2.3 Guy Pelletier
//       - 337323: Multi-tenant with shared schema support (part 1)
//     08/18/2011-2.3.1 Guy Pelletier
//       - 355093: Add new 'includeCriteria' flag to Multitenant metadata
package org.eclipse.persistence.annotations;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * Multitenant specifies that a given entity is shared amongst multiple tenants
 * of a given application. The multitenant type specifies how the data for these
 * entities are to be stored on the database for each tenant.
 * <p>
 * Multitenant can be specified at the Entity or MappedSuperclass level.
 *
 * @see MultitenantType
 * @see TenantDiscriminatorColumn
 * @see TenantDiscriminatorColumns
 *
 * @author Guy Pelletier
 * @since EclipseLink 2.3
 */
@Target({TYPE})
@Retention(RUNTIME)
public @interface Multitenant {
    /**
     * Specify the multi-tenant strategy to use.
     */
    MultitenantType value() default MultitenantType.SINGLE_TABLE;

    /**
     * Indicate if the database requires the tenant criteria to be added
     * to the SELECT, UPDATE, and DELETE queries. By default, this is
     * done but when set to false the queries will not be modified, and it will
     * be up to the application or database to ensure that the correct criteria
     * is applied to all queries.
     */
    boolean includeCriteria() default true;
}
