/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Map;
import org.eclipse.persistence.descriptors.InstantLockingPolicy;
import org.eclipse.persistence.descriptors.LocalDateTimeLockingPolicy;
import org.eclipse.persistence.descriptors.TimestampLockingPolicy;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.ModifyQuery;

public abstract class AbstractTsLockingPolicy<T>
extends VersionLockingPolicy {
    public static final int SERVER_TIME = 1;
    public static final int LOCAL_TIME = 2;
    private static final Map<String, LockingPolicySupplier> FACTORY = Map.of(Timestamp.class.getName(), AbstractTsLockingPolicy::createTimestampLockingPolicy, LocalDateTime.class.getName(), AbstractTsLockingPolicy::createLocalDateTimeLockingPolicy, Instant.class.getName(), AbstractTsLockingPolicy::createInstantLockingPolicy);
    private int retrieveTimeFrom;

    public static AbstractTsLockingPolicy<?> create(String typeName, DatabaseField field) {
        LockingPolicySupplier factory = FACTORY.get(typeName);
        if (factory == null) {
            throw new UnsupportedOperationException(String.format("Cannot create AbstractTsLockingPolicy for %s", typeName));
        }
        return factory.create(field);
    }

    public AbstractTsLockingPolicy() {
        this.useServerTime();
    }

    public AbstractTsLockingPolicy(String fieldName) {
        super(fieldName);
        this.useServerTime();
    }

    public AbstractTsLockingPolicy(DatabaseField field) {
        super(field);
        this.useServerTime();
    }

    abstract int compareTsLockValues(T var1, T var2);

    @Override
    public int compareWriteLockValues(Object value1, Object value2) {
        return this.compareTsLockValues(value1, value2);
    }

    abstract Class<T> getDefaultTsLockFieldType();

    protected <C> Class<C> getDefaultLockingFieldType() {
        return this.getDefaultTsLockFieldType();
    }

    abstract T getBaseTsValue();

    public <C> C getBaseValue() {
        return (C)this.getBaseTsValue();
    }

    abstract T getInitialTsWriteValue(AbstractSession var1);

    protected <C> C getInitialWriteValue(AbstractSession session) {
        return (C)this.getInitialTsWriteValue(session);
    }

    abstract T getNewTsLockValue(ModifyQuery var1);

    public <C> C getNewLockValue(ModifyQuery query) {
        return (C)this.getNewTsLockValue(query);
    }

    abstract T getTsValueToPutInCache(AbstractRecord var1, AbstractSession var2);

    public <C> C getValueToPutInCache(AbstractRecord row, AbstractSession session) {
        return (C)this.getTsValueToPutInCache(row, session);
    }

    abstract T getWriteTsLockValue(Object var1, Object var2, AbstractSession var3);

    public <C> C getWriteLockValue(Object domainObject, Object primaryKey, AbstractSession session) {
        return (C)this.getWriteTsLockValue(domainObject, primaryKey, session);
    }

    abstract boolean isNewerTsVersion(T var1, Object var2, Object var3, AbstractSession var4);

    @Override
    public boolean isNewerVersion(Object current, Object domainObject, Object primaryKey, AbstractSession session) {
        return this.isNewerTsVersion(current, domainObject, primaryKey, session);
    }

    abstract boolean isNewerTsVersion(AbstractRecord var1, Object var2, Object var3, AbstractSession var4);

    @Override
    public boolean isNewerVersion(AbstractRecord row, Object domainObject, Object primaryKey, AbstractSession session) {
        return this.isNewerTsVersion(row, domainObject, primaryKey, session);
    }

    abstract boolean isNewerTsVersion(T var1, T var2);

    @Override
    public boolean isNewerVersion(Object first, Object second) {
        return this.isNewerTsVersion(first, second);
    }

    @Override
    public Expression getWriteLockUpdateExpression(ExpressionBuilder builder, AbstractSession session) {
        return builder.currentTimeStamp();
    }

    @Override
    protected Number incrementWriteLockValue(Number value) {
        return null;
    }

    public void setUsesServerTime(boolean useServer) {
        if (useServer) {
            this.useServerTime();
        } else {
            this.useLocalTime();
        }
    }

    public void useLocalTime() {
        this.retrieveTimeFrom = 2;
    }

    public void useServerTime() {
        this.retrieveTimeFrom = 1;
    }

    public boolean usesLocalTime() {
        return this.retrieveTimeFrom == 2;
    }

    public boolean usesServerTime() {
        return this.retrieveTimeFrom == 1;
    }

    private static TimestampLockingPolicy createTimestampLockingPolicy(DatabaseField field) {
        return new TimestampLockingPolicy(field);
    }

    private static LocalDateTimeLockingPolicy createLocalDateTimeLockingPolicy(DatabaseField field) {
        return new LocalDateTimeLockingPolicy(field);
    }

    private static InstantLockingPolicy createInstantLockingPolicy(DatabaseField field) {
        return new InstantLockingPolicy(field);
    }

    @FunctionalInterface
    private static interface LockingPolicySupplier {
        public AbstractTsLockingPolicy<?> create(DatabaseField var1);
    }
}

