/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import org.eclipse.persistence.jpa.jpql.parser.AbstractExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AbstractPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSchemaName;
import org.eclipse.persistence.jpa.jpql.parser.AbstractTraverseChildrenVisitor;
import org.eclipse.persistence.jpa.jpql.parser.CollectionMemberDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.DeleteClause;
import org.eclipse.persistence.jpa.jpql.parser.DeleteStatement;
import org.eclipse.persistence.jpa.jpql.parser.EntryExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.Join;
import org.eclipse.persistence.jpa.jpql.parser.KeyExpression;
import org.eclipse.persistence.jpa.jpql.parser.RangeVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.UpdateClause;
import org.eclipse.persistence.jpa.jpql.parser.UpdateStatement;
import org.eclipse.persistence.jpa.jpql.parser.ValueExpression;

public final class FullyQualifyPathExpressionVisitor
extends AbstractTraverseChildrenVisitor {
    private String variableName;
    private GeneralIdentificationVariableVisitor visitor;

    private GeneralIdentificationVariableVisitor generalIdentificationVariableVisitor() {
        if (this.visitor == null) {
            this.visitor = new GeneralIdentificationVariableVisitor();
        }
        return this.visitor;
    }

    @Override
    public void visit(AbstractSchemaName expression) {
        this.variableName = "this";
    }

    @Override
    public void visit(CollectionMemberDeclaration expression) {
    }

    @Override
    public void visit(CollectionValuedPathExpression expression) {
        this.visitAbstractPathExpression(expression);
        this.variableName = "this";
    }

    @Override
    public void visit(DeleteClause expression) {
        expression.getRangeVariableDeclaration().accept(this);
    }

    @Override
    public void visit(DeleteStatement expression) {
        expression.getDeleteClause().accept(this);
        if (this.variableName != null && expression.hasWhereClause()) {
            expression.getWhereClause().accept(this);
        }
    }

    @Override
    public void visit(IdentificationVariable expression) {
        expression.setVirtualIdentificationVariable(this.variableName);
    }

    @Override
    public void visit(Join expression) {
    }

    @Override
    public void visit(RangeVariableDeclaration expression) {
        if (!expression.hasIdentificationVariable()) {
            expression.getRootObject().accept(this);
            expression.setVirtualIdentificationVariable(this.variableName);
        }
    }

    @Override
    public void visit(SelectStatement expression) {
    }

    @Override
    public void visit(SimpleSelectStatement expression) {
    }

    @Override
    public void visit(StateFieldPathExpression expression) {
        this.visitAbstractPathExpression(expression);
    }

    @Override
    public void visit(UpdateClause expression) {
        expression.getRangeVariableDeclaration().accept(this);
        if (this.variableName != null && expression.hasUpdateItems()) {
            expression.getUpdateItems().accept(this);
        }
    }

    @Override
    public void visit(UpdateStatement expression) {
        expression.getUpdateClause().accept(this);
        if (this.variableName != null && expression.hasWhereClause()) {
            expression.getWhereClause().accept(this);
        }
    }

    private void visitAbstractPathExpression(AbstractPathExpression expression) {
        if (!expression.startsWithDot()) {
            GeneralIdentificationVariableVisitor visitor = this.generalIdentificationVariableVisitor();
            expression.getIdentificationVariable().accept(visitor);
            if (visitor.expression == null) {
                expression.setVirtualIdentificationVariable(this.variableName);
            }
        }
    }

    private static final class GeneralIdentificationVariableVisitor
    extends AbstractExpressionVisitor {
        private Expression expression;

        private GeneralIdentificationVariableVisitor() {
        }

        @Override
        public void visit(EntryExpression expression) {
            this.expression = expression;
        }

        @Override
        public void visit(KeyExpression expression) {
            this.expression = expression;
        }

        @Override
        public void visit(ValueExpression expression) {
            this.expression = expression;
        }
    }
}

