/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.file;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.logging.AbstractSessionLog;

public final class FileUtil {
    private FileUtil() {
    }

    public static void copy(String inputPath, String outputPath, String[] filteredExtensions) throws IOException {
        File inputPathFile = new File(inputPath);
        if (!inputPathFile.exists()) {
            return;
        }
        File outputPathFile = new File(outputPath);
        if (!outputPathFile.exists()) {
            if (outputPathFile.isDirectory()) {
                if (!outputPathFile.mkdirs()) {
                    AbstractSessionLog.getLog().log(3, "misc", "Cannot create directory '{0}'", new Object[]{outputPathFile}, false);
                }
            } else if (!outputPathFile.getParentFile().mkdirs()) {
                AbstractSessionLog.getLog().log(3, "misc", "Cannot create directory '{0}'", new Object[]{outputPathFile}, false);
            }
        }
        List<File> files = FileUtil.findFiles(inputPath, filteredExtensions);
        for (int i = 0; i < files.size(); ++i) {
            File in = files.get(i);
            Object outFilePath = in.getAbsolutePath().substring(inputPath.length());
            File out = new File((String)(outFilePath = outputPath + File.separator + (String)outFilePath));
            File parent = new File(out.getParent());
            if (!parent.exists() && !parent.mkdirs()) {
                AbstractSessionLog.getLog().log(3, "misc", "Cannot create directory '{0}'", new Object[]{outputPathFile}, false);
            }
            FileUtil.copy(new FileInputStream(in), new FileOutputStream(out));
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        try (InputStream i = in;
             OutputStream o = out;){
            int bytesRead;
            byte[] buffer = new byte[512];
            while ((bytesRead = i.read(buffer)) != -1) {
                o.write(buffer, 0, bytesRead);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createJarFromDirectory(String jarFileName, String jarDirectory, String[] filtertedExtensions) throws IOException {
        File directory = new File(jarDirectory);
        if (!directory.exists()) {
            return;
        }
        File jar = new File(jarFileName);
        if (!jar.exists() && !jar.getParentFile().mkdirs()) {
            AbstractSessionLog.getLog().log(3, "misc", "Cannot create directory '{0}'", new Object[]{jar.getParentFile()}, false);
        }
        JarOutputStream jarOut = null;
        try {
            jarOut = new JarOutputStream((OutputStream)new FileOutputStream(jar), new Manifest());
            List<File> files = FileUtil.findFiles(jarDirectory, filtertedExtensions);
            for (int i = 0; i < files.size(); ++i) {
                File file = files.get(i);
                String relativePathToDirectory = file.getAbsolutePath().substring(directory.getAbsolutePath().length() + 1);
                String entryName = relativePathToDirectory.replace('\\', '/');
                FileInputStream inStream = null;
                ByteArrayOutputStream byteStream = null;
                try {
                    inStream = new FileInputStream(file);
                    byteStream = new ByteArrayOutputStream();
                    int length = 0;
                    byte[] buffer = new byte[1024];
                    while ((length = inStream.read(buffer)) > 0) {
                        byteStream.write(buffer, 0, length);
                    }
                    byte[] arr = byteStream.toByteArray();
                    JarEntry meta = new JarEntry(entryName);
                    jarOut.putNextEntry(meta);
                    meta.setSize(arr.length);
                    meta.setCompressedSize(arr.length);
                    CRC32 crc = new CRC32();
                    crc.update(arr);
                    meta.setCrc(crc.getValue());
                    meta.setMethod(0);
                    jarOut.write(arr, 0, arr.length);
                    jarOut.closeEntry();
                }
                catch (Throwable throwable) {
                    Helper.close(byteStream);
                    Helper.close(inStream);
                    throw throwable;
                }
                Helper.close(byteStream);
                Helper.close(inStream);
            }
        }
        catch (Throwable throwable) {
            Helper.close(jarOut);
            throw throwable;
        }
        Helper.close(jarOut);
    }

    public static List<File> findFiles(String path, String[] filteredExtensions) {
        ArrayList<File> files = new ArrayList<File>();
        FileUtil.findFilesHelper(new File(path), filteredExtensions, files);
        return files;
    }

    private static void findFilesHelper(File file, String[] filteredExtensions, List<File> result) {
        block5: {
            block4: {
                if (!file.exists()) {
                    return;
                }
                if (!file.isDirectory()) break block4;
                String[] entries = file.list();
                if (entries == null) break block5;
                for (int i = 0; i < entries.length; ++i) {
                    FileUtil.findFilesHelper(new File(file, entries[i]), filteredExtensions, result);
                }
                break block5;
            }
            if (filteredExtensions == null || filteredExtensions.length == 0) {
                result.add(file);
                return;
            }
            for (int i = 0; i < filteredExtensions.length; ++i) {
                if (!file.getName().endsWith(filteredExtensions[i])) continue;
                result.add(file);
                return;
            }
        }
    }

    public static void delete(File file) {
        Objects.requireNonNull(file);
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            String[] entries = file.list();
            if (entries == null || entries.length == 0) {
                if (!file.delete()) {
                    AbstractSessionLog.getLog().log(3, "misc", "Cannot delete file '{0}'.", new Object[]{file}, false);
                }
            } else {
                for (int i = 0; i < entries.length; ++i) {
                    FileUtil.delete(new File(file, entries[i]));
                }
                String[] content = file.list();
                if (!(content != null && content.length != 0 || file.delete())) {
                    AbstractSessionLog.getLog().log(3, "misc", "Cannot delete file '{0}'.", new Object[]{file}, false);
                }
            }
        } else if (!file.delete()) {
            AbstractSessionLog.getLog().log(3, "misc", "Cannot delete file '{0}'.", new Object[]{file}, false);
        }
    }
}

