/*
 * Copyright (c) 1998, 2023 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */

// Contributors:
//     Oracle - initial API and implementation from Oracle TopLink
package org.eclipse.persistence.internal.oxm;

import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.XMLDescriptor;

import java.lang.reflect.Method;

/**
 * <p><b>Purpose:</b>An extnesion of XMLDescriptor that's used for sequened
 * objects.
 * <p><b>Responsibilities:</b>
 */
public class XMLSequencedDescriptor extends XMLDescriptor {
    private String getSettingsMethodName;
    private Method getSettingsMethod;

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        if(shouldPreserveDocument()) {
            this.objectBuilder = new XMLSequencedObjectBuilder(this);
        }
        if(getGetSettingsMethodName() != null) {
            try {
                this.getSettingsMethod = PrivilegedAccessHelper.getDeclaredMethod(this.getJavaClass(), this.getGetSettingsMethodName(), new Class<?>[0]);
            } catch(Exception ex) {

            }
        }
    }
    /**
     * INTERNAL:
     * Get the method that will be used to obtain an ordered list of TopLinkSetting objects
     * at runtime. Only used with Sequenced objects
     * @return The name of the method to be invoked.
     */
    public String getGetSettingsMethodName() {
        return this.getSettingsMethodName;
    }

    /**
     * INTERNAL:
     * Set the name of the method to be invoked to obtain an ordered list of TopLinkSetting
     * objects at runtime. Only used with Sequenced objects.
     * @param methodName The name of the method.
     */
    public void setGetSettingsMethodName(String methodName) {
        this.getSettingsMethodName = methodName;
    }

    /**
     * INTERNAL:
     * Return the actual method to be invoked to obtain an ordered list of TopLinkSetting objects
     * Only used with Sequenced Objects. Is set during initialize.
     * @return The method to be invoked.
     */
    public Method getGetSettingsMethod() {
        return this.getSettingsMethod;
    }

}
