/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.persistence.internal.jpa.jpql.JPQLFunctionsAbstractBuilder;
import org.eclipse.persistence.internal.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.jpql.LiteralType;
import org.eclipse.persistence.jpa.jpql.parser.AbsExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSelectClause;
import org.eclipse.persistence.jpa.jpql.parser.AdditionExpression;
import org.eclipse.persistence.jpa.jpql.parser.ArithmeticFactor;
import org.eclipse.persistence.jpa.jpql.parser.AvgFunction;
import org.eclipse.persistence.jpa.jpql.parser.CaseExpression;
import org.eclipse.persistence.jpa.jpql.parser.CastExpression;
import org.eclipse.persistence.jpa.jpql.parser.CoalesceExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConcatExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConcatPipesExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConstructorExpression;
import org.eclipse.persistence.jpa.jpql.parser.CountFunction;
import org.eclipse.persistence.jpa.jpql.parser.DateTime;
import org.eclipse.persistence.jpa.jpql.parser.DivisionExpression;
import org.eclipse.persistence.jpa.jpql.parser.EclipseLinkAnonymousExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.EntryExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExtractExpression;
import org.eclipse.persistence.jpa.jpql.parser.FunctionExpression;
import org.eclipse.persistence.jpa.jpql.parser.IdExpression;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.IndexExpression;
import org.eclipse.persistence.jpa.jpql.parser.Join;
import org.eclipse.persistence.jpa.jpql.parser.KeyExpression;
import org.eclipse.persistence.jpa.jpql.parser.KeywordExpression;
import org.eclipse.persistence.jpa.jpql.parser.LeftExpression;
import org.eclipse.persistence.jpa.jpql.parser.LengthExpression;
import org.eclipse.persistence.jpa.jpql.parser.LocateExpression;
import org.eclipse.persistence.jpa.jpql.parser.LowerExpression;
import org.eclipse.persistence.jpa.jpql.parser.MathDoubleExpression;
import org.eclipse.persistence.jpa.jpql.parser.MathSingleExpression;
import org.eclipse.persistence.jpa.jpql.parser.MaxFunction;
import org.eclipse.persistence.jpa.jpql.parser.MinFunction;
import org.eclipse.persistence.jpa.jpql.parser.ModExpression;
import org.eclipse.persistence.jpa.jpql.parser.MultiplicationExpression;
import org.eclipse.persistence.jpa.jpql.parser.NullIfExpression;
import org.eclipse.persistence.jpa.jpql.parser.NumericLiteral;
import org.eclipse.persistence.jpa.jpql.parser.ObjectExpression;
import org.eclipse.persistence.jpa.jpql.parser.ReplaceExpression;
import org.eclipse.persistence.jpa.jpql.parser.ResultVariable;
import org.eclipse.persistence.jpa.jpql.parser.RightExpression;
import org.eclipse.persistence.jpa.jpql.parser.SelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SizeExpression;
import org.eclipse.persistence.jpa.jpql.parser.SqrtExpression;
import org.eclipse.persistence.jpa.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.StringLiteral;
import org.eclipse.persistence.jpa.jpql.parser.SubExpression;
import org.eclipse.persistence.jpa.jpql.parser.SubstringExpression;
import org.eclipse.persistence.jpa.jpql.parser.SubtractionExpression;
import org.eclipse.persistence.jpa.jpql.parser.SumFunction;
import org.eclipse.persistence.jpa.jpql.parser.TreatExpression;
import org.eclipse.persistence.jpa.jpql.parser.TrimExpression;
import org.eclipse.persistence.jpa.jpql.parser.TypeExpression;
import org.eclipse.persistence.jpa.jpql.parser.UpperExpression;
import org.eclipse.persistence.jpa.jpql.parser.ValueExpression;
import org.eclipse.persistence.queries.ReportQuery;

final class ReportItemBuilder
extends JPQLFunctionsAbstractBuilder {
    private ConstructorExpressionVisitor constructorExpressionVisitor;
    private boolean multipleSelects;
    private ReportQuery query;
    private String resultVariable;
    final Class<?>[] type;

    ReportItemBuilder(JPQLQueryContext queryContext, ReportQuery query) {
        super(queryContext);
        this.query = query;
        this.type = new Class[1];
    }

    private void addAttribute(String generateName, org.eclipse.persistence.expressions.Expression queryExpression) {
        if (this.resultVariable != null) {
            generateName = this.resultVariable;
            this.queryContext.addQueryExpression(this.resultVariable.toUpperCase(), queryExpression);
        }
        this.query.addAttribute(generateName, queryExpression);
    }

    private void addAttribute(String generateName, org.eclipse.persistence.expressions.Expression queryExpression, Class<?> type) {
        if (this.resultVariable != null) {
            generateName = this.resultVariable;
            this.queryContext.addQueryExpression(this.resultVariable.toUpperCase(), queryExpression);
        }
        this.query.addAttribute(generateName, queryExpression, type);
    }

    private ConstructorExpressionVisitor constructorExpressionVisitor() {
        if (this.constructorExpressionVisitor == null) {
            this.constructorExpressionVisitor = new ConstructorExpressionVisitor();
        }
        return this.constructorExpressionVisitor;
    }

    @Override
    public void visit(AbsExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.addAttribute("", queryExpression, this.type[0]);
    }

    @Override
    public void visit(AdditionExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        if (this.type[0] == Object.class) {
            this.type[0] = null;
        }
        this.addAttribute("plus", queryExpression, this.type[0]);
    }

    @Override
    public void visit(ArithmeticFactor expression) {
        super.visit(expression);
    }

    @Override
    public void visit(AvgFunction expression) {
        String name = this.queryContext.literal(expression.getExpression(), LiteralType.PATH_EXPRESSION_LAST_PATH);
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.addAttribute(name, queryExpression, this.type[0]);
    }

    @Override
    public void visit(CaseExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.addAttribute("Case", queryExpression, this.type[0]);
    }

    @Override
    public void visit(CastExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.addAttribute("", queryExpression, this.type[0]);
    }

    @Override
    public void visit(CoalesceExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.addAttribute("Coalesce", queryExpression);
    }

    @Override
    public void visit(CollectionExpression expression) {
        this.multipleSelects = true;
        for (Expression child : expression.children()) {
            child.accept(this);
            this.type[0] = null;
        }
    }

    @Override
    public void visit(ConcatExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.addAttribute("", queryExpression, this.type[0]);
    }

    @Override
    public void visit(ConcatPipesExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        if (this.type[0] == Object.class) {
            this.type[0] = null;
        }
        this.addAttribute("ConcatPipes", queryExpression, this.type[0]);
    }

    @Override
    public void visit(ConstructorExpression expression) {
        Class<?> type = this.queryContext.getType(expression.getClassName());
        this.query.beginAddingConstructorArguments(type);
        expression.accept(this.constructorExpressionVisitor());
        this.query.endAddingToConstructorItem();
    }

    @Override
    public void visit(CountFunction expression) {
        String name = this.queryContext.literal(expression.getExpression(), LiteralType.PATH_EXPRESSION_LAST_PATH);
        if (name == "") {
            name = "COUNT";
        }
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.addAttribute(name, queryExpression, this.type[0]);
    }

    @Override
    public void visit(DateTime expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        if (expression.isJDBCDate()) {
            this.addAttribute("CONSTANT", queryExpression);
        } else {
            this.addAttribute("date", queryExpression, this.type[0]);
        }
    }

    @Override
    public void visit(DivisionExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        if (this.type[0] == Object.class) {
            this.type[0] = null;
        }
        this.addAttribute("divide", queryExpression, this.type[0]);
    }

    @Override
    public void visit(EntryExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.addAttribute(" MapEntry", queryExpression);
    }

    @Override
    public void visit(ExtractExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.addAttribute("", queryExpression, this.type[0]);
    }

    @Override
    public void visit(FunctionExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.addAttribute("", queryExpression);
    }

    @Override
    public void visit(IdentificationVariable expression) {
        String variableName = expression.getVariableName();
        ArrayList<org.eclipse.persistence.expressions.Expression> joinFetchExpressions = null;
        Collection<Join> joinFetches = this.queryContext.getJoinFetches(variableName);
        if (joinFetches != null) {
            for (Join joinFetch : joinFetches) {
                String joinFetchVariableName = this.queryContext.literal(joinFetch, LiteralType.PATH_EXPRESSION_IDENTIFICATION_VARIABLE);
                if (!variableName.equals(joinFetchVariableName)) continue;
                if (joinFetchExpressions == null) {
                    joinFetchExpressions = new ArrayList<org.eclipse.persistence.expressions.Expression>();
                }
                joinFetchExpressions.add(this.queryContext.buildExpression(joinFetch, this.type));
            }
        }
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        if (joinFetchExpressions == null) {
            this.query.addAttribute(expression.getText(), queryExpression);
        } else {
            this.query.addItem(expression.getText(), queryExpression, joinFetchExpressions);
        }
    }

    @Override
    public void visit(IndexExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.addAttribute("Index", queryExpression, this.type[0]);
    }

    @Override
    public void visit(KeyExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.addAttribute("MapKey", queryExpression);
    }

    @Override
    public void visit(KeywordExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.addAttribute("CONSTANT", queryExpression);
    }

    @Override
    public void visit(LeftExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.addAttribute("", queryExpression, this.type[0]);
    }

    @Override
    public void visit(LengthExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.addAttribute("", queryExpression, this.type[0]);
    }

    @Override
    public void visit(LocateExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.addAttribute("", queryExpression, this.type[0]);
    }

    @Override
    public void visit(LowerExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.addAttribute("", queryExpression, this.type[0]);
    }

    @Override
    public void visit(MathDoubleExpression.Power expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.addAttribute("", queryExpression, this.type[0]);
    }

    @Override
    public void visit(MathDoubleExpression.Round expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.addAttribute("", queryExpression, this.type[0]);
    }

    @Override
    public void visit(MathSingleExpression.Ceiling expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.addAttribute("", queryExpression, this.type[0]);
    }

    @Override
    public void visit(MathSingleExpression.Exp expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.addAttribute("", queryExpression, this.type[0]);
    }

    @Override
    public void visit(MathSingleExpression.Floor expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.addAttribute("", queryExpression, this.type[0]);
    }

    @Override
    public void visit(MathSingleExpression.Ln expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.addAttribute("", queryExpression, this.type[0]);
    }

    @Override
    public void visit(MathSingleExpression.Sign expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.addAttribute("", queryExpression, this.type[0]);
    }

    @Override
    public void visit(MaxFunction expression) {
        String name = this.queryContext.literal(expression.getExpression(), LiteralType.PATH_EXPRESSION_LAST_PATH);
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.addAttribute(name, queryExpression, this.type[0]);
    }

    @Override
    public void visit(MinFunction expression) {
        String name = this.queryContext.literal(expression.getExpression(), LiteralType.PATH_EXPRESSION_LAST_PATH);
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.addAttribute(name, queryExpression, this.type[0]);
    }

    @Override
    public void visit(ModExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.addAttribute("", queryExpression, this.type[0]);
    }

    @Override
    public void visit(MultiplicationExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        if (this.type[0] == Object.class) {
            this.type[0] = null;
        }
        this.addAttribute("multiply", queryExpression, this.type[0]);
    }

    @Override
    public void visit(NullIfExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.addAttribute("NULLIF", queryExpression);
    }

    @Override
    public void visit(NumericLiteral expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.addAttribute("CONSTANT", queryExpression);
    }

    @Override
    public void visit(ObjectExpression expression) {
        expression.getExpression().accept(this);
    }

    @Override
    protected void visit(Expression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.addAttribute("", queryExpression);
    }

    @Override
    public void visit(ReplaceExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.addAttribute("", queryExpression, this.type[0]);
    }

    @Override
    public void visit(ResultVariable expression) {
        IdentificationVariable identificationVariable = (IdentificationVariable)expression.getResultVariable();
        this.resultVariable = identificationVariable.getText();
        expression.getSelectExpression().accept(this);
        this.resultVariable = null;
    }

    @Override
    public void visit(RightExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.addAttribute("", queryExpression, this.type[0]);
    }

    @Override
    public void visit(SelectClause expression) {
        this.visitAbstractSelectClause(expression);
    }

    @Override
    public void visit(SimpleSelectClause expression) {
        this.visitAbstractSelectClause(expression);
    }

    @Override
    public void visit(SizeExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression.getExpression());
        this.addAttribute("size", queryExpression.count(), Integer.class);
        CollectionValuedPathExpression pathExpression = (CollectionValuedPathExpression)expression.getExpression();
        queryExpression = this.queryContext.buildGroupByExpression(pathExpression);
        this.query.addGrouping(queryExpression);
    }

    @Override
    public void visit(SqrtExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.addAttribute("", queryExpression, this.type[0]);
    }

    @Override
    public void visit(StateFieldPathExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildModifiedPathExpression(expression);
        String name = expression.getPath(expression.pathSize() - 1);
        this.addAttribute(name, queryExpression);
        this.query.dontRetrievePrimaryKeys();
    }

    @Override
    public void visit(StringLiteral expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.addAttribute("CONSTANT", queryExpression);
    }

    @Override
    public void visit(SubExpression expression) {
        expression.getExpression().accept(this);
    }

    @Override
    public void visit(SubstringExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.addAttribute("", queryExpression, this.type[0]);
    }

    @Override
    public void visit(SubtractionExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        if (this.type[0] == Object.class) {
            this.type[0] = null;
        }
        this.addAttribute("minus", queryExpression, this.type[0]);
    }

    @Override
    public void visit(SumFunction expression) {
        String name = this.queryContext.literal(expression.getExpression(), LiteralType.PATH_EXPRESSION_LAST_PATH);
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.addAttribute(name, queryExpression, this.type[0]);
    }

    @Override
    public void visit(TreatExpression expression) {
    }

    @Override
    public void visit(TrimExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.addAttribute("", queryExpression, this.type[0]);
    }

    @Override
    public void visit(TypeExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.addAttribute("", queryExpression);
    }

    @Override
    public void visit(UpperExpression expression) {
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.addAttribute("", queryExpression, this.type[0]);
    }

    @Override
    public void visit(ValueExpression expression) {
        IdentificationVariable identificationVariable = (IdentificationVariable)expression.getExpression();
        org.eclipse.persistence.expressions.Expression queryExpression = this.queryContext.buildExpression(expression, this.type);
        this.addAttribute(identificationVariable.getText(), queryExpression);
    }

    @Override
    public void visit(IdExpression expression) {
        super.visit(expression);
        if (expression.getStateFieldPathExpressions().size() > 1) {
            this.multipleSelects = true;
        }
    }

    private void visitAbstractSelectClause(AbstractSelectClause expression) {
        this.multipleSelects = false;
        expression.getSelectExpression().accept(this);
        if (this.multipleSelects) {
            this.query.returnWithoutReportQueryResult();
        } else {
            this.query.returnSingleAttribute();
        }
        if ("id_function".equals(expression.getSelectExpression().getQueryBNF().getId())) {
            this.query.setHasIDFunctionSelectItemOnly(true);
        }
    }

    private class ConstructorExpressionVisitor
    extends EclipseLinkAnonymousExpressionVisitor {
        private ConstructorExpressionVisitor() {
        }

        @Override
        public void visit(CollectionExpression expression) {
            expression.acceptChildren(this);
        }

        @Override
        public void visit(ConstructorExpression expression) {
            expression.getConstructorItems().accept(this);
        }

        @Override
        protected void visit(Expression expression) {
            expression.accept(ReportItemBuilder.this);
        }
    }
}

