/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.Assert;
import org.eclipse.persistence.jpa.jpql.tools.RefactoringDelta;
import org.eclipse.persistence.jpa.jpql.tools.TextEdit;
import org.eclipse.persistence.jpa.jpql.utility.iterable.ListIterable;
import org.eclipse.persistence.jpa.jpql.utility.iterable.SnapshotCloneListIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRefactoringDelta
implements RefactoringDelta {
    private CharSequence jpqlQuery;
    private List<TextEdit> textEdits;

    public DefaultRefactoringDelta(CharSequence jpqlQuery) {
        this.initialize(jpqlQuery);
    }

    public void addTextEdit(TextEdit textEdit) {
        Assert.isNotNull(textEdit, "The TextEdit cannot be null");
        if (this.textEdits.isEmpty()) {
            this.textEdits.add(textEdit);
        } else {
            int position = this.calculateInsertionPosition(textEdit);
            this.textEdits.add(position, textEdit);
        }
    }

    public void addTextEdits(Iterable<? extends TextEdit> textEdits) {
        Assert.isNotNull(textEdits, "The Iterable<TextEdit> cannot be null");
        for (TextEdit textEdit : textEdits) {
            this.addTextEdit(textEdit);
        }
    }

    @Override
    public String applyChanges() {
        if (this.textEdits.isEmpty()) {
            return this.jpqlQuery.toString();
        }
        StringBuilder result = new StringBuilder(this.jpqlQuery);
        int index = 0;
        int count = this.size();
        while (index < count) {
            TextEdit textEdit = this.textEdits.get(index);
            int offset = textEdit.getOffset();
            result.replace(offset, offset + textEdit.getLength(), textEdit.getNewValue());
            ++index;
        }
        this.textEdits.clear();
        return result.toString();
    }

    protected int calculateInsertionPosition(TextEdit textEdit) {
        int position;
        int index = position = this.size();
        while (--index >= 0) {
            TextEdit edit = this.textEdits.get(index);
            if (textEdit.getOffset() <= edit.getOffset()) break;
            position = index;
        }
        return position;
    }

    @Override
    public boolean hasTextEdits() {
        return !this.textEdits.isEmpty();
    }

    protected void initialize(CharSequence jpqlQuery) {
        Assert.isNotNull(jpqlQuery, "The JPQL query cannot be null");
        this.jpqlQuery = jpqlQuery;
        this.textEdits = new LinkedList<TextEdit>();
    }

    @Override
    public int size() {
        return this.textEdits.size();
    }

    public ListIterable<TextEdit> textEdits() {
        return new SnapshotCloneListIterable<TextEdit>(this.textEdits);
    }

    public String toString() {
        return this.textEdits.toString();
    }
}

