/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.PropertyException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jaxb.IDResolverWrapper;
import org.eclipse.persistence.internal.jaxb.WrappedValue;
import org.eclipse.persistence.internal.jaxb.many.ManyValue;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.record.XMLEventReaderInputSource;
import org.eclipse.persistence.internal.oxm.record.XMLEventReaderReader;
import org.eclipse.persistence.internal.oxm.record.XMLReader;
import org.eclipse.persistence.internal.oxm.record.XMLStreamReaderInputSource;
import org.eclipse.persistence.internal.oxm.record.XMLStreamReaderReader;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.JAXBErrorHandler;
import org.eclipse.persistence.jaxb.JAXBUnmarshalListener;
import org.eclipse.persistence.jaxb.JAXBUnmarshallerHandler;
import org.eclipse.persistence.jaxb.TypeMappingInfo;
import org.eclipse.persistence.jaxb.attachment.AttachmentUnmarshallerAdapter;
import org.eclipse.persistence.oxm.IDResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.XMLUnmarshalListener;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.attachment.XMLAttachmentUnmarshaller;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JAXBUnmarshaller
implements Unmarshaller {
    private static final String SUN_ID_RESOLVER = "com.sun.xml.bind.IDResolver";
    private static final String SUN_JSE_ID_RESOLVER = "com.sun.xml.internal.bind.IDResolver";
    private ValidationEventHandler validationEventHandler = new DefaultValidationEventHandler();
    private XMLUnmarshaller xmlUnmarshaller;
    private JAXBContext jaxbContext;
    private XMLInputFactory xmlInputFactory;
    private boolean initializedXMLInputFactory = false;
    public static final String XML_JAVATYPE_ADAPTERS = "xml-javatype-adapters";
    public static final String STAX_SOURCE_CLASS_NAME = "javax.xml.transform.stax.StAXSource";

    public JAXBUnmarshaller(XMLUnmarshaller newXMLUnmarshaller) {
        this.xmlUnmarshaller = newXMLUnmarshaller;
        this.xmlUnmarshaller.setValidationMode(0);
        this.xmlUnmarshaller.setUnmarshalListener((XMLUnmarshalListener)new JAXBUnmarshalListener(this));
        this.xmlUnmarshaller.setErrorHandler((ErrorHandler)new JAXBErrorHandler(this.validationEventHandler));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XMLInputFactory getXMLInputFactory() {
        if (!this.initializedXMLInputFactory) {
            try {
                this.xmlInputFactory = XMLInputFactory.newInstance();
            }
            catch (FactoryConfigurationError factoryConfigurationError) {
            }
            finally {
                this.initializedXMLInputFactory = true;
            }
        }
        return this.xmlInputFactory;
    }

    public XMLUnmarshaller getXMLUnmarshaller() {
        return this.xmlUnmarshaller;
    }

    public Object unmarshal(File file) throws JAXBException {
        try {
            Object value = this.xmlUnmarshaller.unmarshal(file);
            return this.createJAXBElementOrUnwrapIfRequired(value);
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public Object unmarshal(InputStream inputStream) throws JAXBException {
        try {
            XMLInputFactory xmlInputFactory = this.getXMLInputFactory();
            if (null == xmlInputFactory || 0 != this.xmlUnmarshaller.getValidationMode()) {
                return this.createJAXBElementOrUnwrapIfRequired(this.xmlUnmarshaller.unmarshal(inputStream));
            }
            if (null == inputStream) {
                throw XMLMarshalException.nullArgumentException();
            }
            XMLStreamReader xmlStreamReader = xmlInputFactory.createXMLStreamReader(inputStream);
            Object value = this.unmarshal(xmlStreamReader);
            xmlStreamReader.close();
            return value;
        }
        catch (JAXBException jaxbException) {
            throw jaxbException;
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
        catch (Exception exception) {
            throw new UnmarshalException((Throwable)exception);
        }
    }

    public Object unmarshal(URL url) throws JAXBException {
        try {
            Object value = this.xmlUnmarshaller.unmarshal(url);
            return this.createJAXBElementOrUnwrapIfRequired(value);
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public Object unmarshal(InputSource inputSource) throws JAXBException {
        try {
            Object value = this.xmlUnmarshaller.unmarshal(inputSource);
            return this.createJAXBElementOrUnwrapIfRequired(value);
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public Object unmarshal(Reader reader) throws JAXBException {
        try {
            XMLInputFactory xmlInputFactory = this.getXMLInputFactory();
            if (null == xmlInputFactory || 0 != this.xmlUnmarshaller.getValidationMode()) {
                return this.createJAXBElementOrUnwrapIfRequired(this.xmlUnmarshaller.unmarshal(reader));
            }
            if (null == reader) {
                throw XMLMarshalException.nullArgumentException();
            }
            XMLStreamReader xmlStreamReader = xmlInputFactory.createXMLStreamReader(reader);
            Object value = this.unmarshal(xmlStreamReader);
            xmlStreamReader.close();
            return value;
        }
        catch (JAXBException jaxbException) {
            throw jaxbException;
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
        catch (Exception exception) {
            throw new UnmarshalException((Throwable)exception);
        }
    }

    public Object unmarshal(Node node) throws JAXBException {
        try {
            Object value = this.xmlUnmarshaller.unmarshal(node);
            return this.createJAXBElementOrUnwrapIfRequired(value);
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    private JAXBElement buildJAXBElementFromObject(Object obj, Class declaredClass) {
        if (obj instanceof XMLRoot) {
            JAXBElement jaxbElement = this.createJAXBElementFromXMLRoot((XMLRoot)obj, declaredClass);
            if (((XMLRoot)obj).isNil()) {
                jaxbElement.setNil(((XMLRoot)obj).isNil());
                jaxbElement.setValue(null);
            }
            return jaxbElement;
        }
        if (obj instanceof JAXBElement) {
            return (JAXBElement)obj;
        }
        AbstractSession sess = this.xmlUnmarshaller.getXMLContext().getSession(obj);
        XMLDescriptor desc = (XMLDescriptor)sess.getClassDescriptor(obj);
        String rootName = desc.getDefaultRootElement();
        if (rootName == null) {
            return this.createJAXBElement(new QName(""), obj.getClass(), obj);
        }
        String rootNamespaceUri = null;
        int idx = rootName.indexOf(":");
        if (idx != -1) {
            rootNamespaceUri = desc.getNamespaceResolver().resolveNamespacePrefix(rootName.substring(0, idx));
            rootName = rootName.substring(idx + 1);
        }
        QName qname = rootNamespaceUri == null ? new QName(rootName) : new QName(rootNamespaceUri, rootName);
        if (declaredClass != null) {
            return this.createJAXBElement(qname, declaredClass, obj);
        }
        return this.createJAXBElement(qname, obj.getClass(), obj);
    }

    public JAXBElement unmarshal(Node node, Class javaClass) throws JAXBException {
        if (null == javaClass) {
            throw new IllegalArgumentException();
        }
        try {
            Class generatedClass;
            Class classToUnmarshalTo = this.getClassToUnmarshalTo(javaClass);
            if (this.jaxbContext.getArrayClassesToGeneratedClasses() != null && (generatedClass = this.jaxbContext.getArrayClassesToGeneratedClasses().get(javaClass.getCanonicalName())) != null) {
                classToUnmarshalTo = generatedClass;
            }
            return this.buildJAXBElementFromObject(this.xmlUnmarshaller.unmarshal(node, classToUnmarshalTo), javaClass);
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public Object unmarshal(Source source) throws JAXBException {
        try {
            Object value = this.xmlUnmarshaller.unmarshal(source);
            return this.createJAXBElementOrUnwrapIfRequired(value);
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public JAXBElement unmarshal(Source source, Class javaClass) throws JAXBException {
        if (null == javaClass) {
            throw new IllegalArgumentException();
        }
        try {
            Class classToUnmarshalTo = this.getClassToUnmarshalTo(javaClass);
            return this.buildJAXBElementFromObject(this.xmlUnmarshaller.unmarshal(source, classToUnmarshalTo), javaClass);
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    private JAXBElement unmarshal(Source source, Class javaClass, Class declaredType) {
        Class generatedClass;
        Class classToUnmarshalTo = javaClass;
        if (this.jaxbContext.getArrayClassesToGeneratedClasses() != null && (generatedClass = this.jaxbContext.getArrayClassesToGeneratedClasses().get(javaClass.getCanonicalName())) != null) {
            classToUnmarshalTo = generatedClass;
        }
        return this.buildJAXBElementFromObject(this.xmlUnmarshaller.unmarshal(source, classToUnmarshalTo), declaredType);
    }

    public JAXBElement unmarshal(Source source, Type type) throws JAXBException {
        if (null == type) {
            throw new IllegalArgumentException();
        }
        try {
            TypeMappingInfo tmi;
            if (this.jaxbContext.getTypeToTypeMappingInfo() != null && (tmi = this.jaxbContext.getTypeToTypeMappingInfo().get(type)) != null) {
                return this.unmarshal(source, tmi);
            }
            Class unmarshalClass = this.jaxbContext.getCollectionClassesToGeneratedClasses().get(type);
            if (unmarshalClass != null) {
                JAXBElement unmarshalled = this.unmarshal(source, unmarshalClass, Object.class);
                Class declaredClass = null;
                declaredClass = type instanceof Class ? (Class)type : Object.class;
                JAXBElement returnVal = new JAXBElement(unmarshalled.getName(), declaredClass, unmarshalled.getScope(), unmarshalled.getValue());
                return returnVal;
            }
            if (type instanceof Class) {
                return this.unmarshal(source, (Class)type, Object.class);
            }
            return null;
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public JAXBElement unmarshal(Source source, TypeMappingInfo type) throws JAXBException {
        try {
            Class unmarshalClass = this.jaxbContext.getTypeMappingInfoToGeneratedType().get(type);
            JAXBContext.RootLevelXmlAdapter adapter = this.jaxbContext.getTypeMappingInfoToJavaTypeAdapters().get(type);
            if (unmarshalClass != null) {
                JAXBElement unmarshalled = this.unmarshal(source, unmarshalClass);
                Class declaredClass = null;
                declaredClass = type.getType() instanceof Class ? (Class)type.getType() : Object.class;
                Object value = unmarshalled.getValue();
                if (adapter != null) {
                    try {
                        value = adapter.getXmlAdapter().unmarshal(value);
                    }
                    catch (Exception ex) {
                        throw new JAXBException((Throwable)XMLMarshalException.marshalException((Exception)ex));
                    }
                }
                JAXBElement returnVal = new JAXBElement(unmarshalled.getName(), declaredClass, unmarshalled.getScope(), unmarshalled.getValue());
                return returnVal;
            }
            if (type.getType() instanceof Class) {
                if (adapter != null) {
                    JAXBElement element = this.unmarshal(source, adapter.getBoundType());
                    try {
                        Object value = adapter.getXmlAdapter().unmarshal(element.getValue());
                        element.setValue(value);
                        return element;
                    }
                    catch (Exception ex) {
                        throw new JAXBException((Throwable)XMLMarshalException.marshalException((Exception)ex));
                    }
                }
                return this.unmarshal(source, (Class)type.getType());
            }
            if (type.getType() instanceof ParameterizedType) {
                return this.unmarshal(source, ((ParameterizedType)type.getType()).getRawType());
            }
            return null;
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public JAXBElement unmarshal(XMLStreamReader streamReader, Class javaClass) throws JAXBException {
        if (null == streamReader || null == javaClass) {
            throw new IllegalArgumentException();
        }
        try {
            XMLStreamReaderReader staxReader = new XMLStreamReaderReader(this.xmlUnmarshaller);
            XMLStreamReaderInputSource inputSource = new XMLStreamReaderInputSource(streamReader);
            if (XMLConversionManager.getDefaultJavaTypes().get(javaClass) != null || ClassConstants.XML_GREGORIAN_CALENDAR.isAssignableFrom(javaClass) || ClassConstants.DURATION.isAssignableFrom(javaClass)) {
                PrimitiveContentHandler primitiveContentHandler = new PrimitiveContentHandler(javaClass);
                staxReader.setContentHandler(primitiveContentHandler);
                staxReader.parse((InputSource)inputSource);
                return primitiveContentHandler.getJaxbElement();
            }
            Class classToUnmarshalTo = this.getClassToUnmarshalTo(javaClass);
            JAXBElement unmarshalled = this.buildJAXBElementFromObject(this.xmlUnmarshaller.unmarshal((org.xml.sax.XMLReader)staxReader, (InputSource)inputSource, classToUnmarshalTo), javaClass);
            if (classToUnmarshalTo != javaClass) {
                JAXBElement returnVal = new JAXBElement(unmarshalled.getName(), javaClass, unmarshalled.getScope(), unmarshalled.getValue());
                return returnVal;
            }
            return unmarshalled;
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
        catch (Exception e) {
            throw new JAXBException((Throwable)e);
        }
    }

    public JAXBElement unmarshal(XMLStreamReader streamReader, Type type) throws JAXBException {
        if (null == streamReader || null == type) {
            throw new IllegalArgumentException();
        }
        try {
            TypeMappingInfo tmi;
            if (this.jaxbContext.getTypeToTypeMappingInfo() != null && (tmi = this.jaxbContext.getTypeToTypeMappingInfo().get(type)) != null) {
                return this.unmarshal(streamReader, tmi);
            }
            Class unmarshalClass = this.jaxbContext.getCollectionClassesToGeneratedClasses().get(type);
            if (unmarshalClass != null) {
                JAXBElement unmarshalled = this.unmarshal(streamReader, unmarshalClass);
                Class declaredClass = null;
                declaredClass = type instanceof Class ? (Class)type : Object.class;
                JAXBElement returnVal = new JAXBElement(unmarshalled.getName(), declaredClass, unmarshalled.getScope(), unmarshalled.getValue());
                return returnVal;
            }
            if (type instanceof Class) {
                return this.unmarshal(streamReader, (Class)type);
            }
            return null;
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public JAXBElement unmarshal(XMLStreamReader streamReader, TypeMappingInfo type) throws JAXBException {
        try {
            XMLDescriptor xmlDescriptor = type.getXmlDescriptor();
            if (null != xmlDescriptor && null == this.getSchema()) {
                JAXBContext.RootLevelXmlAdapter adapter = null;
                if (this.jaxbContext.getTypeMappingInfoToJavaTypeAdapters().size() > 0) {
                    adapter = this.jaxbContext.getTypeMappingInfoToJavaTypeAdapters().get(type);
                }
                UnmarshalRecord unmarshalRecord = (UnmarshalRecord)xmlDescriptor.getObjectBuilder().createRecord((AbstractSession)this.xmlUnmarshaller.getXMLContext().getSession(0));
                XMLStreamReaderReader staxReader = new XMLStreamReaderReader(this.xmlUnmarshaller);
                unmarshalRecord.setUnmarshaller(this.xmlUnmarshaller);
                unmarshalRecord.setXMLReader((XMLReader)staxReader);
                staxReader.setContentHandler((ContentHandler)unmarshalRecord);
                staxReader.parse(streamReader);
                Object value = null;
                value = unmarshalRecord.isNil() ? null : unmarshalRecord.getCurrentObject();
                if (value instanceof WrappedValue) {
                    value = ((WrappedValue)((Object)value)).getValue();
                }
                if (value instanceof ManyValue) {
                    value = ((ManyValue)value).getItem();
                }
                if (adapter != null) {
                    try {
                        value = adapter.getXmlAdapter().unmarshal(value);
                    }
                    catch (Exception ex) {
                        throw new JAXBException((Throwable)XMLMarshalException.marshalException((Exception)ex));
                    }
                }
                Class declaredClass = null;
                declaredClass = type.getType() instanceof Class ? (Class)type.getType() : Object.class;
                return new JAXBElement(new QName(unmarshalRecord.getRootElementNamespaceUri(), unmarshalRecord.getLocalName()), declaredClass, value);
            }
            if (this.jaxbContext.getTypeMappingInfoToGeneratedType() == null) {
                return this.unmarshal(streamReader, type.getType());
            }
            JAXBContext.RootLevelXmlAdapter adapter = null;
            if (this.jaxbContext.getTypeMappingInfoToJavaTypeAdapters().size() > 0) {
                adapter = this.jaxbContext.getTypeMappingInfoToJavaTypeAdapters().get(type);
            }
            Class unmarshalClass = null;
            if (this.jaxbContext.getTypeMappingInfoToGeneratedType().size() > 0) {
                unmarshalClass = this.jaxbContext.getTypeMappingInfoToGeneratedType().get(type);
            }
            if (unmarshalClass != null) {
                JAXBElement unmarshalled = this.unmarshal(streamReader, unmarshalClass);
                Class declaredClass = null;
                declaredClass = type.getType() instanceof Class ? (Class)type.getType() : Object.class;
                Object value = unmarshalled.getValue();
                if (adapter != null) {
                    try {
                        value = adapter.getXmlAdapter().unmarshal(value);
                    }
                    catch (Exception ex) {
                        throw new JAXBException((Throwable)XMLMarshalException.marshalException((Exception)ex));
                    }
                }
                JAXBElement returnVal = new JAXBElement(unmarshalled.getName(), declaredClass, unmarshalled.getScope(), value);
                return returnVal;
            }
            if (type.getType() instanceof Class) {
                if (adapter != null) {
                    JAXBElement element = this.unmarshal(streamReader, adapter.getBoundType());
                    try {
                        Object value = adapter.getXmlAdapter().unmarshal(element.getValue());
                        element.setValue(value);
                        return element;
                    }
                    catch (Exception ex) {
                        throw new JAXBException((Throwable)XMLMarshalException.marshalException((Exception)ex));
                    }
                }
                return this.unmarshal(streamReader, (Class)type.getType());
            }
            if (type.getType() instanceof ParameterizedType) {
                return this.unmarshal(streamReader, ((ParameterizedType)type.getType()).getRawType());
            }
            return null;
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
        catch (SAXException e) {
            throw new JAXBException((Throwable)e);
        }
    }

    public Object unmarshal(XMLStreamReader streamReader) throws JAXBException {
        if (null == streamReader) {
            throw new IllegalArgumentException();
        }
        try {
            XMLStreamReaderReader staxReader = new XMLStreamReaderReader(this.xmlUnmarshaller);
            XMLStreamReaderInputSource inputSource = new XMLStreamReaderInputSource(streamReader);
            Object value = this.xmlUnmarshaller.unmarshal((org.xml.sax.XMLReader)staxReader, (InputSource)inputSource);
            return this.createJAXBElementOrUnwrapIfRequired(value);
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public JAXBElement unmarshal(XMLEventReader eventReader, Class javaClass) throws JAXBException {
        if (null == eventReader || null == javaClass) {
            throw new IllegalArgumentException();
        }
        try {
            Class classToUnmarshalTo = this.getClassToUnmarshalTo(javaClass);
            XMLEventReaderReader staxReader = new XMLEventReaderReader(this.xmlUnmarshaller);
            XMLEventReaderInputSource inputSource = new XMLEventReaderInputSource(eventReader);
            JAXBElement unmarshalled = this.buildJAXBElementFromObject(this.xmlUnmarshaller.unmarshal((org.xml.sax.XMLReader)staxReader, (InputSource)inputSource, classToUnmarshalTo), javaClass);
            if (classToUnmarshalTo != javaClass) {
                JAXBElement returnVal = new JAXBElement(unmarshalled.getName(), javaClass, unmarshalled.getScope(), unmarshalled.getValue());
                return returnVal;
            }
            return unmarshalled;
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public JAXBElement unmarshal(XMLEventReader eventReader, Type type) throws JAXBException {
        if (null == eventReader || null == type) {
            throw new IllegalArgumentException();
        }
        try {
            TypeMappingInfo tmi;
            if (this.jaxbContext.getTypeToTypeMappingInfo() != null && (tmi = this.jaxbContext.getTypeToTypeMappingInfo().get(type)) != null) {
                return this.unmarshal(eventReader, tmi);
            }
            Class unmarshalClass = this.jaxbContext.getCollectionClassesToGeneratedClasses().get(type);
            if (unmarshalClass != null) {
                JAXBElement unmarshalled = this.unmarshal(eventReader, unmarshalClass);
                Class declaredClass = null;
                declaredClass = type instanceof Class ? (Class)type : Object.class;
                JAXBElement returnVal = new JAXBElement(unmarshalled.getName(), declaredClass, unmarshalled.getScope(), unmarshalled.getValue());
                return returnVal;
            }
            if (type instanceof Class) {
                return this.unmarshal(eventReader, (Class)type);
            }
            return null;
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public JAXBElement unmarshal(XMLEventReader eventReader, TypeMappingInfo type) throws JAXBException {
        try {
            if (this.jaxbContext.getTypeMappingInfoToGeneratedType() == null) {
                return this.unmarshal(eventReader, type.getType());
            }
            Class unmarshalClass = this.jaxbContext.getTypeMappingInfoToGeneratedType().get(type);
            JAXBContext.RootLevelXmlAdapter adapter = this.jaxbContext.getTypeMappingInfoToJavaTypeAdapters().get(type);
            if (unmarshalClass != null) {
                JAXBElement unmarshalled = this.unmarshal(eventReader, unmarshalClass);
                Class declaredClass = null;
                declaredClass = type.getType() instanceof Class ? (Class)type.getType() : Object.class;
                Object value = unmarshalled.getValue();
                if (adapter != null) {
                    try {
                        value = adapter.getXmlAdapter().unmarshal(value);
                    }
                    catch (Exception ex) {
                        throw new JAXBException((Throwable)XMLMarshalException.marshalException((Exception)ex));
                    }
                }
                JAXBElement returnVal = new JAXBElement(unmarshalled.getName(), declaredClass, unmarshalled.getScope(), value);
                return returnVal;
            }
            if (type.getType() instanceof Class) {
                if (adapter != null) {
                    JAXBElement element = this.unmarshal(eventReader, adapter.getBoundType());
                    try {
                        Object value = adapter.getXmlAdapter().unmarshal(element.getValue());
                        element.setValue(value);
                        return element;
                    }
                    catch (Exception ex) {
                        throw new JAXBException((Throwable)XMLMarshalException.marshalException((Exception)ex));
                    }
                }
                return this.unmarshal(eventReader, (Class)type.getType());
            }
            if (type.getType() instanceof ParameterizedType) {
                return this.unmarshal(eventReader, ((ParameterizedType)type.getType()).getRawType());
            }
            return null;
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public Object unmarshal(XMLEventReader eventReader) throws JAXBException {
        if (null == eventReader) {
            throw new IllegalArgumentException();
        }
        try {
            XMLEventReaderReader staxReader = new XMLEventReaderReader(this.xmlUnmarshaller);
            XMLEventReaderInputSource inputSource = new XMLEventReaderInputSource(eventReader);
            Object value = this.xmlUnmarshaller.unmarshal((org.xml.sax.XMLReader)staxReader, (InputSource)inputSource);
            return this.createJAXBElementOrUnwrapIfRequired(value);
        }
        catch (XMLMarshalException xmlMarshalException) {
            throw this.handleXMLMarshalException(xmlMarshalException);
        }
    }

    public UnmarshallerHandler getUnmarshallerHandler() {
        return new JAXBUnmarshallerHandler(this);
    }

    public void setValidating(boolean validate) throws JAXBException {
        if (validate) {
            this.xmlUnmarshaller.setValidationMode(3);
        } else {
            this.xmlUnmarshaller.setValidationMode(0);
        }
    }

    public boolean isValidating() throws JAXBException {
        return this.xmlUnmarshaller.getValidationMode() != 0;
    }

    public void setEventHandler(ValidationEventHandler newValidationEventHandler) throws JAXBException {
        this.validationEventHandler = null == newValidationEventHandler ? new DefaultValidationEventHandler() : newValidationEventHandler;
        this.xmlUnmarshaller.setErrorHandler((ErrorHandler)new JAXBErrorHandler(this.validationEventHandler));
    }

    public ValidationEventHandler getEventHandler() throws JAXBException {
        return this.validationEventHandler;
    }

    public void setProperty(String key, Object value) throws PropertyException {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if ("eclipselink.id-resolver".equals(key)) {
            this.setIDResolver((IDResolver)value);
        } else if (SUN_ID_RESOLVER.equals(key) || SUN_JSE_ID_RESOLVER.equals(key)) {
            this.setIDResolver(new IDResolverWrapper(value));
        } else {
            throw new PropertyException(key, value);
        }
    }

    public Object getProperty(String key) throws PropertyException {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if ("eclipselink.id-resolver".equals(key)) {
            return this.xmlUnmarshaller.getIDResolver();
        }
        if (SUN_ID_RESOLVER.equals(key) || SUN_JSE_ID_RESOLVER.equals(key)) {
            IDResolverWrapper wrapper = (IDResolverWrapper)this.xmlUnmarshaller.getIDResolver();
            return wrapper.getResolver();
        }
        throw new PropertyException(key);
    }

    public Unmarshaller.Listener getListener() {
        return ((JAXBUnmarshalListener)this.xmlUnmarshaller.getUnmarshalListener()).getListener();
    }

    public void setListener(Unmarshaller.Listener listener) {
        ((JAXBUnmarshalListener)this.xmlUnmarshaller.getUnmarshalListener()).setListener(listener);
    }

    public XmlAdapter getAdapter(Class javaClass) {
        HashMap result = (HashMap)this.xmlUnmarshaller.getProperty((Object)XML_JAVATYPE_ADAPTERS);
        if (result == null) {
            return null;
        }
        return (XmlAdapter)result.get(javaClass);
    }

    public void setAdapter(Class javaClass, XmlAdapter adapter) {
        HashMap<Class, XmlAdapter> result = (HashMap<Class, XmlAdapter>)this.xmlUnmarshaller.getProperty((Object)XML_JAVATYPE_ADAPTERS);
        if (result == null) {
            result = new HashMap<Class, XmlAdapter>();
            this.xmlUnmarshaller.getProperties().put(XML_JAVATYPE_ADAPTERS, result);
        }
        result.put(javaClass, adapter);
    }

    public void setAdapter(XmlAdapter adapter) {
        this.setAdapter(adapter.getClass(), adapter);
    }

    public void setSchema(Schema schema) {
        this.xmlUnmarshaller.setSchema(schema);
    }

    public Schema getSchema() {
        return this.xmlUnmarshaller.getSchema();
    }

    public AttachmentUnmarshaller getAttachmentUnmarshaller() {
        if (this.xmlUnmarshaller.getAttachmentUnmarshaller() == null) {
            return null;
        }
        return ((AttachmentUnmarshallerAdapter)this.xmlUnmarshaller.getAttachmentUnmarshaller()).getAttachmentUnmarshaller();
    }

    public void setAttachmentUnmarshaller(AttachmentUnmarshaller unmarshaller) {
        if (unmarshaller == null) {
            this.xmlUnmarshaller.setAttachmentUnmarshaller(null);
        } else {
            this.xmlUnmarshaller.setAttachmentUnmarshaller((XMLAttachmentUnmarshaller)new AttachmentUnmarshallerAdapter(unmarshaller));
        }
    }

    public void setUnmarshalCallbacks(HashMap callbacks) {
        ((JAXBUnmarshalListener)this.xmlUnmarshaller.getUnmarshalListener()).setClassBasedUnmarshalEvents(callbacks);
    }

    private Object createJAXBElementOrUnwrapIfRequired(Object value) {
        if (value instanceof XMLRoot) {
            JAXBElement jaxbElement = this.createJAXBElementFromXMLRoot((XMLRoot)value, Object.class);
            jaxbElement.setNil(((XMLRoot)value).isNil());
            return jaxbElement;
        }
        if (value instanceof WrappedValue) {
            return ((WrappedValue)((Object)value)).getValue();
        }
        return value;
    }

    private JAXBElement createJAXBElementFromXMLRoot(XMLRoot xmlRoot, Class declaredType) {
        Class declaredClass;
        HashMap<QName, Class> qNamesToDeclaredClasses;
        Object value = xmlRoot.getObject();
        if (value instanceof WrappedValue) {
            QName qname = new QName(xmlRoot.getNamespaceURI(), xmlRoot.getLocalName());
            return new JAXBElement(qname, ((WrappedValue)((Object)value)).getDeclaredType(), ((WrappedValue)((Object)value)).getValue());
        }
        if (value instanceof JAXBElement) {
            return (JAXBElement)value;
        }
        QName qname = new QName(xmlRoot.getNamespaceURI(), xmlRoot.getLocalName());
        if (value instanceof ManyValue) {
            value = ((ManyValue)value).getItem();
        }
        if ((qNamesToDeclaredClasses = this.jaxbContext.getQNamesToDeclaredClasses()) != null && qNamesToDeclaredClasses.size() > 0 && (declaredClass = (Class)qNamesToDeclaredClasses.get(qname)) != null) {
            return this.createJAXBElement(qname, declaredClass, value);
        }
        XMLDescriptor descriptorForQName = this.xmlUnmarshaller.getXMLContext().getDescriptor(qname);
        if (descriptorForQName != null) {
            return this.createJAXBElement(qname, descriptorForQName.getJavaClass(), value);
        }
        if (value != null) {
            XMLConversionManager xcm = (XMLConversionManager)this.xmlUnmarshaller.getXMLContext().getSession(0).getDatasourcePlatform().getConversionManager();
            if (xcm.getDefaultJavaTypes().get(value.getClass()) != null) {
                return this.createJAXBElement(qname, declaredType, value);
            }
        }
        return this.createJAXBElement(qname, declaredType, value);
    }

    private JAXBElement createJAXBElement(QName qname, Class theClass, Object value) {
        if (theClass == null) {
            return new JAXBElement(qname, Object.class, value);
        }
        if (ClassConstants.XML_GREGORIAN_CALENDAR.isAssignableFrom(theClass)) {
            theClass = ClassConstants.XML_GREGORIAN_CALENDAR;
        } else if (ClassConstants.DURATION.isAssignableFrom(theClass)) {
            theClass = ClassConstants.DURATION;
        }
        return new JAXBElement(qname, theClass, value);
    }

    public JAXBContext getJaxbContext() {
        return this.jaxbContext;
    }

    public void setJaxbContext(JAXBContext jaxbContext) {
        this.jaxbContext = jaxbContext;
    }

    private Class getClassToUnmarshalTo(Class originalClass) {
        Class generatedClass;
        TypeMappingInfo tmi;
        Class generatedClass2;
        Class classToUnmarshalTo = originalClass;
        if (this.jaxbContext.getArrayClassesToGeneratedClasses() != null && this.jaxbContext.getArrayClassesToGeneratedClasses().size() > 0 && (generatedClass2 = this.jaxbContext.getArrayClassesToGeneratedClasses().get(originalClass.getCanonicalName())) != null) {
            classToUnmarshalTo = generatedClass2;
        }
        if (this.jaxbContext.getCollectionClassesToGeneratedClasses() != null && this.jaxbContext.getCollectionClassesToGeneratedClasses().size() > 0 && (generatedClass2 = this.jaxbContext.getCollectionClassesToGeneratedClasses().get(originalClass)) != null) {
            classToUnmarshalTo = generatedClass2;
        }
        if (this.jaxbContext.getTypeToTypeMappingInfo() != null && (tmi = this.jaxbContext.getTypeToTypeMappingInfo().get(originalClass)) != null && this.jaxbContext.getTypeMappingInfoToGeneratedType() != null && (generatedClass = this.jaxbContext.getTypeMappingInfoToGeneratedType().get(tmi)) != null) {
            classToUnmarshalTo = generatedClass;
        }
        return classToUnmarshalTo;
    }

    private JAXBException handleXMLMarshalException(XMLMarshalException xmlMarshalException) {
        if (xmlMarshalException.getErrorCode() == 25011) {
            throw new IllegalArgumentException(xmlMarshalException);
        }
        return new UnmarshalException((Throwable)xmlMarshalException);
    }

    public IDResolver getIDResolver() {
        return this.getXMLUnmarshaller().getIDResolver();
    }

    public void setIDResolver(IDResolver idResolver) {
        this.getXMLUnmarshaller().setIDResolver(idResolver);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PrimitiveContentHandler<T>
    extends DefaultHandler {
        private Class<T> clazz;
        private JAXBElement<T> jaxbElement;
        private Map<String, String> namespaces = new HashMap<String, String>(3);
        private StringBuilder stringBuilder = new StringBuilder();
        private String xsiType;
        private boolean xsiNil;

        public PrimitiveContentHandler(Class<T> clazz) {
            this.clazz = clazz;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.stringBuilder.append(ch, start, length);
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qualifiedName) throws SAXException {
            Object value;
            XMLConversionManager xcm = XMLConversionManager.getDefaultXMLManager();
            if (this.xsiNil) {
                value = null;
            } else if (null == this.xsiType) {
                value = this.clazz == ClassConstants.ABYTE || this.clazz == ClassConstants.APBYTE || this.clazz.getCanonicalName().equals("javax.activation.DataHandler") ? xcm.convertObject((Object)this.stringBuilder.toString(), this.clazz, XMLConstants.BASE_64_BINARY_QNAME) : xcm.convertObject((Object)this.stringBuilder.toString(), this.clazz);
            } else {
                String typeName;
                String typePrefix;
                int colonIndex = this.xsiType.indexOf(58);
                if (colonIndex == -1) {
                    typePrefix = "";
                    typeName = this.xsiType;
                } else {
                    typePrefix = this.xsiType.substring(0, colonIndex);
                    typeName = this.xsiType.substring(colonIndex + 1);
                }
                String typeNamespace = this.namespaces.get(typePrefix);
                QName typeQName = new QName(typeNamespace, typeName);
                value = xcm.convertObject((Object)this.stringBuilder.toString(), this.clazz, typeQName);
            }
            QName qName = namespaceURI != null && namespaceURI.length() == 0 ? new QName(qualifiedName) : new QName(namespaceURI, localName);
            this.jaxbElement = new JAXBElement(qName, this.clazz, value);
        }

        public JAXBElement<T> getJaxbElement() {
            return this.jaxbElement;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
            boolean bl = this.xsiNil = attributes.getValue("http://www.w3.org/2001/XMLSchema-instance", "nil") != null;
            if (!this.xsiNil) {
                this.xsiType = attributes.getValue("http://www.w3.org/2001/XMLSchema-instance", "type");
            }
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.namespaces.put(prefix, uri);
        }
    }
}

