/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Path;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.groups.Default;
import org.eclipse.persistence.exceptions.BeanValidationException;
import org.eclipse.persistence.jaxb.BeanValidationMode;
import org.eclipse.persistence.jaxb.xmlmodel.XmlBindings;

class JAXBBeanValidator {
    public static final Class<?>[] DEFAULT_GROUP_ARRAY = new Class[]{Default.class};
    private final String prefix;
    private Set<? extends ConstraintViolation<?>> constraintViolations = Collections.emptySet();
    private boolean shouldValidate;
    private Validator validator;
    private boolean stopSearchingForValidator;
    private BeanValidationMode beanValidationMode = BeanValidationMode.NONE;
    private ValidatorFactory preferredValidatorFactory;

    private JAXBBeanValidator(String prefix) {
        this.prefix = prefix;
    }

    static JAXBBeanValidator getMarshallingBeanValidator() {
        return new JAXBBeanValidator("");
    }

    static JAXBBeanValidator getUnmarshallingBeanValidator() {
        return new JAXBBeanValidator("un");
    }

    boolean shouldValidate(Object value, BeanValidationMode beanValidationMode, ValidatorFactory preferredValidatorFactory) throws BeanValidationException {
        if (value instanceof XmlBindings) {
            return false;
        }
        if (this.beanValidationMode != beanValidationMode) {
            this.beanValidationMode = beanValidationMode;
            this.preferredValidatorFactory = preferredValidatorFactory;
            this.changeInternalState();
        }
        return this.shouldValidate;
    }

    void validate(Object value, Class<?> ... groups) throws BeanValidationException {
        this.constraintViolations = this.validator.validate(value, (Class[])groups);
        if (!this.constraintViolations.isEmpty()) {
            throw this.buildConstraintViolationException();
        }
    }

    Set<? extends ConstraintViolation<?>> getConstraintViolations() {
        return this.constraintViolations;
    }

    private void changeInternalState() throws BeanValidationException {
        this.stopSearchingForValidator = false;
        switch (this.beanValidationMode) {
            case NONE: {
                this.shouldValidate = false;
                this.constraintViolations = Collections.emptySet();
                break;
            }
            case AUTO: 
            case CALLBACK: {
                this.shouldValidate = this.initValidator();
                break;
            }
            default: {
                throw BeanValidationException.illegalValidationMode((String)this.prefix, (String)this.beanValidationMode.toString());
            }
        }
    }

    private boolean initValidator() throws BeanValidationException {
        if (this.validator == null && !this.stopSearchingForValidator) {
            try {
                ValidatorFactory factory = this.getValidatorFactory();
                this.validator = factory.getValidator();
            }
            catch (ValidationException ve) {
                if (this.beanValidationMode == BeanValidationMode.CALLBACK) {
                    this.beanValidationMode = BeanValidationMode.AUTO;
                    throw BeanValidationException.providerNotFound((String)this.prefix, (Throwable)ve);
                }
                this.stopSearchingForValidator = true;
            }
        }
        return this.validator != null;
    }

    private ValidatorFactory getValidatorFactory() {
        return this.preferredValidatorFactory != null ? this.preferredValidatorFactory : Validation.buildDefaultValidatorFactory();
    }

    private BeanValidationException buildConstraintViolationException() throws BeanValidationException {
        ConstraintViolationException cve = new ConstraintViolationException(this.constraintViolations);
        return BeanValidationException.constraintViolation((Object[])this.createConstraintViolationExceptionArgs(), (Throwable)cve);
    }

    private Object[] createConstraintViolationExceptionArgs() {
        Object[] args = new Object[3];
        Iterator<ConstraintViolation<?>> iterator = this.constraintViolations.iterator();
        ConstraintViolation<?> cv = iterator.next();
        LinkedList<ConstraintViolationInfo> violatedConstraints = new LinkedList<ConstraintViolationInfo>(){

            @Override
            public String toString() {
                Iterator it = this.iterator();
                StringBuilder sb = new StringBuilder();
                while (it.hasNext()) {
                    sb.append("\n-->").append(((ConstraintViolationInfo)it.next()).toString());
                }
                return sb.toString();
            }
        };
        args[0] = this.prefix;
        Object bean = cv.getRootBean();
        args[1] = String.valueOf(bean.getClass().toString().substring("class ".length())) + "@" + Integer.toHexString(System.identityHashCode(bean));
        args[2] = violatedConstraints;
        while (true) {
            violatedConstraints.add(new ConstraintViolationInfo(cv.getMessage(), cv.getPropertyPath()));
            if (!iterator.hasNext()) break;
            cv = iterator.next();
        }
        return args;
    }

    private static class ConstraintViolationInfo {
        private final String violationDescription;
        private final Path propertyPath;

        private ConstraintViolationInfo(String message, Path propertyPath) {
            this.violationDescription = message;
            this.propertyPath = propertyPath;
        }

        public String toString() {
            return "Violated constraint on property " + this.propertyPath + ": \"" + this.violationDescription + "\".";
        }
    }
}

