/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.eclipse.persistence.core.mappings.CoreMapping;
import org.eclipse.persistence.core.mappings.converters.CoreConverter;
import org.eclipse.persistence.core.sessions.CoreSession;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.internal.jaxb.WrappedValue;
import org.eclipse.persistence.internal.oxm.Root;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.sessions.Session;

public class JAXBElementConverter
implements XMLConverter {
    private XPathFragment rootFragment;
    private Field associatedField;
    private CoreMapping mapping;
    private CoreConverter nestedConverter;
    private Class declaredType;
    private Class scope;

    public JAXBElementConverter(Field associatedField, Class declaredType, Class scope) {
        this.associatedField = associatedField;
        this.declaredType = declaredType;
        this.scope = scope;
    }

    public CoreConverter getNestedConverter() {
        return this.nestedConverter;
    }

    public void setNestedConverter(CoreConverter nestedConverter) {
        this.nestedConverter = nestedConverter;
    }

    public Object convertDataValueToObjectValue(Object dataValue, Session session, XMLUnmarshaller unmarshaller) {
        return this.convertDataValueToObjectValue(dataValue, session);
    }

    public Object convertObjectValueToDataValue(Object objectValue, Session session, XMLMarshaller marshaller) {
        return this.convertObjectValueToDataValue(objectValue, session);
    }

    public Object convertDataValueToObjectValue(Object dataValue, Session session) {
        QName name = new QName(this.rootFragment.getNamespaceURI(), this.rootFragment.getLocalName());
        if (this.mapping.isAbstractDirectMapping() && this.nestedConverter == null && (dataValue == null || dataValue.getClass() != this.mapping.getAttributeClassification())) {
            try {
                dataValue = session.getDatasourcePlatform().convertObject(dataValue, this.mapping.getAttributeClassification());
            }
            catch (ConversionException e) {
                throw ConversionException.couldNotBeConverted((Object)this, (Object)this.mapping.getDescriptor(), (ConversionException)e);
            }
        }
        if (this.nestedConverter != null) {
            dataValue = this.nestedConverter.convertDataValueToObjectValue(dataValue, (CoreSession)session);
        }
        if (dataValue instanceof JAXBElement) {
            return dataValue;
        }
        if (this.declaredType == null) {
            return new JAXBElement(name, Object.class, this.scope, dataValue);
        }
        return new JAXBElement(name, this.declaredType, this.scope, dataValue);
    }

    public Object convertObjectValueToDataValue(Object objectValue, Session session) {
        if (objectValue instanceof JAXBElement) {
            ClassDescriptor desc = session.getDescriptor(objectValue);
            if (desc == null || objectValue instanceof WrappedValue) {
                objectValue = ((JAXBElement)objectValue).getValue();
            }
        } else if (objectValue instanceof Root) {
            objectValue = ((Root)objectValue).getObject();
        }
        if (this.nestedConverter != null) {
            objectValue = this.nestedConverter.convertObjectValueToDataValue(objectValue, (CoreSession)session);
        }
        return objectValue;
    }

    public void initialize(DatabaseMapping mapping, Session session) {
        if (this.nestedConverter != null) {
            this.nestedConverter.initialize((CoreMapping)mapping, (CoreSession)session);
        }
        XPathFragment fragment = this.associatedField.getXPathFragment();
        while (fragment.getNextFragment() != null && !fragment.getNextFragment().nameIsText()) {
            fragment = fragment.getNextFragment();
        }
        if (fragment.hasNamespace() && this.associatedField.getNamespaceResolver() != null) {
            String uri = this.associatedField.getNamespaceResolver().resolveNamespacePrefix(fragment.getPrefix());
            fragment.setNamespaceURI(uri);
        }
        this.rootFragment = fragment;
        this.mapping = mapping;
    }

    public boolean isMutable() {
        return false;
    }
}

