/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.rdf4j.common.io.GZipUtil;
import org.eclipse.rdf4j.common.io.UncloseableInputStream;
import org.eclipse.rdf4j.common.io.ZipUtil;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.RDFParserRegistry;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.UnsupportedRDFormatException;
import org.eclipse.rdf4j.rio.helpers.ParseErrorLogger;

public class RDFLoader {
    private final ParserConfig config;
    private final ValueFactory vf;

    public RDFLoader(ParserConfig config, ValueFactory vf) {
        this.config = config;
        this.vf = vf;
    }

    public void load(File file, String baseURI, RDFFormat dataFormat, RDFHandler rdfHandler) throws IOException, RDFParseException, RDFHandlerException {
        if (baseURI == null) {
            baseURI = file.toURI().toString();
        }
        if (dataFormat == null) {
            dataFormat = Rio.getParserFormatForFileName(file.getName()).orElseThrow(() -> new UnsupportedRDFormatException("Could not find RDF format for file: " + file.getName()));
        }
        try (FileInputStream in = new FileInputStream(file);){
            this.load(in, baseURI, dataFormat, rdfHandler);
        }
    }

    public void load(URL url, String baseURI, RDFFormat dataFormat, RDFHandler rdfHandler) throws IOException, RDFParseException, RDFHandlerException {
        if (baseURI == null) {
            baseURI = url.toExternalForm();
        }
        URLConnection con = url.openConnection();
        if (dataFormat != null) {
            for (String mimeType : dataFormat.getMIMETypes()) {
                con.addRequestProperty("Accept", mimeType);
            }
        } else {
            Set<RDFFormat> rdfFormats = RDFParserRegistry.getInstance().getKeys();
            List<String> acceptParams = RDFFormat.getAcceptParams(rdfFormats, true, null);
            for (String acceptParam : acceptParams) {
                con.addRequestProperty("Accept", acceptParam);
            }
        }
        try (InputStream in = con.getInputStream();){
            if (dataFormat == null) {
                String mimeType = con.getContentType();
                int semiColonIdx = mimeType.indexOf(59);
                if (semiColonIdx >= 0) {
                    mimeType = mimeType.substring(0, semiColonIdx);
                }
                dataFormat = Rio.getParserFormatForMIMEType(mimeType).orElseGet(() -> Rio.getParserFormatForFileName(url.getPath()).orElseThrow(() -> new UnsupportedRDFormatException("Could not find RDF format for URL: " + url.getPath())));
            }
            this.load(in, baseURI, dataFormat, rdfHandler);
        }
    }

    public void load(InputStream in, String baseURI, RDFFormat dataFormat, RDFHandler rdfHandler) throws IOException, RDFParseException, RDFHandlerException {
        if (!in.markSupported()) {
            in = new BufferedInputStream(in, 1024);
        }
        if (ZipUtil.isZipStream(in)) {
            this.loadZip(in, baseURI, dataFormat, rdfHandler);
        } else if (GZipUtil.isGZipStream(in)) {
            this.load(new GZIPInputStream(in), baseURI, dataFormat, rdfHandler);
        } else {
            this.loadInputStreamOrReader(in, baseURI, dataFormat, rdfHandler);
        }
    }

    public void load(Reader reader, String baseURI, RDFFormat dataFormat, RDFHandler rdfHandler) throws IOException, RDFParseException, RDFHandlerException {
        this.loadInputStreamOrReader(reader, baseURI, dataFormat, rdfHandler);
    }

    private void loadZip(InputStream in, String baseURI, RDFFormat dataFormat, RDFHandler rdfHandler) throws IOException, RDFParseException, RDFHandlerException {
        try (ZipInputStream zipIn = new ZipInputStream(in);){
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory()) {
                    try {
                        RDFFormat format = Rio.getParserFormatForFileName(entry.getName()).orElse(dataFormat);
                        UncloseableInputStream wrapper = new UncloseableInputStream(zipIn);
                        this.load(wrapper, baseURI, format, rdfHandler);
                    }
                    catch (RDFParseException e) {
                        String msg = e.getMessage() + " in " + entry.getName();
                        RDFParseException pe = new RDFParseException(msg, e.getLineNumber(), e.getColumnNumber());
                        pe.initCause(e);
                        throw pe;
                    }
                    finally {
                        zipIn.closeEntry();
                    }
                }
                entry = zipIn.getNextEntry();
            }
        }
    }

    private void loadInputStreamOrReader(Object inputStreamOrReader, String baseURI, RDFFormat dataFormat, RDFHandler rdfHandler) throws IOException, RDFParseException, RDFHandlerException {
        RDFParser rdfParser = Rio.createParser(dataFormat, this.vf);
        rdfParser.setParserConfig(this.config);
        rdfParser.setParseErrorListener(new ParseErrorLogger());
        rdfParser.setRDFHandler(rdfHandler);
        if (inputStreamOrReader instanceof InputStream) {
            rdfParser.parse((InputStream)inputStreamOrReader, baseURI);
        } else if (inputStreamOrReader instanceof Reader) {
            rdfParser.parse((Reader)inputStreamOrReader, baseURI);
        } else {
            throw new IllegalArgumentException("Must be an InputStream or a Reader, is a: " + inputStreamOrReader.getClass());
        }
    }
}

