/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.helpers;

import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;
import org.eclipse.rdf4j.common.net.ParsedIRI;
import org.eclipse.rdf4j.common.net.ParsedURI;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.rio.ParseErrorListener;
import org.eclipse.rdf4j.rio.ParseLocationListener;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.eclipse.rdf4j.rio.helpers.NTriplesParserSettings;
import org.eclipse.rdf4j.rio.helpers.RDFParserHelper;

public abstract class AbstractRDFParser
implements RDFParser {
    private final MessageDigest md5;
    protected RDFHandler rdfHandler;
    private ParseErrorListener errListener;
    private ParseLocationListener locationListener;
    protected ValueFactory valueFactory;
    private ParsedIRI baseURI;
    private String nextBNodePrefix;
    private Map<String, String> namespaceTable;
    private ParserConfig parserConfig;

    protected AbstractRDFParser() {
        this(SimpleValueFactory.getInstance());
    }

    protected AbstractRDFParser(ValueFactory valueFactory) {
        try {
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        this.namespaceTable = new HashMap<String, String>(16);
        this.nextBNodePrefix = this.createUniqueBNodePrefix();
        this.setValueFactory(valueFactory);
        this.setParserConfig(new ParserConfig());
    }

    @Override
    public RDFParser setValueFactory(ValueFactory valueFactory) {
        this.valueFactory = valueFactory;
        return this;
    }

    @Override
    public RDFParser setRDFHandler(RDFHandler handler) {
        this.rdfHandler = handler;
        return this;
    }

    public RDFHandler getRDFHandler() {
        return this.rdfHandler;
    }

    @Override
    public RDFParser setParseErrorListener(ParseErrorListener el) {
        this.errListener = el;
        return this;
    }

    public ParseErrorListener getParseErrorListener() {
        return this.errListener;
    }

    @Override
    public RDFParser setParseLocationListener(ParseLocationListener el) {
        this.locationListener = el;
        return this;
    }

    public ParseLocationListener getParseLocationListener() {
        return this.locationListener;
    }

    @Override
    public RDFParser setParserConfig(ParserConfig config) {
        this.parserConfig = config;
        this.initializeNamespaceTableFromConfiguration();
        return this;
    }

    @Override
    public ParserConfig getParserConfig() {
        return this.parserConfig;
    }

    @Override
    public Collection<RioSetting<?>> getSupportedSettings() {
        HashSet result = new HashSet();
        result.add(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES);
        result.add(BasicParserSettings.VERIFY_DATATYPE_VALUES);
        result.add(BasicParserSettings.NORMALIZE_DATATYPE_VALUES);
        result.add(BasicParserSettings.DATATYPE_HANDLERS);
        result.add(BasicParserSettings.FAIL_ON_UNKNOWN_LANGUAGES);
        result.add(BasicParserSettings.VERIFY_LANGUAGE_TAGS);
        result.add(BasicParserSettings.NORMALIZE_LANGUAGE_TAGS);
        result.add(BasicParserSettings.LANGUAGE_HANDLERS);
        result.add(BasicParserSettings.VERIFY_RELATIVE_URIS);
        result.add(BasicParserSettings.VERIFY_URI_SYNTAX);
        result.add(BasicParserSettings.PRESERVE_BNODE_IDS);
        result.add(BasicParserSettings.NAMESPACES);
        return result;
    }

    @Override
    public <T> RDFParser set(RioSetting<T> setting, T value) {
        this.getParserConfig().set((RioSetting)setting, (Object)value);
        return this;
    }

    @Override
    public void setVerifyData(boolean verifyData) {
        this.parserConfig.set((RioSetting)BasicParserSettings.VERIFY_RELATIVE_URIS, (Object)verifyData);
    }

    @Deprecated
    public boolean verifyData() {
        return this.parserConfig.verifyData();
    }

    @Override
    public void setPreserveBNodeIDs(boolean preserveBNodeIDs) {
        this.parserConfig.set((RioSetting)BasicParserSettings.PRESERVE_BNODE_IDS, (Object)preserveBNodeIDs);
    }

    public boolean preserveBNodeIDs() {
        return this.parserConfig.get(BasicParserSettings.PRESERVE_BNODE_IDS);
    }

    @Override
    @Deprecated
    public void setStopAtFirstError(boolean stopAtFirstError) {
        this.getParserConfig().set((RioSetting)NTriplesParserSettings.FAIL_ON_NTRIPLES_INVALID_LINES, (Object)stopAtFirstError);
        if (!stopAtFirstError) {
            this.getParserConfig().addNonFatalError(NTriplesParserSettings.FAIL_ON_NTRIPLES_INVALID_LINES);
        } else {
            HashSet set = new HashSet(this.getParserConfig().getNonFatalErrors());
            set.remove(NTriplesParserSettings.FAIL_ON_NTRIPLES_INVALID_LINES);
            this.getParserConfig().setNonFatalErrors(set);
        }
    }

    @Deprecated
    public boolean stopAtFirstError() {
        return this.parserConfig.stopAtFirstError();
    }

    @Override
    public void setDatatypeHandling(RDFParser.DatatypeHandling datatypeHandling) {
        if (datatypeHandling == RDFParser.DatatypeHandling.VERIFY) {
            this.parserConfig.set((RioSetting)BasicParserSettings.VERIFY_DATATYPE_VALUES, (Object)true);
            this.parserConfig.set((RioSetting)BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, (Object)true);
        } else if (datatypeHandling == RDFParser.DatatypeHandling.NORMALIZE) {
            this.parserConfig.set((RioSetting)BasicParserSettings.VERIFY_DATATYPE_VALUES, (Object)true);
            this.parserConfig.set((RioSetting)BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, (Object)true);
            this.parserConfig.set((RioSetting)BasicParserSettings.NORMALIZE_DATATYPE_VALUES, (Object)true);
        } else if (!(this.parserConfig.isSet(BasicParserSettings.NORMALIZE_DATATYPE_VALUES) || this.parserConfig.isSet(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES) || this.parserConfig.isSet(BasicParserSettings.NORMALIZE_DATATYPE_VALUES))) {
            this.parserConfig.set((RioSetting)BasicParserSettings.VERIFY_DATATYPE_VALUES, (Object)false);
            this.parserConfig.set((RioSetting)BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, (Object)false);
            this.parserConfig.set((RioSetting)BasicParserSettings.NORMALIZE_DATATYPE_VALUES, (Object)false);
        }
    }

    @Deprecated
    public RDFParser.DatatypeHandling datatypeHandling() {
        return this.parserConfig.datatypeHandling();
    }

    protected void setBaseURI(String uriSpec) {
        if (this.baseURI == null || !this.baseURI.toString().equals(uriSpec)) {
            this.baseURI = ParsedIRI.create(uriSpec);
        }
    }

    protected void setBaseURI(ParsedURI baseURI) {
        this.setBaseURI(baseURI.toString());
    }

    protected void setNamespace(String prefix, String namespace) {
        this.namespaceTable.put(prefix, namespace);
    }

    protected String getNamespace(String prefix) throws RDFParseException {
        if (this.namespaceTable.containsKey(prefix)) {
            return this.namespaceTable.get(prefix);
        }
        String msg = "Namespace prefix '" + prefix + "' used but not defined";
        if ("".equals(prefix)) {
            msg = "Default namespace used but not defined";
        }
        this.reportFatalError(msg);
        throw new RDFParseException(msg);
    }

    protected void clear() {
        this.baseURI = null;
        this.nextBNodePrefix = this.createUniqueBNodePrefix();
        this.namespaceTable.clear();
        this.initializeNamespaceTableFromConfiguration();
    }

    protected void initializeNamespaceTableFromConfiguration() {
        for (Namespace aNS : this.getParserConfig().get(BasicParserSettings.NAMESPACES)) {
            this.namespaceTable.put(aNS.getPrefix(), aNS.getName());
        }
    }

    @Deprecated
    protected void clearBNodeIDMap() {
        this.clear();
    }

    protected IRI resolveURI(String uriSpec) throws RDFParseException {
        if (uriSpec.indexOf(58) < 0) {
            if (this.baseURI == null) {
                this.reportFatalError("Unable to resolve URIs, no base URI has been set");
            }
            if (this.getParserConfig().get(BasicParserSettings.VERIFY_RELATIVE_URIS).booleanValue() && uriSpec.length() > 0 && !uriSpec.startsWith("#") && this.baseURI.isOpaque()) {
                this.reportError("Relative URI '" + uriSpec + "' cannot be resolved using the opaque base URI '" + this.baseURI + "'", BasicParserSettings.VERIFY_RELATIVE_URIS);
            }
            return this.createURI(this.baseURI.resolve(uriSpec));
        }
        return this.createURI(uriSpec);
    }

    protected IRI createURI(String uri) throws RDFParseException {
        if (this.getParserConfig().get(BasicParserSettings.VERIFY_URI_SYNTAX).booleanValue()) {
            try {
                new ParsedIRI(uri);
            }
            catch (URISyntaxException e) {
                this.reportError(e.getMessage(), BasicParserSettings.VERIFY_URI_SYNTAX);
                return null;
            }
        }
        try {
            return this.valueFactory.createIRI(uri);
        }
        catch (Exception e) {
            this.reportFatalError(e);
            return null;
        }
    }

    protected Resource createNode() throws RDFParseException {
        try {
            String origin = this.parserConfig.get(BasicParserSettings.SKOLEMIZE_ORIGIN);
            if (this.preserveBNodeIDs() || origin == null || origin.length() == 0) {
                return this.valueFactory.createBNode();
            }
            String nodeId = this.valueFactory.createBNode().getID();
            String path = "/.well-known/genid/" + this.nextBNodePrefix + nodeId;
            String iri = ParsedIRI.create(origin).resolve(path);
            return this.valueFactory.createIRI(iri);
        }
        catch (Exception e) {
            this.reportFatalError(e);
            return null;
        }
    }

    protected Resource createNode(String nodeID) throws RDFParseException {
        String origin;
        if (this.preserveBNodeIDs()) {
            return this.valueFactory.createBNode(nodeID);
        }
        String toAppend = nodeID;
        if (nodeID.length() > 32) {
            byte[] chars = nodeID.getBytes(StandardCharsets.UTF_8);
            toAppend = new HexBinaryAdapter().marshal(this.md5.digest(chars));
        }
        if ((origin = this.parserConfig.get(BasicParserSettings.SKOLEMIZE_ORIGIN)) == null || origin.length() == 0) {
            return this.valueFactory.createBNode("genid-" + this.nextBNodePrefix + toAppend);
        }
        String path = "/.well-known/genid/" + this.nextBNodePrefix + toAppend;
        String iri = ParsedIRI.create(origin).resolve(path);
        return this.valueFactory.createIRI(iri);
    }

    @Deprecated
    protected BNode createBNode() throws RDFParseException {
        try {
            return this.valueFactory.createBNode();
        }
        catch (Exception e) {
            this.reportFatalError(e);
            return null;
        }
    }

    @Deprecated
    protected BNode createBNode(String nodeID) throws RDFParseException {
        if (this.preserveBNodeIDs()) {
            return this.valueFactory.createBNode(nodeID);
        }
        String toAppend = nodeID;
        if (nodeID.length() > 32) {
            byte[] chars = nodeID.getBytes(StandardCharsets.UTF_8);
            toAppend = new HexBinaryAdapter().marshal(this.md5.digest(chars));
        }
        return this.valueFactory.createBNode("genid-" + this.nextBNodePrefix + toAppend);
    }

    protected Literal createLiteral(String label, String lang, IRI datatype) throws RDFParseException {
        return RDFParserHelper.createLiteral(label, lang, datatype, this.getParserConfig(), this.getParseErrorListener(), this.valueFactory);
    }

    protected Literal createLiteral(String label, String lang, IRI datatype, long lineNo, long columnNo) throws RDFParseException {
        return RDFParserHelper.createLiteral(label, lang, datatype, this.getParserConfig(), this.getParseErrorListener(), this.valueFactory, lineNo, columnNo);
    }

    protected Statement createStatement(Resource subj, IRI pred, Value obj) throws RDFParseException {
        try {
            return this.valueFactory.createStatement(subj, pred, obj);
        }
        catch (Exception e) {
            this.reportFatalError(e);
            return null;
        }
    }

    protected Statement createStatement(Resource subj, IRI pred, Value obj, Resource context) throws RDFParseException {
        try {
            return this.valueFactory.createStatement(subj, pred, obj, context);
        }
        catch (Exception e) {
            this.reportFatalError(e);
            return null;
        }
    }

    protected void reportLocation(long lineNo, long columnNo) {
        if (this.locationListener != null) {
            this.locationListener.parseLocationUpdate(lineNo, columnNo);
        }
    }

    protected void reportWarning(String msg) {
        this.reportWarning(msg, -1L, -1L);
    }

    protected void reportWarning(String msg, long lineNo, long columnNo) {
        if (this.errListener != null) {
            this.errListener.warning(msg, lineNo, columnNo);
        }
    }

    protected void reportError(String msg, RioSetting<Boolean> relevantSetting) throws RDFParseException {
        RDFParserHelper.reportError(msg, relevantSetting, this.getParserConfig(), this.getParseErrorListener());
    }

    protected void reportError(String msg, long lineNo, long columnNo, RioSetting<Boolean> relevantSetting) throws RDFParseException {
        RDFParserHelper.reportError(msg, lineNo, columnNo, relevantSetting, this.getParserConfig(), this.getParseErrorListener());
    }

    protected void reportError(Exception e, RioSetting<Boolean> relevantSetting) throws RDFParseException {
        RDFParserHelper.reportError(e, -1L, -1L, relevantSetting, this.getParserConfig(), this.getParseErrorListener());
    }

    protected void reportError(Exception e, long lineNo, long columnNo, RioSetting<Boolean> relevantSetting) throws RDFParseException {
        RDFParserHelper.reportError(e, lineNo, columnNo, relevantSetting, this.getParserConfig(), this.getParseErrorListener());
    }

    protected void reportError(String msg, Exception e, long lineNo, long columnNo, RioSetting<Boolean> relevantSetting) throws RDFParseException {
        RDFParserHelper.reportError(e, lineNo, columnNo, relevantSetting, this.getParserConfig(), this.getParseErrorListener());
    }

    protected void reportFatalError(String msg) throws RDFParseException {
        RDFParserHelper.reportFatalError(msg, this.getParseErrorListener());
    }

    protected void reportFatalError(String msg, long lineNo, long columnNo) throws RDFParseException {
        RDFParserHelper.reportFatalError(msg, lineNo, columnNo, this.getParseErrorListener());
    }

    protected void reportFatalError(Exception e) throws RDFParseException {
        RDFParserHelper.reportFatalError(e, this.getParseErrorListener());
    }

    protected void reportFatalError(Exception e, long lineNo, long columnNo) throws RDFParseException {
        RDFParserHelper.reportFatalError(e, lineNo, columnNo, this.getParseErrorListener());
    }

    protected void reportFatalError(String message, Exception e, long lineNo, long columnNo) throws RDFParseException {
        RDFParserHelper.reportFatalError(message, e, lineNo, columnNo, this.getParseErrorListener());
    }

    private final String createUniqueBNodePrefix() {
        return UUID.randomUUID().toString().replaceAll("-", "") + "-";
    }
}

