/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.jsonld;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.core.JsonLdTripleCallback;
import com.github.jsonldjava.utils.JsonUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFParser;
import org.eclipse.rdf4j.rio.helpers.JSONSettings;
import org.eclipse.rdf4j.rio.jsonld.JSONLDInternalTripleCallback;

public class JSONLDParser
extends AbstractRDFParser
implements RDFParser {
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();

    public JSONLDParser() {
    }

    public JSONLDParser(ValueFactory valueFactory) {
        super(valueFactory);
    }

    @Override
    public RDFFormat getRDFFormat() {
        return RDFFormat.JSONLD;
    }

    @Override
    public Collection<RioSetting<?>> getSupportedSettings() {
        Collection<RioSetting<?>> result = super.getSupportedSettings();
        result.add(JSONSettings.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER);
        result.add(JSONSettings.ALLOW_COMMENTS);
        result.add(JSONSettings.ALLOW_NON_NUMERIC_NUMBERS);
        result.add(JSONSettings.ALLOW_NUMERIC_LEADING_ZEROS);
        result.add(JSONSettings.ALLOW_SINGLE_QUOTES);
        result.add(JSONSettings.ALLOW_UNQUOTED_CONTROL_CHARS);
        result.add(JSONSettings.ALLOW_UNQUOTED_FIELD_NAMES);
        result.add(JSONSettings.ALLOW_YAML_COMMENTS);
        result.add(JSONSettings.ALLOW_TRAILING_COMMA);
        result.add(JSONSettings.INCLUDE_SOURCE_IN_LOCATION);
        result.add(JSONSettings.STRICT_DUPLICATE_DETECTION);
        return result;
    }

    @Override
    public void parse(InputStream in, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        this.clear();
        try {
            JSONLDInternalTripleCallback callback = new JSONLDInternalTripleCallback(this.getRDFHandler(), this.valueFactory, this.getParserConfig(), this.getParseErrorListener(), nodeID -> this.createNode((String)nodeID), () -> this.createNode());
            JsonLdOptions options = new JsonLdOptions(baseURI);
            options.useNamespaces = true;
            JsonFactory nextJsonFactory = this.configureNewJsonFactory();
            JsonParser nextParser = nextJsonFactory.createParser(in);
            Object parsedJson = JsonUtils.fromJsonParser((JsonParser)nextParser);
            JsonLdProcessor.toRDF((Object)parsedJson, (JsonLdTripleCallback)callback, (JsonLdOptions)options);
        }
        catch (JsonLdError e) {
            throw new RDFParseException("Could not parse JSONLD", e);
        }
        catch (JsonProcessingException e) {
            throw new RDFParseException("Could not parse JSONLD", (Throwable)e, e.getLocation().getLineNr(), e.getLocation().getColumnNr());
        }
        catch (RuntimeException e) {
            if (e.getCause() != null && e.getCause() instanceof RDFParseException) {
                throw (RDFParseException)e.getCause();
            }
            throw e;
        }
        finally {
            this.clear();
        }
    }

    @Override
    public void parse(Reader reader, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        this.clear();
        try {
            JSONLDInternalTripleCallback callback = new JSONLDInternalTripleCallback(this.getRDFHandler(), this.valueFactory, this.getParserConfig(), this.getParseErrorListener(), nodeID -> this.createNode((String)nodeID), () -> this.createNode());
            JsonLdOptions options = new JsonLdOptions(baseURI);
            options.useNamespaces = true;
            JsonFactory nextJsonFactory = this.configureNewJsonFactory();
            JsonParser nextParser = nextJsonFactory.createParser(reader);
            Object parsedJson = JsonUtils.fromJsonParser((JsonParser)nextParser);
            JsonLdProcessor.toRDF((Object)parsedJson, (JsonLdTripleCallback)callback, (JsonLdOptions)options);
        }
        catch (JsonLdError e) {
            throw new RDFParseException("Could not parse JSONLD", e);
        }
        catch (JsonProcessingException e) {
            throw new RDFParseException("Could not parse JSONLD", (Throwable)e, e.getLocation().getLineNr(), e.getLocation().getColumnNr());
        }
        catch (RuntimeException e) {
            if (e.getCause() != null && e.getCause() instanceof RDFParseException) {
                throw (RDFParseException)e.getCause();
            }
            throw e;
        }
        finally {
            this.clear();
        }
    }

    private JsonFactory configureNewJsonFactory() {
        JsonFactory nextJsonFactory = new JsonFactory((ObjectCodec)JSON_MAPPER);
        if (this.getParserConfig().isSet(JSONSettings.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER)) {
            nextJsonFactory.configure(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, this.getParserConfig().get(JSONSettings.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER).booleanValue());
        }
        if (this.getParserConfig().isSet(JSONSettings.ALLOW_COMMENTS)) {
            nextJsonFactory.configure(JsonParser.Feature.ALLOW_COMMENTS, this.getParserConfig().get(JSONSettings.ALLOW_COMMENTS).booleanValue());
        }
        if (this.getParserConfig().isSet(JSONSettings.ALLOW_NON_NUMERIC_NUMBERS)) {
            nextJsonFactory.configure(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS, this.getParserConfig().get(JSONSettings.ALLOW_NON_NUMERIC_NUMBERS).booleanValue());
        }
        if (this.getParserConfig().isSet(JSONSettings.ALLOW_NUMERIC_LEADING_ZEROS)) {
            nextJsonFactory.configure(JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS, this.getParserConfig().get(JSONSettings.ALLOW_NUMERIC_LEADING_ZEROS).booleanValue());
        }
        if (this.getParserConfig().isSet(JSONSettings.ALLOW_SINGLE_QUOTES)) {
            nextJsonFactory.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, this.getParserConfig().get(JSONSettings.ALLOW_SINGLE_QUOTES).booleanValue());
        }
        if (this.getParserConfig().isSet(JSONSettings.ALLOW_UNQUOTED_CONTROL_CHARS)) {
            nextJsonFactory.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, this.getParserConfig().get(JSONSettings.ALLOW_UNQUOTED_CONTROL_CHARS).booleanValue());
        }
        if (this.getParserConfig().isSet(JSONSettings.ALLOW_UNQUOTED_FIELD_NAMES)) {
            nextJsonFactory.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, this.getParserConfig().get(JSONSettings.ALLOW_UNQUOTED_FIELD_NAMES).booleanValue());
        }
        if (this.getParserConfig().isSet(JSONSettings.ALLOW_YAML_COMMENTS)) {
            nextJsonFactory.configure(JsonParser.Feature.ALLOW_YAML_COMMENTS, this.getParserConfig().get(JSONSettings.ALLOW_YAML_COMMENTS).booleanValue());
        }
        if (this.getParserConfig().isSet(JSONSettings.ALLOW_TRAILING_COMMA)) {
            nextJsonFactory.configure(JsonParser.Feature.ALLOW_TRAILING_COMMA, this.getParserConfig().get(JSONSettings.ALLOW_TRAILING_COMMA).booleanValue());
        }
        if (this.getParserConfig().isSet(JSONSettings.INCLUDE_SOURCE_IN_LOCATION)) {
            nextJsonFactory.configure(JsonParser.Feature.INCLUDE_SOURCE_IN_LOCATION, this.getParserConfig().get(JSONSettings.INCLUDE_SOURCE_IN_LOCATION).booleanValue());
        }
        if (this.getParserConfig().isSet(JSONSettings.STRICT_DUPLICATE_DETECTION)) {
            nextJsonFactory.configure(JsonParser.Feature.STRICT_DUPLICATE_DETECTION, this.getParserConfig().get(JSONSettings.STRICT_DUPLICATE_DETECTION).booleanValue());
        }
        return nextJsonFactory;
    }
}

