/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console.command;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.ConsoleState;
import org.eclipse.rdf4j.console.Util;
import org.eclipse.rdf4j.console.command.ConsoleCommand;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.UnsupportedRDFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Export
extends ConsoleCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(Export.class);

    @Override
    public String getName() {
        return "export";
    }

    @Override
    public String getHelpShort() {
        return "Exports repository data to a file";
    }

    @Override
    public String getHelpLong() {
        return "Usage:\nexport <file>                 Exports the entirey repository to a file\nexport <file> (<uri>|null)... Exports the specified context(s) to a file\n";
    }

    @Override
    public void execute(String ... tokens) {
        Resource[] contexts;
        Repository repository = this.state.getRepository();
        if (repository == null) {
            this.consoleIO.writeUnopenedError();
            return;
        }
        if (tokens.length < 2) {
            this.consoleIO.writeln(this.getHelpLong());
            return;
        }
        String fileName = tokens[1];
        try {
            contexts = Util.getContexts(tokens, 2, repository);
        }
        catch (IllegalArgumentException ioe) {
            this.consoleIO.writeError(ioe.getMessage());
            return;
        }
        this.export(repository, fileName, contexts);
    }

    private void export(Repository repository, String fileName, Resource ... contexts) {
        Path path = Util.getPath(fileName);
        if (path == null) {
            this.consoleIO.writeError("Invalid file name");
            return;
        }
        if (path.toFile().exists()) {
            try {
                boolean overwrite = this.consoleIO.askProceed("File exists, continue ?", false);
                if (!overwrite) {
                    this.consoleIO.writeln("Export aborted");
                    return;
                }
            }
            catch (IOException ioe) {
                this.consoleIO.writeError("I/O error " + ioe.getMessage());
            }
        }
        try (RepositoryConnection conn = repository.getConnection();
             BufferedWriter w = Files.newBufferedWriter(path, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            RDFFormat fmt = (RDFFormat)Rio.getWriterFormatForFileName((String)fileName).orElseThrow(() -> new UnsupportedRDFormatException("No RDF parser for " + fileName));
            RDFWriter writer = Rio.createWriter((RDFFormat)fmt, (Writer)w);
            long startTime = System.nanoTime();
            this.consoleIO.writeln("Exporting data...");
            conn.export((RDFHandler)writer, contexts);
            long diff = (System.nanoTime() - startTime) / 1000000L;
            this.consoleIO.writeln("Data has been written to file (" + diff + " ms)");
        }
        catch (IOException | UnsupportedRDFormatException e) {
            this.consoleIO.writeError("Failed to export data: " + e.getMessage());
        }
    }

    public Export(ConsoleIO consoleIO, ConsoleState state) {
        super(consoleIO, state);
    }
}

