/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.Util;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.QueryResultHandlerException;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFWriter;

public class ConsoleRDFWriter
extends AbstractRDFWriter {
    private final ConsoleIO consoleIO;
    private final int consoleWidth;
    private final Map<String, String> namespaces = new HashMap<String, String>();
    private int columnWidth;
    private String separatorLine = "";
    private String header = "";

    public ConsoleRDFWriter(ConsoleIO consoleIO, int consoleWidth) {
        this.consoleIO = consoleIO;
        this.consoleWidth = consoleWidth;
    }

    public void handleNamespace(String prefix, String uri) throws QueryResultHandlerException {
        this.namespaces.put(uri, prefix);
    }

    public RDFFormat getRDFFormat() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void startRDF() throws RDFHandlerException {
    }

    public void endRDF() throws RDFHandlerException {
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        this.consoleIO.write(Util.getPrefixedValue((Value)st.getSubject(), this.namespaces));
        this.consoleIO.write("   ");
        this.consoleIO.write(Util.getPrefixedValue((Value)st.getPredicate(), this.namespaces));
        this.consoleIO.write("   ");
        this.consoleIO.write(Util.getPrefixedValue(st.getObject(), this.namespaces));
        this.consoleIO.writeln();
    }

    public void handleComment(String comment) throws RDFHandlerException {
    }
}

