/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model;

import java.util.Objects;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.junit.Test;

public abstract class StatementTest {
    protected abstract Statement statement(Resource var1, IRI var2, Value var3, Resource var4);

    protected abstract IRI iri(String var1);

    @Test
    public final void testConstructor() {
        IRI subject = this.iri("http://example.org/subject");
        IRI predicate = this.iri("http://example.org/predicate");
        IRI object = this.iri("http://example.org/object");
        IRI context = this.iri("http://example.org/context");
        Statement statement = this.statement((Resource)subject, predicate, (Value)object, (Resource)context);
        Assertions.assertThat((Object)statement.getSubject()).isEqualTo((Object)subject);
        Assertions.assertThat((Object)statement.getPredicate()).isEqualTo((Object)predicate);
        Assertions.assertThat((Object)statement.getObject()).isEqualTo((Object)object);
        Assertions.assertThat((Object)statement.getContext()).isEqualTo((Object)context);
        Assertions.assertThatNullPointerException().isThrownBy(() -> this.lambda$testConstructor$0(predicate, (Value)object, (Resource)context));
        Assertions.assertThatNullPointerException().isThrownBy(() -> this.lambda$testConstructor$1((Resource)subject, (Value)object, (Resource)context));
        Assertions.assertThatNullPointerException().isThrownBy(() -> this.lambda$testConstructor$2((Resource)subject, predicate, (Resource)context));
        Assertions.assertThat((Object)this.statement((Resource)subject, predicate, (Value)object, null)).as("accept null context", new Object[0]);
    }

    @Test
    public void testEquals() {
        IRI subject = this.iri("http://example.org/subject");
        IRI predicate = this.iri("http://example.org/predicate");
        IRI object = this.iri("http://example.org/object");
        IRI context = this.iri("http://example.org/context");
        Statement statement = this.statement((Resource)subject, predicate, (Value)object, (Resource)context);
        Assertions.assertThat((Object)statement).isEqualTo((Object)statement);
        Assertions.assertThat((Object)statement).isEqualTo((Object)this.statement(statement.getSubject(), statement.getPredicate(), statement.getObject(), statement.getContext()));
        Assertions.assertThat((Object)statement).isNotEqualTo(null);
        Assertions.assertThat((Object)statement).isNotEqualTo(new Object());
        IRI other = this.iri("http://example.org/other");
        Assertions.assertThat((Object)statement).isNotEqualTo((Object)this.statement((Resource)other, statement.getPredicate(), statement.getObject(), statement.getContext()));
        Assertions.assertThat((Object)statement).isNotEqualTo((Object)this.statement(statement.getSubject(), other, statement.getObject(), statement.getContext()));
        Assertions.assertThat((Object)statement).isNotEqualTo((Object)this.statement(statement.getSubject(), statement.getPredicate(), (Value)other, statement.getContext()));
        Assertions.assertThat((Object)statement).isNotEqualTo((Object)this.statement(statement.getSubject(), statement.getPredicate(), statement.getObject(), (Resource)other));
    }

    @Test
    public void testHashCode() {
        IRI subject = this.iri("http://example.org/subject");
        IRI predicate = this.iri("http://example.org/predicate");
        IRI object = this.iri("http://example.org/object");
        IRI context = this.iri("http://example.org/context");
        Statement statement = this.statement((Resource)subject, predicate, (Value)object, (Resource)context);
        ((AbstractIntegerAssert)Assertions.assertThat((int)statement.hashCode()).as("computed according to contract", new Object[0])).isEqualTo(Objects.hash(statement.getSubject(), statement.getPredicate(), statement.getObject(), statement.getContext()));
    }

    private /* synthetic */ void lambda$testConstructor$2(Resource subject, IRI predicate, Resource context) throws Throwable {
        this.statement(subject, predicate, null, context);
    }

    private /* synthetic */ void lambda$testConstructor$1(Resource subject, Value object, Resource context) throws Throwable {
        this.statement(subject, null, object, context);
    }

    private /* synthetic */ void lambda$testConstructor$0(IRI predicate, Value object, Resource context) throws Throwable {
        this.statement(null, predicate, object, context);
    }
}

