/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model;

import java.util.Objects;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.junit.Test;

public abstract class TripleTest {
    protected abstract Triple triple(Resource var1, IRI var2, Value var3);

    protected abstract IRI iri(String var1);

    @Test
    public final void testConstructor() {
        IRI subject = this.iri("http://example.org/subject");
        IRI predicate = this.iri("http://example.org/predicate");
        IRI object = this.iri("http://example.org/object");
        Triple triple = this.triple((Resource)subject, predicate, (Value)object);
        Assertions.assertThat((Object)triple.getSubject()).isEqualTo((Object)subject);
        Assertions.assertThat((Object)triple.getPredicate()).isEqualTo((Object)predicate);
        Assertions.assertThat((Object)triple.getObject()).isEqualTo((Object)object);
        Assertions.assertThatNullPointerException().isThrownBy(() -> this.lambda$testConstructor$0(predicate, (Value)object));
        Assertions.assertThatNullPointerException().isThrownBy(() -> this.lambda$testConstructor$1((Resource)subject, (Value)object));
        Assertions.assertThatNullPointerException().isThrownBy(() -> this.lambda$testConstructor$2((Resource)subject, predicate));
    }

    @Test
    public void testEquals() {
        IRI subject = this.iri("http://example.org/subject");
        IRI predicate = this.iri("http://example.org/predicate");
        IRI object = this.iri("http://example.org/object");
        Triple triple = this.triple((Resource)subject, predicate, (Value)object);
        Assertions.assertThat((Object)triple).isEqualTo((Object)triple);
        Assertions.assertThat((Object)triple).isEqualTo((Object)this.triple(triple.getSubject(), triple.getPredicate(), triple.getObject()));
        Assertions.assertThat((Object)triple).isNotEqualTo(null);
        Assertions.assertThat((Object)triple).isNotEqualTo(new Object());
        IRI other = this.iri("http://example.org/other");
        Assertions.assertThat((Object)triple).isNotEqualTo((Object)this.triple((Resource)other, triple.getPredicate(), triple.getObject()));
        Assertions.assertThat((Object)triple).isNotEqualTo((Object)this.triple(triple.getSubject(), other, triple.getObject()));
        Assertions.assertThat((Object)triple).isNotEqualTo((Object)this.triple(triple.getSubject(), triple.getPredicate(), (Value)other));
    }

    @Test
    public void testHashCode() {
        IRI subject = this.iri("http://example.org/subject");
        IRI predicate = this.iri("http://example.org/predicate");
        IRI object = this.iri("http://example.org/object");
        Triple triple = this.triple((Resource)subject, predicate, (Value)object);
        ((AbstractIntegerAssert)Assertions.assertThat((int)triple.hashCode()).as("computed according to contract", new Object[0])).isEqualTo(Objects.hash(triple.getSubject(), triple.getPredicate(), triple.getObject()));
    }

    private /* synthetic */ void lambda$testConstructor$2(Resource subject, IRI predicate) throws Throwable {
        this.triple(subject, predicate, null);
    }

    private /* synthetic */ void lambda$testConstructor$1(Resource subject, Value object) throws Throwable {
        this.triple(subject, null, object);
    }

    private /* synthetic */ void lambda$testConstructor$0(IRI predicate, Value object) throws Throwable {
        this.triple(null, predicate, object);
    }
}

