/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.util;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.rdf4j.OpenRDFUtil;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;

public class Statements {
    public static void consume(ValueFactory vf, Resource subject, IRI predicate, Value object, Consumer<Statement> consumer, Resource ... contexts) {
        OpenRDFUtil.verifyContextNotNull(contexts);
        Objects.requireNonNull(consumer);
        if (contexts.length > 0) {
            for (Resource context : contexts) {
                consumer.accept(vf.createStatement(subject, predicate, object, context));
            }
        } else {
            consumer.accept(vf.createStatement(subject, predicate, object));
        }
    }

    public static <C extends Collection<Statement>> C create(ValueFactory vf, Resource subject, IRI predicate, Value object, C collection, Resource ... contexts) {
        Objects.requireNonNull(collection);
        Statements.consume(vf, subject, predicate, object, st -> collection.add(st), contexts);
        return collection;
    }

    public static boolean isSameTriple(Statement st1, Statement st2) {
        Objects.requireNonNull(st1);
        Objects.requireNonNull(st2);
        return st1.getPredicate().equals(st2.getPredicate()) && st1.getSubject().equals(st2.getSubject()) && st1.getObject().equals(st2.getObject());
    }
}

