/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation;

import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;

public interface QueryValueEvaluationStep {
    public Value evaluate(BindingSet var1) throws ValueExprEvaluationException, QueryEvaluationException;

    default public boolean isConstant() {
        return false;
    }

    public static final class Minimal
    implements QueryValueEvaluationStep {
        private final ValueExpr ve;
        private final EvaluationStrategy strategy;

        public Minimal(EvaluationStrategy strategy, ValueExpr ve) {
            this.strategy = strategy;
            this.ve = ve;
        }

        @Override
        public Value evaluate(BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
            return this.strategy.evaluate(this.ve, bindings);
        }
    }

    public static class ConstantQueryValueEvaluationStep
    implements QueryValueEvaluationStep {
        private final Value value;

        public ConstantQueryValueEvaluationStep(ValueConstant valueConstant) {
            this.value = valueConstant.getValue();
        }

        public ConstantQueryValueEvaluationStep(Value valueConstant) {
            this.value = valueConstant;
        }

        @Override
        public Value evaluate(BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
            return this.value;
        }

        @Override
        public boolean isConstant() {
            return true;
        }
    }
}

