/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.SingletonIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.Service;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedService;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractSimpleQueryModelVisitor;
import org.eclipse.rdf4j.query.impl.MapBindingSet;

public final class ServiceQueryEvaluationStep
implements QueryEvaluationStep {
    private final Service service;
    private final Var serviceRef;
    private final FederatedServiceResolver serviceResolver;

    public ServiceQueryEvaluationStep(Service service, Var serviceRef, FederatedServiceResolver serviceResolver) {
        this.service = service;
        this.serviceRef = serviceRef;
        this.serviceResolver = serviceResolver;
    }

    @Override
    public CloseableIteration<BindingSet> evaluate(BindingSet bindings) {
        String serviceUri;
        if (this.serviceRef.hasValue()) {
            serviceUri = this.serviceRef.getValue().stringValue();
        } else if (bindings != null && bindings.getValue(this.serviceRef.getName()) != null) {
            serviceUri = bindings.getBinding(this.serviceRef.getName()).getValue().stringValue();
        } else {
            throw new QueryEvaluationException("SERVICE variables must be bound at evaluation time.");
        }
        try {
            FederatedService fs = this.serviceResolver.getService(serviceUri);
            HashSet freeVars = new HashSet(this.service.getServiceVars());
            freeVars.removeAll(bindings.getBindingNames());
            MapBindingSet allBindings = new MapBindingSet();
            for (Object binding : bindings) {
                allBindings.setBinding(binding.getName(), binding.getValue());
            }
            Set<Var> boundVars = this.getBoundVariables(this.service);
            for (Var boundVar : boundVars) {
                freeVars.remove(boundVar.getName());
                allBindings.setBinding(boundVar.getName(), boundVar.getValue());
            }
            bindings = allBindings;
            String baseUri = this.service.getBaseURI();
            if (freeVars.isEmpty()) {
                boolean exists = fs.ask(this.service, bindings, baseUri);
                if (exists) {
                    return new SingletonIteration((Object)bindings);
                }
                return EMPTY_ITERATION;
            }
            return fs.select(this.service, freeVars, bindings, baseUri);
        }
        catch (RuntimeException e) {
            if (this.service.isSilent()) {
                return new SingletonIteration((Object)bindings);
            }
            throw e;
        }
    }

    private Set<Var> getBoundVariables(Service service) {
        BoundVarVisitor visitor = new BoundVarVisitor();
        visitor.meet(service);
        return visitor.boundVars;
    }

    private static class BoundVarVisitor
    extends AbstractSimpleQueryModelVisitor<RuntimeException> {
        final Set<Var> boundVars = new HashSet<Var>();

        private BoundVarVisitor() {
            super(true);
        }

        public void meet(Var var) {
            if (var.hasValue()) {
                this.boundVars.add(var);
            }
        }
    }
}

