/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.order.AvailableStatementOrder;
import org.eclipse.rdf4j.query.algebra.AbstractQueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Var;

public abstract class BinaryTupleOperator
extends AbstractQueryModelNode
implements TupleExpr {
    protected TupleExpr leftArg;
    protected TupleExpr rightArg;
    private String algorithmName;

    protected BinaryTupleOperator() {
    }

    protected BinaryTupleOperator(TupleExpr leftArg, TupleExpr rightArg) {
        this.setLeftArg(leftArg);
        this.setRightArg(rightArg);
    }

    public TupleExpr getLeftArg() {
        return this.leftArg;
    }

    public void setLeftArg(TupleExpr leftArg) {
        assert (leftArg != null) : "leftArg must not be null";
        assert (leftArg != this) : "leftArg must not be itself";
        leftArg.setParentNode(this);
        this.leftArg = leftArg;
    }

    public TupleExpr getRightArg() {
        return this.rightArg;
    }

    public void setRightArg(TupleExpr rightArg) {
        assert (rightArg != null) : "rightArg must not be null";
        assert (rightArg != this) : "rightArg must not be itself";
        rightArg.setParentNode(this);
        this.rightArg = rightArg;
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        this.leftArg.visit(visitor);
        this.rightArg.visit(visitor);
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        if (this.leftArg == current) {
            this.setLeftArg((TupleExpr)replacement);
        } else if (this.rightArg == current) {
            this.setRightArg((TupleExpr)replacement);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof BinaryTupleOperator) {
            BinaryTupleOperator o = (BinaryTupleOperator)other;
            return this.leftArg.equals(o.getLeftArg()) && this.rightArg.equals(o.getRightArg());
        }
        return false;
    }

    public int hashCode() {
        return this.leftArg.hashCode() ^ this.rightArg.hashCode();
    }

    @Override
    public BinaryTupleOperator clone() {
        BinaryTupleOperator clone = (BinaryTupleOperator)super.clone();
        TupleExpr leftArgClone = this.getLeftArg().clone();
        leftArgClone.setParentNode(clone);
        clone.leftArg = leftArgClone;
        TupleExpr rightArgClone = this.getRightArg().clone();
        rightArgClone.setParentNode(clone);
        clone.rightArg = rightArgClone;
        return clone;
    }

    @Experimental
    public void setAlgorithm(CloseableIteration<?> iteration) {
        this.algorithmName = iteration.getClass().getSimpleName();
    }

    @Experimental
    public void setAlgorithm(String classSimpleName) {
        this.algorithmName = classSimpleName;
    }

    @Experimental
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public Set<Var> getSupportedOrders(AvailableStatementOrder tripleSource) {
        Set<Var> rightArgSupportedOrders;
        Set<Var> leftArgSupportedOrders = this.leftArg.getSupportedOrders(tripleSource);
        if (leftArgSupportedOrders.equals(rightArgSupportedOrders = this.rightArg.getSupportedOrders(tripleSource))) {
            return leftArgSupportedOrders;
        }
        HashSet<Var> intersection = new HashSet<Var>(leftArgSupportedOrders);
        intersection.retainAll(rightArgSupportedOrders);
        return intersection;
    }

    @Override
    public void setOrder(Var var) {
        this.leftArg.setOrder(var);
        this.rightArg.setOrder(var);
    }

    @Override
    public Var getOrder() {
        Var leftArgOrder = this.leftArg.getOrder();
        Var rightArgOrder = this.rightArg.getOrder();
        assert (Objects.equals(leftArgOrder, rightArgOrder));
        return leftArgOrder;
    }
}

