/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.parser.serql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.rdf4j.query.algebra.And;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.SingletonSet;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.parser.serql.OptionalTupleExpr;

class GraphPattern {
    private GraphPattern parent = null;
    private Var contextVar;
    private StatementPattern.Scope spScope = StatementPattern.Scope.DEFAULT_CONTEXTS;
    private List<TupleExpr> requiredTEs = new ArrayList<TupleExpr>();
    private List<OptionalTupleExpr> optionalTEs = new ArrayList<OptionalTupleExpr>();
    private List<ValueExpr> constraints = new ArrayList<ValueExpr>();

    public GraphPattern() {
    }

    public GraphPattern(GraphPattern parent) {
        if (parent != null) {
            this.parent = parent;
            this.contextVar = parent.contextVar;
            this.spScope = parent.spScope;
        }
    }

    public GraphPattern getParent() {
        return this.parent;
    }

    public void setContextVar(Var contextVar) {
        this.contextVar = contextVar;
    }

    public Var getContextVar() {
        return this.contextVar;
    }

    public void setStatementPatternScope(StatementPattern.Scope spScope) {
        this.spScope = spScope;
    }

    public StatementPattern.Scope getStatementPatternScope() {
        return this.spScope;
    }

    public void addRequiredTE(TupleExpr te) {
        this.requiredTEs.add(te);
    }

    public List<TupleExpr> getRequiredTEs() {
        return Collections.unmodifiableList(this.requiredTEs);
    }

    public void addOptionalTE(GraphPattern gp) {
        OptionalTupleExpr optTE;
        List<ValueExpr> constraints = gp.removeAllConstraints();
        TupleExpr tupleExpr = gp.buildTupleExpr();
        if (constraints.isEmpty()) {
            optTE = new OptionalTupleExpr(tupleExpr);
        } else {
            ValueExpr constraint = constraints.get(0);
            for (int i = 1; i < constraints.size(); ++i) {
                constraint = new And(constraint, constraints.get(i));
            }
            optTE = new OptionalTupleExpr(tupleExpr, constraint);
        }
        this.optionalTEs.add(optTE);
    }

    public List<OptionalTupleExpr> getOptionalTEs() {
        return Collections.unmodifiableList(this.optionalTEs);
    }

    public void addConstraint(ValueExpr constraint) {
        this.constraints.add(constraint);
    }

    public void addConstraints(Collection<ValueExpr> constraints) {
        this.constraints.addAll(constraints);
    }

    public List<ValueExpr> getConstraints() {
        return Collections.unmodifiableList(this.constraints);
    }

    public List<ValueExpr> removeAllConstraints() {
        List<ValueExpr> constraints = this.constraints;
        this.constraints = new ArrayList<ValueExpr>();
        return constraints;
    }

    public void clear() {
        this.requiredTEs.clear();
        this.optionalTEs.clear();
        this.constraints.clear();
    }

    public TupleExpr buildTupleExpr() {
        SingletonSet result;
        if (this.requiredTEs.isEmpty()) {
            result = new SingletonSet();
        } else {
            result = this.requiredTEs.get(0);
            for (int i = 1; i < this.requiredTEs.size(); ++i) {
                result = new Join((TupleExpr)result, this.requiredTEs.get(i));
            }
        }
        for (OptionalTupleExpr optTE : this.optionalTEs) {
            if (optTE.hasConstraint()) {
                result = new LeftJoin((TupleExpr)result, optTE.getTupleExpr(), optTE.getConstraint());
                continue;
            }
            result = new LeftJoin((TupleExpr)result, optTE.getTupleExpr());
        }
        for (ValueExpr constraint : this.constraints) {
            result = new Filter((TupleExpr)result, constraint);
        }
        return result;
    }
}

