/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.resultio;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.Optional;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Supplier;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryResultHandler;
import org.eclipse.rdf4j.query.QueryResultHandlerException;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.impl.QueueCursor;
import org.eclipse.rdf4j.query.impl.TupleQueryResultBuilder;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultFormat;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultParser;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultParserFactory;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultParserRegistry;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultWriter;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultWriterFactory;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultWriterRegistry;
import org.eclipse.rdf4j.query.resultio.QueryResultFormat;
import org.eclipse.rdf4j.query.resultio.QueryResultParseException;
import org.eclipse.rdf4j.query.resultio.QueryResultWriter;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultParser;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultParserFactory;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultParserRegistry;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultWriter;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultWriterFactory;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultWriterRegistry;
import org.eclipse.rdf4j.query.resultio.UnsupportedQueryResultFormatException;
import org.eclipse.rdf4j.query.resultio.helpers.BackgroundTupleResult;
import org.eclipse.rdf4j.query.resultio.helpers.QueryResultCollector;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.UnsupportedRDFormatException;

public class QueryResultIO {
    public static Optional<QueryResultFormat> getParserFormatForMIMEType(String mimeType) {
        return TupleQueryResultParserRegistry.getInstance().getFileFormatForMIMEType(mimeType);
    }

    public static Optional<QueryResultFormat> getParserFormatForFileName(String fileName) {
        return TupleQueryResultParserRegistry.getInstance().getFileFormatForFileName(fileName);
    }

    public static Optional<QueryResultFormat> getWriterFormatForMIMEType(String mimeType) {
        return TupleQueryResultWriterRegistry.getInstance().getFileFormatForMIMEType(mimeType);
    }

    public static Optional<QueryResultFormat> getWriterFormatForFileName(String fileName) {
        return TupleQueryResultWriterRegistry.getInstance().getFileFormatForFileName(fileName);
    }

    public static Optional<QueryResultFormat> getBooleanParserFormatForMIMEType(String mimeType) {
        return BooleanQueryResultParserRegistry.getInstance().getFileFormatForMIMEType(mimeType);
    }

    public static Optional<QueryResultFormat> getBooleanParserFormatForFileName(String fileName) {
        return BooleanQueryResultParserRegistry.getInstance().getFileFormatForFileName(fileName);
    }

    public static Optional<QueryResultFormat> getBooleanWriterFormatForMIMEType(String mimeType) {
        return BooleanQueryResultWriterRegistry.getInstance().getFileFormatForMIMEType(mimeType);
    }

    public static Optional<QueryResultFormat> getBooleanWriterFormatForFileName(String fileName) {
        return BooleanQueryResultWriterRegistry.getInstance().getFileFormatForFileName(fileName);
    }

    public static TupleQueryResultParser createTupleParser(QueryResultFormat format) throws UnsupportedQueryResultFormatException {
        TupleQueryResultParserFactory factory = (TupleQueryResultParserFactory)TupleQueryResultParserRegistry.getInstance().get((Object)format).orElseThrow(() -> new UnsupportedQueryResultFormatException("No parser factory available for tuple query result format " + format));
        return factory.getParser();
    }

    public static TupleQueryResultParser createTupleParser(QueryResultFormat format, ValueFactory valueFactory) throws UnsupportedQueryResultFormatException {
        TupleQueryResultParser parser = QueryResultIO.createTupleParser(format);
        parser.setValueFactory(valueFactory);
        return parser;
    }

    public static TupleQueryResultWriter createTupleWriter(QueryResultFormat format, OutputStream out) throws UnsupportedQueryResultFormatException {
        TupleQueryResultWriterFactory factory = (TupleQueryResultWriterFactory)TupleQueryResultWriterRegistry.getInstance().get((Object)format).orElseThrow(() -> new UnsupportedQueryResultFormatException("No writer factory available for tuple query result format " + format));
        return factory.getWriter(out);
    }

    public static BooleanQueryResultParser createBooleanParser(QueryResultFormat format) throws UnsupportedQueryResultFormatException {
        BooleanQueryResultParserFactory factory = (BooleanQueryResultParserFactory)BooleanQueryResultParserRegistry.getInstance().get((Object)format).orElseThrow(() -> new UnsupportedQueryResultFormatException("No parser factory available for boolean query result format " + format));
        return factory.getParser();
    }

    public static BooleanQueryResultWriter createBooleanWriter(QueryResultFormat format, OutputStream out) throws UnsupportedQueryResultFormatException {
        BooleanQueryResultWriterFactory factory = (BooleanQueryResultWriterFactory)BooleanQueryResultWriterRegistry.getInstance().get((Object)format).orElseThrow(() -> new UnsupportedQueryResultFormatException("No writer factory available for boolean query result format " + format));
        return factory.getWriter(out);
    }

    public static QueryResultWriter createWriter(QueryResultFormat format, OutputStream out) throws UnsupportedQueryResultFormatException {
        Supplier<UnsupportedQueryResultFormatException> exception = () -> new UnsupportedQueryResultFormatException("No writer factory available for query result format " + format);
        if (format instanceof TupleQueryResultFormat) {
            TupleQueryResultWriterFactory factory = (TupleQueryResultWriterFactory)TupleQueryResultWriterRegistry.getInstance().get((Object)((TupleQueryResultFormat)format)).orElseThrow(exception);
            return factory.getWriter(out);
        }
        if (format instanceof BooleanQueryResultFormat) {
            BooleanQueryResultWriterFactory factory = (BooleanQueryResultWriterFactory)BooleanQueryResultWriterRegistry.getInstance().get((Object)((BooleanQueryResultFormat)format)).orElseThrow(exception);
            return factory.getWriter(out);
        }
        throw exception.get();
    }

    public static void parseTuple(InputStream in, QueryResultFormat format, TupleQueryResultHandler handler, ValueFactory valueFactory) throws IOException, QueryResultParseException, TupleQueryResultHandlerException, UnsupportedQueryResultFormatException {
        TupleQueryResultParser parser = QueryResultIO.createTupleParser(format);
        parser.setValueFactory(valueFactory);
        parser.setQueryResultHandler((QueryResultHandler)handler);
        try {
            parser.parseQueryResult(in);
        }
        catch (QueryResultHandlerException e) {
            if (e instanceof TupleQueryResultHandlerException) {
                throw (TupleQueryResultHandlerException)e;
            }
            throw new TupleQueryResultHandlerException((Throwable)e);
        }
    }

    public static TupleQueryResult parseTuple(InputStream in, QueryResultFormat format, WeakReference<?> callerReference) throws IOException, QueryResultParseException, TupleQueryResultHandlerException, UnsupportedQueryResultFormatException {
        return QueryResultIO.parseTupleInternal(in, format, false, callerReference);
    }

    public static TupleQueryResult parseTupleBackground(InputStream in, QueryResultFormat format, WeakReference<?> callerReference) throws IOException, QueryResultParseException, TupleQueryResultHandlerException, UnsupportedQueryResultFormatException {
        return QueryResultIO.parseTupleInternal(in, format, true, callerReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TupleQueryResult parseTupleInternal(InputStream in, QueryResultFormat format, boolean parseOnBackgroundThread, WeakReference<?> callerReference) throws IOException, QueryResultParseException, TupleQueryResultHandlerException, UnsupportedQueryResultFormatException {
        TupleQueryResultParser parser = QueryResultIO.createTupleParser(format);
        if (parseOnBackgroundThread) {
            BackgroundTupleResult result = new BackgroundTupleResult((QueueCursor<BindingSet>)new QueueCursor(new LinkedBlockingQueue(1), callerReference), parser, in);
            boolean allGood = false;
            try {
                ForkJoinPool.commonPool().submit(result);
                allGood = true;
            }
            finally {
                if (!allGood) {
                    result.close();
                }
            }
            return result;
        }
        TupleQueryResultBuilder qrBuilder = new TupleQueryResultBuilder();
        try {
            parser.setQueryResultHandler((QueryResultHandler)qrBuilder).parseQueryResult(in);
        }
        catch (QueryResultHandlerException e) {
            if (e instanceof TupleQueryResultHandlerException) {
                throw (TupleQueryResultHandlerException)e;
            }
            throw new TupleQueryResultHandlerException((Throwable)e);
        }
        return qrBuilder.getQueryResult();
    }

    public static boolean parseBoolean(InputStream in, QueryResultFormat format) throws IOException, QueryResultParseException, UnsupportedQueryResultFormatException {
        BooleanQueryResultParser parser = QueryResultIO.createBooleanParser(format);
        try {
            QueryResultCollector handler = new QueryResultCollector();
            parser.setQueryResultHandler(handler);
            parser.parseQueryResult(in);
            if (handler.getHandledBoolean()) {
                return handler.getBoolean();
            }
            throw new QueryResultParseException("Did not find a boolean result");
        }
        catch (QueryResultHandlerException e) {
            throw new QueryResultParseException(e);
        }
    }

    public static void writeTuple(TupleQueryResult tqr, QueryResultFormat format, OutputStream out) throws IOException, TupleQueryResultHandlerException, UnsupportedQueryResultFormatException, QueryEvaluationException {
        TupleQueryResultWriter writer = QueryResultIO.createTupleWriter(format, out);
        try {
            writer.startDocument();
            writer.startHeader();
            QueryResults.report((TupleQueryResult)tqr, (QueryResultHandler)writer);
        }
        catch (QueryResultHandlerException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            if (e instanceof TupleQueryResultHandlerException) {
                throw (TupleQueryResultHandlerException)e;
            }
            throw new TupleQueryResultHandlerException((Throwable)e);
        }
    }

    public static void writeBoolean(boolean value, QueryResultFormat format, OutputStream out) throws QueryResultHandlerException, UnsupportedQueryResultFormatException {
        BooleanQueryResultWriter writer = QueryResultIO.createBooleanWriter(format, out);
        writer.startDocument();
        writer.startHeader();
        writer.handleBoolean(value);
    }

    public static void writeGraph(GraphQueryResult gqr, RDFFormat format, OutputStream out) throws IOException, RDFHandlerException, UnsupportedRDFormatException, QueryEvaluationException {
        RDFWriter writer = Rio.createWriter((RDFFormat)format, (OutputStream)out);
        try {
            QueryResults.report((GraphQueryResult)gqr, (RDFHandler)writer);
        }
        catch (RDFHandlerException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }
}

