/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.resultio.text.tsv;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.eclipse.rdf4j.common.io.CharSink;
import org.eclipse.rdf4j.common.text.StringUtil;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryResultHandlerException;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.resultio.AbstractQueryResultWriter;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultWriter;

public class SPARQLResultsTSVWriter
extends AbstractQueryResultWriter
implements TupleQueryResultWriter,
CharSink {
    protected Writer writer;
    private List<String> bindingNames;
    protected boolean tupleVariablesFound = false;

    public SPARQLResultsTSVWriter(OutputStream out) {
        this(new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8), 1024));
    }

    public SPARQLResultsTSVWriter(Writer writer) {
        this.writer = writer;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void startQueryResult(List<String> bindingNames) throws TupleQueryResultHandlerException {
        super.startQueryResult(bindingNames);
        this.tupleVariablesFound = true;
        this.bindingNames = bindingNames;
        try {
            for (int i = 0; i < bindingNames.size(); ++i) {
                this.writer.write("?");
                this.writer.write(bindingNames.get(i));
                if (i >= bindingNames.size() - 1) continue;
                this.writer.write("\t");
            }
            this.writer.write("\n");
        }
        catch (IOException e) {
            throw new TupleQueryResultHandlerException((Throwable)e);
        }
    }

    public void endQueryResult() throws TupleQueryResultHandlerException {
        if (!this.tupleVariablesFound) {
            throw new IllegalStateException("Could not end query result as startQueryResult was not called first.");
        }
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new TupleQueryResultHandlerException((Throwable)e);
        }
    }

    protected void handleSolutionImpl(BindingSet bindingSet) throws TupleQueryResultHandlerException {
        if (!this.tupleVariablesFound) {
            throw new IllegalStateException("Must call startQueryResult before handleSolution");
        }
        try {
            for (int i = 0; i < this.bindingNames.size(); ++i) {
                String name = this.bindingNames.get(i);
                Value value = bindingSet.getValue(name);
                if (value != null) {
                    this.writeValue(value);
                }
                if (i >= this.bindingNames.size() - 1) continue;
                this.writer.write("\t");
            }
            this.writer.write("\n");
        }
        catch (IOException e) {
            throw new TupleQueryResultHandlerException((Throwable)e);
        }
    }

    public TupleQueryResultFormat getTupleQueryResultFormat() {
        return TupleQueryResultFormat.TSV;
    }

    public final TupleQueryResultFormat getQueryResultFormat() {
        return this.getTupleQueryResultFormat();
    }

    protected void writeValue(Value val) throws IOException {
        if (val instanceof Triple) {
            this.writer.write("<<");
            this.writeValue((Value)((Triple)val).getSubject());
            this.writer.write(32);
            this.writeValue((Value)((Triple)val).getPredicate());
            this.writer.write(32);
            this.writeValue(((Triple)val).getObject());
            this.writer.write(">>");
        } else if (val instanceof Resource) {
            this.writeResource((Resource)val);
        } else {
            this.writeLiteral((Literal)val);
        }
    }

    protected void writeResource(Resource res) throws IOException {
        if (res instanceof IRI) {
            this.writeURI((IRI)res);
        } else {
            this.writeBNode((BNode)res);
        }
    }

    protected void writeURI(IRI uri) throws IOException {
        String uriString = uri.toString();
        this.writer.write("<" + uriString + ">");
    }

    protected void writeBNode(BNode bNode) throws IOException {
        this.writer.write("_:");
        this.writer.write(bNode.getID());
    }

    private void writeLiteral(Literal lit) throws IOException {
        String label = lit.getLabel();
        IRI datatype = lit.getDatatype();
        if (XSD.INTEGER.equals((Object)datatype) || XSD.DECIMAL.equals((Object)datatype) || XSD.DOUBLE.equals((Object)datatype)) {
            try {
                this.writer.write(XMLDatatypeUtil.normalize((String)label, (IRI)datatype));
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        String encoded = SPARQLResultsTSVWriter.encodeString(label);
        if (Literals.isLanguageLiteral((Literal)lit)) {
            this.writer.write("\"");
            this.writer.write(encoded);
            this.writer.write("\"");
            this.writer.write("@");
            this.writer.write((String)lit.getLanguage().get());
        } else if (!XSD.STRING.equals((Object)datatype) || !this.xsdStringToPlainLiteral()) {
            this.writer.write("\"");
            this.writer.write(encoded);
            this.writer.write("\"");
            this.writer.write("^^");
            this.writeURI(datatype);
        } else if (label.length() > 0 && encoded.equals(label) && label.charAt(0) != '<' && label.charAt(0) != '_' && !label.matches("^[\\+\\-]?[\\d\\.].*")) {
            this.writer.write(encoded);
        } else {
            this.writer.write("\"");
            this.writer.write(encoded);
            this.writer.write("\"");
        }
    }

    private static String encodeString(String s) {
        s = StringUtil.gsub((String)"\\", (String)"\\\\", (String)s);
        s = StringUtil.gsub((String)"\t", (String)"\\t", (String)s);
        s = StringUtil.gsub((String)"\n", (String)"\\n", (String)s);
        s = StringUtil.gsub((String)"\r", (String)"\\r", (String)s);
        s = StringUtil.gsub((String)"\"", (String)"\\\"", (String)s);
        return s;
    }

    public void startDocument() throws TupleQueryResultHandlerException {
    }

    public void handleStylesheet(String stylesheetUrl) throws TupleQueryResultHandlerException {
    }

    public void startHeader() throws TupleQueryResultHandlerException {
    }

    public void handleLinks(List<String> linkUrls) throws TupleQueryResultHandlerException {
    }

    public void endHeader() throws TupleQueryResultHandlerException {
    }

    public void handleBoolean(boolean value) throws QueryResultHandlerException {
        throw new UnsupportedOperationException("Cannot handle boolean results");
    }

    public void handleNamespace(String prefix, String uri) throws QueryResultHandlerException {
    }
}

