/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.sail.config;

import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.ModelException;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.repository.config.AbstractRepositoryImplConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.sail.config.ProxyRepositorySchema;

public class ProxyRepositoryConfig
extends AbstractRepositoryImplConfig {
    private String proxiedID;

    public ProxyRepositoryConfig() {
        super("openrdf:ProxyRepository");
    }

    public ProxyRepositoryConfig(String proxiedID) {
        this();
        this.setProxiedRepositoryID(proxiedID);
    }

    public final void setProxiedRepositoryID(String value) {
        this.proxiedID = value;
    }

    public String getProxiedRepositoryID() {
        return this.proxiedID;
    }

    public void validate() throws RepositoryConfigException {
        super.validate();
        if (null == this.proxiedID) {
            throw new RepositoryConfigException("No id specified for proxied repository");
        }
    }

    public Resource export(Model model) {
        Resource implNode = super.export(model);
        if (null != this.proxiedID) {
            model.add(implNode, ProxyRepositorySchema.PROXIED_ID, (Value)SimpleValueFactory.getInstance().createLiteral(this.proxiedID), new Resource[0]);
        }
        return implNode;
    }

    public void parse(Model model, Resource implNode) throws RepositoryConfigException {
        super.parse(model, implNode);
        try {
            Literal lit = Models.objectLiteral((Model)model.filter(implNode, ProxyRepositorySchema.PROXIED_ID, null, new Resource[0]));
            if (lit != null) {
                this.setProxiedRepositoryID(lit.getLabel());
            }
        }
        catch (ModelException e) {
            throw new RepositoryConfigException(e.getMessage(), (Throwable)e);
        }
    }
}

