/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.evaluation;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.ExceptionConvertingIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;

public class RepositoryTripleSource
implements TripleSource {
    private final RepositoryConnection repo;
    private final boolean includeInferred;

    public RepositoryTripleSource(RepositoryConnection repo) {
        this(repo, true);
    }

    public RepositoryTripleSource(RepositoryConnection repo, boolean includeInferred) {
        this.repo = repo;
        this.includeInferred = includeInferred;
    }

    public CloseableIteration<? extends Statement, QueryEvaluationException> getStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws QueryEvaluationException {
        RepositoryResult result;
        try {
            result = this.repo.getStatements(subj, pred, obj, this.includeInferred, contexts);
        }
        catch (RepositoryException e) {
            throw new QueryEvaluationException((Throwable)e);
        }
        return new ExceptionConvertingIteration<Statement, QueryEvaluationException>((Iteration)result){

            protected QueryEvaluationException convert(Exception exception) {
                return new QueryEvaluationException((Throwable)exception);
            }
        };
    }

    public ValueFactory getValueFactory() {
        return this.repo.getValueFactory();
    }
}

