/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.sail;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.ConvertingIteration;
import org.eclipse.rdf4j.common.iteration.FilterIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.impl.IteratingGraphQueryResult;
import org.eclipse.rdf4j.query.parser.ParsedGraphQuery;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.repository.sail.SailQuery;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;

public class SailGraphQuery
extends SailQuery
implements GraphQuery {
    protected SailGraphQuery(ParsedGraphQuery tupleQuery, SailRepositoryConnection con) {
        super((ParsedQuery)tupleQuery, con);
    }

    public ParsedGraphQuery getParsedQuery() {
        return (ParsedGraphQuery)super.getParsedQuery();
    }

    public GraphQueryResult evaluate() throws QueryEvaluationException {
        TupleExpr tupleExpr = this.getParsedQuery().getTupleExpr();
        try {
            SailConnection sailCon = this.getConnection().getSailConnection();
            Object bindingsIter = sailCon.evaluate(tupleExpr, this.getActiveDataset(), this.getBindings(), this.getIncludeInferred());
            bindingsIter = new FilterIteration<BindingSet, QueryEvaluationException>((Iteration)bindingsIter){

                protected boolean accept(BindingSet bindingSet) {
                    Value context = bindingSet.getValue("context");
                    return bindingSet.getValue("subject") instanceof Resource && bindingSet.getValue("predicate") instanceof IRI && bindingSet.getValue("object") instanceof Value && (context == null || context instanceof Resource);
                }
            };
            bindingsIter = this.enforceMaxQueryTime((CloseableIteration)bindingsIter);
            final ValueFactory vf = this.getConnection().getRepository().getValueFactory();
            ConvertingIteration<BindingSet, Statement, QueryEvaluationException> stIter = new ConvertingIteration<BindingSet, Statement, QueryEvaluationException>((Iteration)bindingsIter){

                protected Statement convert(BindingSet bindingSet) {
                    Resource subject = (Resource)bindingSet.getValue("subject");
                    IRI predicate = (IRI)bindingSet.getValue("predicate");
                    Value object = bindingSet.getValue("object");
                    Resource context = (Resource)bindingSet.getValue("context");
                    if (context == null) {
                        return vf.createStatement(subject, predicate, object);
                    }
                    return vf.createStatement(subject, predicate, object, context);
                }
            };
            return new IteratingGraphQueryResult(this.getParsedQuery().getQueryNamespaces(), (CloseableIteration)stIter);
        }
        catch (SailException e) {
            throw new QueryEvaluationException(e.getMessage(), (Throwable)e);
        }
    }

    public void evaluate(RDFHandler handler) throws QueryEvaluationException, RDFHandlerException {
        GraphQueryResult queryResult = this.evaluate();
        QueryResults.report((GraphQueryResult)queryResult, (RDFHandler)handler);
    }
}

