/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.sail;

import java.io.File;
import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.base.AbstractRepository;
import org.eclipse.rdf4j.repository.sail.config.RepositoryResolver;
import org.eclipse.rdf4j.repository.sail.config.RepositoryResolverClient;

public class ProxyRepository
extends AbstractRepository
implements RepositoryResolverClient {
    private File dataDir;
    private Repository proxiedRepository;
    private String proxiedID;
    private RepositoryResolver resolver;

    public ProxyRepository() {
    }

    public ProxyRepository(String proxiedIdentity) {
        this.setProxiedIdentity(proxiedIdentity);
    }

    public ProxyRepository(RepositoryResolver resolver, String proxiedIdentity) {
        this.setRepositoryResolver(resolver);
        this.setProxiedIdentity(proxiedIdentity);
    }

    public final void setProxiedIdentity(String value) {
        if (!value.equals(this.proxiedID)) {
            this.proxiedID = value;
            this.proxiedRepository = null;
        }
    }

    public String getProxiedIdentity() {
        return this.proxiedID;
    }

    @Override
    public final void setRepositoryResolver(RepositoryResolver resolver) {
        if (resolver != this.resolver) {
            this.resolver = resolver;
            this.proxiedRepository = null;
        }
    }

    private Repository getProxiedRepository() {
        if (null == this.proxiedRepository) {
            assert (null != this.resolver) : "Expected resolver to be set.";
            assert (null != this.proxiedID) : "Expected proxiedID to be set.";
            try {
                this.proxiedRepository = this.resolver.getRepository(this.proxiedID);
            }
            catch (RDF4JException ore) {
                throw new IllegalStateException(ore);
            }
        }
        return this.proxiedRepository;
    }

    public void setDataDir(File dataDir) {
        this.dataDir = dataDir;
    }

    public File getDataDir() {
        return this.dataDir;
    }

    public boolean isWritable() throws RepositoryException {
        return this.getProxiedRepository().isWritable();
    }

    public RepositoryConnection getConnection() throws RepositoryException {
        return this.getProxiedRepository().getConnection();
    }

    public ValueFactory getValueFactory() {
        return this.getProxiedRepository().getValueFactory();
    }

    protected void initializeInternal() throws RepositoryException {
        if (this.resolver == null) {
            throw new RepositoryException("Expected RepositoryResolver to be set.");
        }
        this.getProxiedRepository().initialize();
    }

    protected void shutDownInternal() throws RepositoryException {
        this.getProxiedRepository().shutDown();
    }
}

