/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.sail;

import java.util.ArrayList;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryResultHandler;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.impl.IteratingTupleQueryResult;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.ParsedTupleQuery;
import org.eclipse.rdf4j.repository.sail.SailQuery;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;

public class SailTupleQuery
extends SailQuery
implements TupleQuery {
    public SailTupleQuery(ParsedTupleQuery tupleQuery, SailRepositoryConnection sailConnection) {
        super((ParsedQuery)tupleQuery, sailConnection);
    }

    public ParsedTupleQuery getParsedQuery() {
        return (ParsedTupleQuery)super.getParsedQuery();
    }

    public TupleQueryResult evaluate() throws QueryEvaluationException {
        TupleExpr tupleExpr = this.getParsedQuery().getTupleExpr();
        CloseableIteration bindingsIter = null;
        try {
            SailConnection sailCon = this.getConnection().getSailConnection();
            bindingsIter = sailCon.evaluate(tupleExpr, this.getActiveDataset(), this.getBindings(), this.getIncludeInferred());
            bindingsIter = this.enforceMaxQueryTime(bindingsIter);
            return new IteratingTupleQueryResult(new ArrayList(tupleExpr.getBindingNames()), bindingsIter);
        }
        catch (Throwable e) {
            if (bindingsIter != null) {
                bindingsIter.close();
            }
            if (e instanceof SailException) {
                throw new QueryEvaluationException(e.getMessage(), e);
            }
            throw e;
        }
    }

    public void evaluate(TupleQueryResultHandler handler) throws QueryEvaluationException, TupleQueryResultHandlerException {
        TupleQueryResult queryResult = this.evaluate();
        QueryResults.report((TupleQueryResult)queryResult, (QueryResultHandler)handler);
    }
}

