/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.sparql.federation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.algebra.Service;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedService;
import org.eclipse.rdf4j.query.impl.EmptyBindingSet;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sparql.federation.CollectionIteration;
import org.eclipse.rdf4j.repository.sparql.federation.JoinExecutorBase;
import org.eclipse.rdf4j.repository.sparql.federation.SPARQLCrossProductIteration;
import org.eclipse.rdf4j.repository.sparql.federation.ServiceJoinConversionIteration;
import org.eclipse.rdf4j.repository.sparql.federation.SilentIteration;
import org.eclipse.rdf4j.repository.sparql.query.InsertBindingSetCursor;
import org.eclipse.rdf4j.repository.sparql.query.QueryStringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryFederatedService
implements FederatedService {
    static final Logger logger = LoggerFactory.getLogger(RepositoryFederatedService.class);
    protected final Repository rep;
    protected boolean shutDown = true;
    protected RepositoryConnection conn = null;

    public RepositoryFederatedService(Repository repo) {
        this(repo, true);
    }

    public RepositoryFederatedService(Repository repo, boolean shutDown) {
        this.rep = repo;
        this.shutDown = shutDown;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> select(Service service, Set<String> projectionVars, BindingSet bindings, String baseUri) throws QueryEvaluationException {
        try {
            String sparqlQueryString = service.getSelectQueryString(projectionVars);
            TupleQuery query = this.getConnection().prepareTupleQuery(QueryLanguage.SPARQL, sparqlQueryString, baseUri);
            for (Binding b : bindings) {
                if (!service.getServiceVars().contains(b.getName())) continue;
                query.setBinding(b.getName(), b.getValue());
            }
            TupleQueryResult res = query.evaluate();
            InsertBindingSetCursor result = new InsertBindingSetCursor((CloseableIteration<BindingSet, QueryEvaluationException>)res, bindings);
            if (service.isSilent()) {
                return new SilentIteration((CloseableIteration<BindingSet, QueryEvaluationException>)result);
            }
            return result;
        }
        catch (MalformedQueryException e) {
            throw new QueryEvaluationException((Throwable)e);
        }
        catch (RepositoryException e) {
            throw new QueryEvaluationException("Repository for endpoint " + this.rep.toString() + " could not be initialized.", (Throwable)e);
        }
    }

    public boolean ask(Service service, BindingSet bindings, String baseUri) throws QueryEvaluationException {
        try {
            String sparqlQueryString = service.getAskQueryString();
            BooleanQuery query = this.getConnection().prepareBooleanQuery(QueryLanguage.SPARQL, sparqlQueryString, baseUri);
            for (Binding b : bindings) {
                if (!service.getServiceVars().contains(b.getName())) continue;
                query.setBinding(b.getName(), b.getValue());
            }
            return query.evaluate();
        }
        catch (MalformedQueryException e) {
            throw new QueryEvaluationException((Throwable)e);
        }
        catch (RepositoryException e) {
            throw new QueryEvaluationException("Repository for endpoint " + this.rep.toString() + " could not be initialized.", (Throwable)e);
        }
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Service service, CloseableIteration<BindingSet, QueryEvaluationException> bindings, String baseUri) throws QueryEvaluationException {
        int blockSize = 15;
        if (blockSize > 0) {
            return new BatchingServiceIteration(bindings, blockSize, service);
        }
        return this.evaluateInternal(service, bindings, service.getBaseURI());
    }

    protected CloseableIteration<BindingSet, QueryEvaluationException> evaluateInternal(Service service, CloseableIteration<BindingSet, QueryEvaluationException> bindings, String baseUri) throws QueryEvaluationException {
        LinkedList<BindingSet> allBindings = new LinkedList<BindingSet>();
        while (bindings.hasNext()) {
            allBindings.add((BindingSet)bindings.next());
        }
        if (allBindings.isEmpty()) {
            return new EmptyIteration();
        }
        HashSet<String> projectionVars = new HashSet<String>(service.getServiceVars());
        projectionVars.removeAll(((BindingSet)allBindings.get(0)).getBindingNames());
        Object result = null;
        try {
            if (allBindings.size() == 1) {
                result = this.select(service, projectionVars, (BindingSet)allBindings.get(0), baseUri);
                result = service.isSilent() ? new SilentIteration((CloseableIteration<BindingSet, QueryEvaluationException>)result) : result;
                return result;
            }
            projectionVars.add("__rowIdx");
            String queryString = service.getSelectQueryString(projectionVars);
            List<String> relevantBindingNames = this.getRelevantBindingNames(allBindings, service.getServiceVars());
            if (!relevantBindingNames.isEmpty()) {
                queryString = queryString + this.buildVALUESClause(allBindings, relevantBindingNames);
            }
            TupleQuery query = this.getConnection().prepareTupleQuery(QueryLanguage.SPARQL, queryString, baseUri);
            TupleQueryResult res = null;
            query.setMaxQueryTime(60);
            res = query.evaluate();
            result = relevantBindingNames.isEmpty() ? new SPARQLCrossProductIteration((CloseableIteration<BindingSet, QueryEvaluationException>)res, allBindings) : new ServiceJoinConversionIteration((CloseableIteration<BindingSet, QueryEvaluationException>)res, allBindings);
            result = service.isSilent() ? new SilentIteration((CloseableIteration<BindingSet, QueryEvaluationException>)result) : result;
            return result;
        }
        catch (RepositoryException e) {
            Iterations.closeCloseable(result);
            if (service.isSilent()) {
                return new CollectionIteration(allBindings);
            }
            throw new QueryEvaluationException("Repository for endpoint " + this.rep.toString() + " could not be initialized.", (Throwable)e);
        }
        catch (MalformedQueryException e) {
            throw new QueryEvaluationException((Throwable)e);
        }
        catch (QueryEvaluationException e) {
            Iterations.closeCloseable(result);
            if (service.isSilent()) {
                return new CollectionIteration(allBindings);
            }
            throw e;
        }
        catch (RuntimeException e) {
            Iterations.closeCloseable(result);
            if (service.isSilent()) {
                return new CollectionIteration(allBindings);
            }
            throw e;
        }
    }

    public void initialize() throws QueryEvaluationException {
        try {
            this.rep.initialize();
        }
        catch (RepositoryException e) {
            throw new QueryEvaluationException((Throwable)e);
        }
    }

    public boolean isInitialized() {
        return this.rep.isInitialized();
    }

    private void closeQuietly(TupleQueryResult res) {
        try {
            if (res != null) {
                res.close();
            }
        }
        catch (Exception e) {
            logger.debug("Could not close connection properly: " + e.getMessage(), (Throwable)e);
        }
    }

    public void shutdown() throws QueryEvaluationException {
        boolean foundException = false;
        try {
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (RepositoryException e) {
            foundException = true;
            throw new QueryEvaluationException((Throwable)e);
        }
        finally {
            block12: {
                try {
                    if (this.shutDown) {
                        this.rep.shutDown();
                    }
                }
                catch (RepositoryException e) {
                    if (foundException) break block12;
                    throw new QueryEvaluationException((Throwable)e);
                }
            }
        }
    }

    protected RepositoryConnection getConnection() throws RepositoryException {
        if (this.conn == null) {
            this.conn = this.rep.getConnection();
        }
        return this.conn;
    }

    private List<String> getRelevantBindingNames(List<BindingSet> bindings, Set<String> serviceVars) {
        ArrayList<String> relevantBindingNames = new ArrayList<String>(5);
        for (String bName : bindings.get(0).getBindingNames()) {
            if (!serviceVars.contains(bName)) continue;
            relevantBindingNames.add(bName);
        }
        return relevantBindingNames;
    }

    private String buildVALUESClause(List<BindingSet> bindings, List<String> relevantBindingNames) throws QueryEvaluationException {
        StringBuilder sb = new StringBuilder();
        sb.append(" VALUES (?__rowIdx");
        for (String bName : relevantBindingNames) {
            sb.append(" ?").append(bName);
        }
        sb.append(") { ");
        int rowIdx = 0;
        for (BindingSet b : bindings) {
            sb.append(" (");
            sb.append("\"").append(rowIdx++).append("\" ");
            for (String bName : relevantBindingNames) {
                QueryStringUtil.appendValueAsString(sb, b.getValue(bName)).append(" ");
            }
            sb.append(")");
        }
        sb.append(" }");
        return sb.toString();
    }

    private class BatchingServiceIteration
    extends JoinExecutorBase<BindingSet> {
        private final int blockSize;
        private final Service service;

        public BatchingServiceIteration(CloseableIteration<BindingSet, QueryEvaluationException> inputBindings, int blockSize, Service service) throws QueryEvaluationException {
            super(inputBindings, null, EmptyBindingSet.getInstance());
            this.blockSize = blockSize;
            this.service = service;
            this.run();
        }

        @Override
        protected void handleBindings() throws Exception {
            while (!this.isClosed() && this.leftIter.hasNext()) {
                ArrayList<Object> blockBindings = new ArrayList<Object>(this.blockSize);
                for (int i = 0; i < this.blockSize && this.leftIter.hasNext(); ++i) {
                    blockBindings.add(this.leftIter.next());
                }
                CollectionIteration materializedIter = new CollectionIteration(blockBindings);
                this.addResult(RepositoryFederatedService.this.evaluateInternal(this.service, (CloseableIteration<BindingSet, QueryEvaluationException>)materializedIter, this.service.getBaseURI()));
            }
        }
    }
}

