/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.rdf4j.common.lang.FileFormat;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

public class RDFFormat
extends FileFormat {
    public static final boolean SUPPORTS_NAMESPACES = true;
    public static final boolean NO_NAMESPACES = false;
    public static final boolean SUPPORTS_CONTEXTS = true;
    public static final boolean NO_CONTEXTS = false;
    public static final RDFFormat RDFXML = new RDFFormat("RDF/XML", Arrays.asList("application/rdf+xml", "application/xml"), Charset.forName("UTF-8"), Arrays.asList("rdf", "rdfs", "owl", "xml"), SimpleValueFactory.getInstance().createIRI("http://www.w3.org/ns/formats/RDF_XML"), true, false);
    public static final RDFFormat NTRIPLES = new RDFFormat("N-Triples", Arrays.asList("application/n-triples", "text/plain"), Charset.forName("UTF-8"), Arrays.asList("nt"), SimpleValueFactory.getInstance().createIRI("http://www.w3.org/ns/formats/N-Triples"), false, false);
    public static final RDFFormat TURTLE = new RDFFormat("Turtle", Arrays.asList("text/turtle", "application/x-turtle"), Charset.forName("UTF-8"), Arrays.asList("ttl"), SimpleValueFactory.getInstance().createIRI("http://www.w3.org/ns/formats/Turtle"), true, false);
    public static final RDFFormat N3 = new RDFFormat("N3", Arrays.asList("text/n3", "text/rdf+n3"), Charset.forName("UTF-8"), Arrays.asList("n3"), SimpleValueFactory.getInstance().createIRI("http://www.w3.org/ns/formats/N3"), true, false);
    public static final RDFFormat TRIX = new RDFFormat("TriX", Arrays.asList("application/trix"), Charset.forName("UTF-8"), Arrays.asList("xml", "trix"), null, true, true);
    public static final RDFFormat TRIG = new RDFFormat("TriG", Arrays.asList("application/trig", "application/x-trig"), Charset.forName("UTF-8"), Arrays.asList("trig"), SimpleValueFactory.getInstance().createIRI("http://www.w3.org/ns/formats/TriG"), true, true);
    public static final RDFFormat BINARY = new RDFFormat("BinaryRDF", Arrays.asList("application/x-binary-rdf"), null, Arrays.asList("brf"), null, true, true);
    public static final RDFFormat NQUADS = new RDFFormat("N-Quads", Arrays.asList("application/n-quads", "text/x-nquads", "text/nquads"), Charset.forName("UTF-8"), Arrays.asList("nq"), SimpleValueFactory.getInstance().createIRI("http://www.w3.org/ns/formats/N-Quads"), false, true);
    public static final RDFFormat JSONLD = new RDFFormat("JSON-LD", Arrays.asList("application/ld+json"), Charset.forName("UTF-8"), Arrays.asList("jsonld"), SimpleValueFactory.getInstance().createIRI("http://www.w3.org/ns/formats/JSON-LD"), true, true);
    public static final RDFFormat RDFJSON = new RDFFormat("RDF/JSON", Arrays.asList("application/rdf+json"), Charset.forName("UTF-8"), Arrays.asList("rj"), SimpleValueFactory.getInstance().createIRI("http://www.w3.org/ns/formats/RDF_JSON"), false, true);
    public static final RDFFormat RDFA = new RDFFormat("RDFa", Arrays.asList("application/xhtml+xml", "application/html", "text/html"), Charset.forName("UTF-8"), Arrays.asList("xhtml", "html"), SimpleValueFactory.getInstance().createIRI("http://www.w3.org/ns/formats/RDFa"), true, false);
    private final boolean supportsNamespaces;
    private final boolean supportsContexts;
    private IRI standardURI;

    public static List<String> getAcceptParams(Iterable<RDFFormat> rdfFormats, boolean requireContext, RDFFormat preferredFormat) {
        ArrayList<String> acceptParams = new ArrayList<String>();
        for (RDFFormat format : rdfFormats) {
            int qValue = 10;
            if (requireContext && !format.supportsContexts()) {
                qValue -= 5;
            }
            if (preferredFormat != null && !preferredFormat.equals((Object)format)) {
                qValue -= 2;
            }
            if (!format.supportsNamespaces()) {
                --qValue;
            }
            Iterator iterator = format.getMIMETypes().iterator();
            while (iterator.hasNext()) {
                String mimeType;
                String acceptParam = mimeType = (String)iterator.next();
                if (qValue < 10) {
                    acceptParam = acceptParam + ";q=0." + qValue;
                }
                acceptParams.add(acceptParam);
            }
        }
        return acceptParams;
    }

    public RDFFormat(String name, String mimeType, Charset charset, String fileExtension, boolean supportsNamespaces, boolean supportsContexts) {
        this(name, Arrays.asList(mimeType), charset, Arrays.asList(fileExtension), supportsNamespaces, supportsContexts);
    }

    public RDFFormat(String name, String mimeType, Charset charset, Collection<String> fileExtensions, boolean supportsNamespaces, boolean supportsContexts) {
        this(name, Arrays.asList(mimeType), charset, fileExtensions, supportsNamespaces, supportsContexts);
    }

    public RDFFormat(String name, Collection<String> mimeTypes, Charset charset, Collection<String> fileExtensions, boolean supportsNamespaces, boolean supportsContexts) {
        this(name, mimeTypes, charset, fileExtensions, null, supportsNamespaces, supportsContexts);
    }

    public RDFFormat(String name, Collection<String> mimeTypes, Charset charset, Collection<String> fileExtensions, IRI standardURI, boolean supportsNamespaces, boolean supportsContexts) {
        super(name, mimeTypes, charset, fileExtensions);
        this.standardURI = standardURI;
        this.supportsNamespaces = supportsNamespaces;
        this.supportsContexts = supportsContexts;
    }

    public boolean supportsNamespaces() {
        return this.supportsNamespaces;
    }

    public boolean supportsContexts() {
        return this.supportsContexts;
    }

    public boolean hasStandardURI() {
        return this.standardURI != null;
    }

    public IRI getStandardURI() {
        return this.standardURI;
    }
}

