/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio;

import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.rdf4j.rio.RioConfig;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.AbstractRioSetting;
import org.eclipse.rdf4j.rio.helpers.BooleanRioSetting;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class RioConfigTest {
    private RioConfig config;
    private String key = "org.eclipse.rdf4j.rio.rioconfig.test";
    private BooleanRioSetting testSetting = new BooleanRioSetting(this.key, "test setting", Boolean.valueOf(true));

    @Before
    public void setUp() throws Exception {
        this.config = new RioConfig();
    }

    @After
    public void cleanup() {
        System.clearProperty(this.key);
    }

    @Test
    public void testIsSetDefault() throws Exception {
        Assertions.assertThat((boolean)this.config.isSet((RioSetting)this.testSetting)).isFalse();
    }

    @Test
    public void testIsSetWithSystemPropertyOverride() throws Exception {
        System.setProperty(this.key, "false");
        Assertions.assertThat((boolean)this.config.isSet((RioSetting)this.testSetting)).isTrue();
    }

    @Test
    public void testIsSetWithExplicitSet() throws Exception {
        this.config.set((RioSetting)this.testSetting, (Object)false);
        Assertions.assertThat((boolean)this.config.isSet((RioSetting)this.testSetting)).isTrue();
    }

    @Test
    public void testUseDefaultsNoOverride() throws Exception {
        this.config.set((RioSetting)this.testSetting, (Object)false);
        this.config.useDefaults();
        Assertions.assertThat((boolean)this.config.isSet((RioSetting)this.testSetting)).isFalse();
    }

    @Test
    public void testUseDefaultsWithOverride() throws Exception {
        System.setProperty(this.key, "false");
        this.config.useDefaults();
        Assertions.assertThat((boolean)this.config.isSet((RioSetting)this.testSetting)).isTrue();
    }

    @Test
    public void testGetWithSystemPropertyOverride() throws Exception {
        System.setProperty(this.key, "false");
        ((AbstractBooleanAssert)Assertions.assertThat((Boolean)((Boolean)this.config.get((RioSetting)this.testSetting))).as("default setting overridden by system prop", new Object[0])).isFalse();
        this.config.set((RioSetting)this.testSetting, (Object)true);
        ((AbstractBooleanAssert)Assertions.assertThat((Boolean)((Boolean)this.config.get((RioSetting)this.testSetting))).as("explicit user-configured setting overriding system prop", new Object[0])).isTrue();
        this.config.useDefaults();
        ((AbstractBooleanAssert)Assertions.assertThat((Boolean)((Boolean)this.config.get((RioSetting)this.testSetting))).as("default setting overridden by sytem prop", new Object[0])).isFalse();
        System.clearProperty(this.key);
        ((AbstractBooleanAssert)Assertions.assertThat((Boolean)((Boolean)this.config.get((RioSetting)this.testSetting))).as("default setting overridden by system prop", new Object[0])).isFalse();
        this.config.useDefaults();
        ((AbstractBooleanAssert)Assertions.assertThat((Boolean)((Boolean)this.config.get((RioSetting)this.testSetting))).as("default setting", new Object[0])).isTrue();
    }

    @Test
    public void testGetWithUnsupportedConversionType() throws Exception {
        AbstractRioSetting<String> nonConvertableSetting = new AbstractRioSetting<String>(this.key, "test setting", "default value"){
            private static final long serialVersionUID = 1L;
        };
        Assertions.assertThat((String)((String)this.config.get((RioSetting)nonConvertableSetting))).isEqualTo((Object)"default value");
        System.setProperty(this.key, "system property value");
        Assertions.assertThat((String)((String)this.config.get((RioSetting)nonConvertableSetting))).isEqualTo((Object)"default value");
    }
}

