/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.helpers;

import java.io.IOException;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.DC;
import org.eclipse.rdf4j.rio.helpers.NTriplesUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NTriplesUtilTest {
    private StringBuilder appendable;
    private ValueFactory f = SimpleValueFactory.getInstance();

    @Before
    public void setUp() throws Exception {
        this.appendable = new StringBuilder();
    }

    @Test
    public void testAppendWithoutEncoding() throws Exception {
        Literal l = this.f.createLiteral("\u00c4bc");
        NTriplesUtil.append((Literal)l, (Appendable)this.appendable, (boolean)true, (boolean)false);
        Assertions.assertThat((String)this.appendable.toString()).isEqualTo((Object)"\"\u00c4bc\"");
    }

    @Test
    public void testAppendWithEncoding() throws Exception {
        Literal l = this.f.createLiteral("\u00c4bc");
        NTriplesUtil.append((Literal)l, (Appendable)this.appendable, (boolean)true, (boolean)true);
        Assertions.assertThat((String)this.appendable.toString()).isEqualTo((Object)"\"\\u00C4bc\"");
    }

    @Test
    public void testSerializeTriple() throws IOException {
        Object[] triples = new Object[]{this.f.createTriple((Resource)this.f.createIRI("urn:a"), this.f.createIRI("urn:b"), (Value)this.f.createIRI("urn:c")), "<<<urn:a> <urn:b> <urn:c>>>", this.f.createTriple((Resource)this.f.createTriple((Resource)this.f.createIRI("urn:a"), this.f.createIRI("urn:b"), (Value)this.f.createIRI("urn:c")), DC.SOURCE, (Value)this.f.createLiteral("news")), "<<<<<urn:a> <urn:b> <urn:c>>> <http://purl.org/dc/elements/1.1/source> \"news\">>", this.f.createTriple((Resource)this.f.createBNode("bnode1"), this.f.createIRI("urn:x"), (Value)this.f.createTriple((Resource)this.f.createIRI("urn:a"), this.f.createIRI("urn:b"), (Value)this.f.createIRI("urn:c"))), "<<_:bnode1 <urn:x> <<<urn:a> <urn:b> <urn:c>>>>>"};
        for (int i = 0; i < triples.length; i += 2) {
            Assert.assertEquals((Object)triples[i + 1], (Object)NTriplesUtil.toNTriplesString((Triple)((Triple)triples[i])));
            Assert.assertEquals((Object)triples[i + 1], (Object)NTriplesUtil.toNTriplesString((Resource)((Resource)triples[i])));
            Assert.assertEquals((Object)triples[i + 1], (Object)NTriplesUtil.toNTriplesString((Value)((Value)triples[i])));
            NTriplesUtil.append((Triple)((Triple)triples[i]), (Appendable)this.appendable);
            Assert.assertEquals((Object)triples[i + 1], (Object)this.appendable.toString());
            this.appendable = new StringBuilder();
            NTriplesUtil.append((Resource)((Resource)triples[i]), (Appendable)this.appendable);
            Assert.assertEquals((Object)triples[i + 1], (Object)this.appendable.toString());
            this.appendable = new StringBuilder();
            NTriplesUtil.append((Value)((Value)triples[i]), (Appendable)this.appendable);
            Assert.assertEquals((Object)triples[i + 1], (Object)this.appendable.toString());
            this.appendable = new StringBuilder();
        }
    }

    @Test
    public void testParseTriple() {
        String[] triples = new String[]{"<<<http://foo.com/bar#baz%20><http://example.com/test><<<urn:foo><urn:\\u0440>\"t\u00e4st\"@de-DE>>>>", "<<http://foo.com/bar#baz%20 http://example.com/test <<urn:foo urn:\u0440 \"t\u00e4st\"@de-DE>>>>", "<< <http://foo.com/bar#baz%20>  <http://example.com/test>  <<  <urn:foo>  <urn:\\u0440> \"t\u00e4st\"@de-DE  >>  >>", "<<http://foo.com/bar#baz%20 http://example.com/test <<urn:foo urn:\u0440 \"t\u00e4st\"@de-DE>>>>", "<<<<_:bnode1foobar<urn:t\u00e4st>\"liter\u00e1l \u0437\u0430 \u043f\u0440\u043e\u0431\u0430\"^^<urn:test\\u0444\\U00000444>>><http://test/baz>\"test\\\\\\\"lit\">>", "<<<<_:bnode1foobar urn:t\u00e4st \"liter\u00e1l \u0437\u0430 \u043f\u0440\u043e\u0431\u0430\"^^<urn:test\u0444\u0444>>> http://test/baz \"test\\\"lit\">>", "<<  <<_:bnode1foobar<urn:t\u00e4st> \"liter\u00e1l \u0437\u0430 \u043f\u0440\u043e\u0431\u0430\"^^<urn:test\\u0444\\U00000444>  >>  <http://test/baz> \"test\\\\\\\"lit\" >>", "<<<<_:bnode1foobar urn:t\u00e4st \"liter\u00e1l \u0437\u0430 \u043f\u0440\u043e\u0431\u0430\"^^<urn:test\u0444\u0444>>> http://test/baz \"test\\\"lit\">>", "<<_:test_\ud800\udc00_\ud840\udc00_bnode <urn:x> <urn:y>>>", "<<_:test_\ud800\udc00_\ud840\udc00_bnode urn:x urn:y>>", "<<<<_:bnode1foobar<urn:t\u00e4st>\"liter\u00e1l \u0437\u0430 \u043f\u0440\u043e\u0431\u0430\"^^<urn:test\\u0444\\U00000444><http://test/baz>\"test\\\\\\\"lit\">>", null, "<<<<_:bnode1foobar<urn:t\u00e4st>\"liter\u00e1l \u0437\u0430 \u043f\u0440\u043e\u0431\u0430\"^^<urn:test\\u0444\\U00000444>>><http://test/baz>\"test\\\\\\\"lit\"", null, "<<\"test\" <urn:test> \"test\">>", null, "<<<urn:test> _:test \"test\">>", null, "<<<urn:a> <<<urn:1> <urn:2> <urn:3>>> <urn:b>>>", null};
        for (int i = 0; i < triples.length; i += 2) {
            this.parseTriple(triples[i], triples[i + 1], t -> NTriplesUtil.parseTriple((String)t, (ValueFactory)this.f));
            this.parseTriple(triples[i], triples[i + 1], t -> (Triple)NTriplesUtil.parseValue((String)t, (ValueFactory)this.f));
            this.parseTriple(triples[i], triples[i + 1], t -> (Triple)NTriplesUtil.parseResource((String)t, (ValueFactory)this.f));
        }
    }

    private void parseTriple(String triple, String expected, Function<String, Triple> parser) {
        block2: {
            try {
                Triple t = parser.apply(triple);
                Assert.assertEquals((Object)expected, (Object)t.stringValue());
            }
            catch (IllegalArgumentException e) {
                if (expected == null) break block2;
                Assert.fail((String)("Unexpected exception for valid triple: " + triple));
            }
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseIRIvsTriple() {
        NTriplesUtil.parseURI((String)"<<<urn:a><urn:b><urn:c>>>", (ValueFactory)this.f);
    }
}

