/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.helpers;

import java.util.Collections;
import java.util.HashSet;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.rio.ParseErrorListener;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.eclipse.rdf4j.rio.helpers.ParseErrorCollector;
import org.eclipse.rdf4j.rio.helpers.RDFParserHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class RDFParserHelperTest {
    private static final String TEST_MESSAGE_FOR_FAILURE = "Test message for failure.";
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private static final String LABEL_TESTA = "test-a";
    private static final String LANG_EN = "en";
    private ParserConfig parserConfig;
    private ParseErrorCollector errListener;
    private ValueFactory valueFactory;

    @Before
    public void setUp() throws Exception {
        this.parserConfig = new ParserConfig();
        this.parserConfig.set(BasicParserSettings.DATATYPE_HANDLERS, Collections.emptyList());
        this.parserConfig.set(BasicParserSettings.LANGUAGE_HANDLERS, Collections.emptyList());
        this.parserConfig.setNonFatalErrors(new HashSet());
        this.errListener = new ParseErrorCollector();
        this.valueFactory = SimpleValueFactory.getInstance();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public final void testCreateLiteralLabelNull() throws Exception {
        this.thrown.expect(NullPointerException.class);
        this.thrown.expectMessage("Cannot create a literal using a null label");
        RDFParserHelper.createLiteral(null, null, null, (ParserConfig)this.parserConfig, (ParseErrorListener)this.errListener, (ValueFactory)this.valueFactory);
    }

    @Test
    public final void testCreateLiteralLabelOnly() throws Exception {
        Literal literal = RDFParserHelper.createLiteral((String)LABEL_TESTA, null, null, (ParserConfig)this.parserConfig, (ParseErrorListener)this.errListener, (ValueFactory)this.valueFactory);
        Assert.assertEquals((Object)LABEL_TESTA, (Object)literal.getLabel());
        Assert.assertFalse((boolean)literal.getLanguage().isPresent());
        Assert.assertEquals((Object)XSD.STRING, (Object)literal.getDatatype());
    }

    @Test
    public final void testCreateLiteralLabelAndLanguage() throws Exception {
        Literal literal = RDFParserHelper.createLiteral((String)LABEL_TESTA, (String)LANG_EN, null, (ParserConfig)this.parserConfig, (ParseErrorListener)this.errListener, (ValueFactory)this.valueFactory);
        Assert.assertEquals((Object)LABEL_TESTA, (Object)literal.getLabel());
        Assert.assertEquals((Object)LANG_EN, literal.getLanguage().orElse(null));
        Assert.assertEquals((Object)RDF.LANGSTRING, (Object)literal.getDatatype());
    }

    @Test
    public final void testCreateLiteralLabelAndDatatype() throws Exception {
        Literal literal = RDFParserHelper.createLiteral((String)LABEL_TESTA, null, (IRI)XSD.STRING, (ParserConfig)this.parserConfig, (ParseErrorListener)this.errListener, (ValueFactory)this.valueFactory);
        Assert.assertEquals((Object)LABEL_TESTA, (Object)literal.getLabel());
        Assert.assertFalse((boolean)literal.getLanguage().isPresent());
        Assert.assertEquals((Object)XSD.STRING, (Object)literal.getDatatype());
    }

    @Test
    public final void testCreateLiteralLabelAndLanguageWithRDFLangString() throws Exception {
        Literal literal = RDFParserHelper.createLiteral((String)LABEL_TESTA, (String)LANG_EN, (IRI)RDF.LANGSTRING, (ParserConfig)this.parserConfig, (ParseErrorListener)this.errListener, (ValueFactory)this.valueFactory);
        Assert.assertEquals((Object)LABEL_TESTA, (Object)literal.getLabel());
        Assert.assertEquals((Object)LANG_EN, literal.getLanguage().orElse(null));
        Assert.assertEquals((Object)RDF.LANGSTRING, (Object)literal.getDatatype());
    }

    @Test
    public final void testCreateLiteralLabelNoLanguageWithRDFLangStringWithVerify() throws Exception {
        this.parserConfig.set(BasicParserSettings.VERIFY_DATATYPE_VALUES, (Object)true);
        Assert.assertTrue((boolean)((Boolean)this.parserConfig.get(BasicParserSettings.VERIFY_DATATYPE_VALUES)));
        this.thrown.expect(RDFParseException.class);
        RDFParserHelper.createLiteral((String)LABEL_TESTA, null, (IRI)RDF.LANGSTRING, (ParserConfig)this.parserConfig, (ParseErrorListener)this.errListener, (ValueFactory)this.valueFactory);
    }

    @Test
    public final void testCreateLiteralLabelNoLanguageWithRDFLangStringWithNoVerify() throws Exception {
        this.parserConfig.set(BasicParserSettings.VERIFY_DATATYPE_VALUES, (Object)false);
        Literal literal = RDFParserHelper.createLiteral((String)LABEL_TESTA, null, (IRI)RDF.LANGSTRING, (ParserConfig)this.parserConfig, (ParseErrorListener)this.errListener, (ValueFactory)this.valueFactory);
        Assert.assertFalse((boolean)literal.getLanguage().isPresent());
        Assert.assertEquals((Object)XSD.STRING, (Object)literal.getDatatype());
    }

    @Test
    public final void testReportErrorStringFatalActive() throws Exception {
        this.parserConfig.set(BasicParserSettings.VERIFY_DATATYPE_VALUES, (Object)true);
        Assert.assertTrue((boolean)((Boolean)this.parserConfig.get(BasicParserSettings.VERIFY_DATATYPE_VALUES)));
        this.thrown.expect(RDFParseException.class);
        this.thrown.expectMessage(TEST_MESSAGE_FOR_FAILURE);
        try {
            RDFParserHelper.reportError((String)TEST_MESSAGE_FOR_FAILURE, (RioSetting)BasicParserSettings.VERIFY_DATATYPE_VALUES, (ParserConfig)this.parserConfig, (ParseErrorListener)this.errListener);
        }
        finally {
            this.assertErrorListener(0, 1, 0);
        }
    }

    @Test
    public final void testReportErrorStringNonFatalActive() throws Exception {
        this.parserConfig.set(BasicParserSettings.VERIFY_DATATYPE_VALUES, (Object)true);
        Assert.assertTrue((boolean)((Boolean)this.parserConfig.get(BasicParserSettings.VERIFY_DATATYPE_VALUES)));
        this.parserConfig.addNonFatalError(BasicParserSettings.VERIFY_DATATYPE_VALUES);
        RDFParserHelper.reportError((String)TEST_MESSAGE_FOR_FAILURE, (RioSetting)BasicParserSettings.VERIFY_DATATYPE_VALUES, (ParserConfig)this.parserConfig, (ParseErrorListener)this.errListener);
        this.assertErrorListener(0, 1, 0);
    }

    @Test
    public final void testReportErrorStringFatalInactive() throws Exception {
        Assert.assertFalse((boolean)((Boolean)this.parserConfig.get(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES)));
        RDFParserHelper.reportError((String)TEST_MESSAGE_FOR_FAILURE, (RioSetting)BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, (ParserConfig)this.parserConfig, (ParseErrorListener)this.errListener);
        this.assertErrorListener(0, 0, 0);
    }

    @Test
    public final void testReportErrorStringNonFatalInactive() throws Exception {
        Assert.assertFalse((boolean)((Boolean)this.parserConfig.get(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES)));
        this.parserConfig.addNonFatalError(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES);
        RDFParserHelper.reportError((String)TEST_MESSAGE_FOR_FAILURE, (RioSetting)BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, (ParserConfig)this.parserConfig, (ParseErrorListener)this.errListener);
        this.assertErrorListener(0, 0, 0);
    }

    @Test
    public final void testReportErrorStringIntIntFatalActive() throws Exception {
        this.parserConfig.set(BasicParserSettings.VERIFY_DATATYPE_VALUES, (Object)true);
        Assert.assertTrue((boolean)((Boolean)this.parserConfig.get(BasicParserSettings.VERIFY_DATATYPE_VALUES)));
        this.thrown.expect(RDFParseException.class);
        this.thrown.expectMessage(TEST_MESSAGE_FOR_FAILURE);
        try {
            RDFParserHelper.reportError((String)TEST_MESSAGE_FOR_FAILURE, (long)1L, (long)1L, (RioSetting)BasicParserSettings.VERIFY_DATATYPE_VALUES, (ParserConfig)this.parserConfig, (ParseErrorListener)this.errListener);
        }
        finally {
            this.assertErrorListener(0, 1, 0);
        }
    }

    @Test
    public final void testReportErrorStringIntIntNonFatalActive() throws Exception {
        this.parserConfig.set(BasicParserSettings.VERIFY_DATATYPE_VALUES, (Object)true);
        Assert.assertTrue((boolean)((Boolean)this.parserConfig.get(BasicParserSettings.VERIFY_DATATYPE_VALUES)));
        this.parserConfig.addNonFatalError(BasicParserSettings.VERIFY_DATATYPE_VALUES);
        RDFParserHelper.reportError((String)TEST_MESSAGE_FOR_FAILURE, (long)1L, (long)1L, (RioSetting)BasicParserSettings.VERIFY_DATATYPE_VALUES, (ParserConfig)this.parserConfig, (ParseErrorListener)this.errListener);
        this.assertErrorListener(0, 1, 0);
    }

    @Test
    public final void testReportErrorStringIntIntFatalInactive() throws Exception {
        Assert.assertFalse((boolean)((Boolean)this.parserConfig.get(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES)));
        RDFParserHelper.reportError((String)TEST_MESSAGE_FOR_FAILURE, (long)1L, (long)1L, (RioSetting)BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, (ParserConfig)this.parserConfig, (ParseErrorListener)this.errListener);
        this.assertErrorListener(0, 0, 0);
    }

    @Test
    public final void testReportErrorStringIntIntNonFatalInactive() throws Exception {
        Assert.assertFalse((boolean)((Boolean)this.parserConfig.get(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES)));
        this.parserConfig.addNonFatalError(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES);
        RDFParserHelper.reportError((String)TEST_MESSAGE_FOR_FAILURE, (long)1L, (long)1L, (RioSetting)BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, (ParserConfig)this.parserConfig, (ParseErrorListener)this.errListener);
        this.assertErrorListener(0, 0, 0);
    }

    @Ignore
    @Test
    public final void testReportErrorExceptionIntInt() throws Exception {
        Assert.fail((String)"Not yet implemented");
    }

    @Ignore
    @Test
    public final void testReportFatalErrorString() throws Exception {
        Assert.fail((String)"Not yet implemented");
    }

    @Ignore
    @Test
    public final void testReportFatalErrorStringIntInt() throws Exception {
        Assert.fail((String)"Not yet implemented");
    }

    @Ignore
    @Test
    public final void testReportFatalErrorException() throws Exception {
        Assert.fail((String)"Not yet implemented");
    }

    @Ignore
    @Test
    public final void testReportFatalErrorExceptionIntInt() throws Exception {
        Assert.fail((String)"Not yet implemented");
    }

    private void assertErrorListener(int fatalErrors, int errors, int warnings) {
        Assert.assertEquals((long)fatalErrors, (long)this.errListener.getFatalErrors().size());
        Assert.assertEquals((long)errors, (long)this.errListener.getErrors().size());
        Assert.assertEquals((long)warnings, (long)this.errListener.getWarnings().size());
    }
}

