/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio;

import java.io.InputStream;
import org.assertj.core.api.Assertions;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.RDFParserFactory;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.junit.Test;

public abstract class BaseURIHandlingTest {
    @Test
    public void testParseWithoutBaseUri_Absolute() throws Exception {
        StatementCollector collector = new StatementCollector();
        RDFParser parser = this.getParserFactory().getParser();
        parser.setRDFHandler((RDFHandler)collector);
        parser.parse(this.getDataWithAbsoluteIris());
        Assertions.assertThat((Iterable)collector.getStatements()).isNotEmpty();
    }

    @Test(expected=RDFParseException.class)
    public void testParseWithoutBaseUri_Relative() throws Exception {
        StatementCollector collector = new StatementCollector();
        RDFParser parser = this.getParserFactory().getParser();
        parser.setRDFHandler((RDFHandler)collector);
        parser.parse(this.getDataWithRelativeIris());
    }

    @Test
    public void testParseWithoutBaseUri_Relative_InternalBase() throws Exception {
        StatementCollector collector = new StatementCollector();
        RDFParser parser = this.getParserFactory().getParser();
        parser.setRDFHandler((RDFHandler)collector);
        parser.parse(this.getDataWithRelativeIris_InternalBase());
        Assertions.assertThat((Iterable)collector.getStatements()).isNotEmpty();
    }

    @Test
    public void testParseWithBaseUri_Relative_InternalBase() throws Exception {
        StatementCollector collector = new StatementCollector();
        String baseURI = "http://example.org/custom-supplied";
        RDFParser parser = this.getParserFactory().getParser();
        parser.setRDFHandler((RDFHandler)collector);
        parser.parse(this.getDataWithRelativeIris_InternalBase(), baseURI);
        Assertions.assertThat((Iterable)collector.getStatements()).isNotEmpty();
        Assertions.assertThat((Iterable)collector.getStatements()).noneMatch(st -> st.getSubject().stringValue().startsWith(baseURI) || st.getPredicate().stringValue().startsWith(baseURI) || st.getObject().stringValue().startsWith(baseURI));
    }

    @Test
    public void testParseWithBaseUri_Relative() throws Exception {
        StatementCollector collector = new StatementCollector();
        RDFParser parser = this.getParserFactory().getParser();
        parser.setRDFHandler((RDFHandler)collector);
        parser.parse(this.getDataWithRelativeIris(), "http://example.org/");
        Assertions.assertThat((Iterable)collector.getStatements()).isNotEmpty();
    }

    protected abstract RDFParserFactory getParserFactory();

    protected abstract InputStream getDataWithAbsoluteIris();

    protected abstract InputStream getDataWithRelativeIris();

    protected abstract InputStream getDataWithRelativeIris_InternalBase();
}

