/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.helpers;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFParser;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AbstractRDFParserTest {
    private MyRDFParser parser;

    @Before
    public void setUp() throws Exception {
        this.parser = new MyRDFParser();
    }

    @Test
    public void testSkolemOrigin() throws Exception {
        this.parser.getParserConfig().set(BasicParserSettings.SKOLEMIZE_ORIGIN, (Object)"http://www.example.com");
        Assert.assertTrue((boolean)this.parser.getBNode().toString().startsWith("http://www.example.com"));
        Assert.assertTrue((boolean)this.parser.getBNode("12").toString().startsWith("http://www.example.com"));
    }

    @Test
    public void testSkolemOriginReset() throws Exception {
        this.parser.getParserConfig().set(BasicParserSettings.SKOLEMIZE_ORIGIN, (Object)"http://www.example.com");
        this.parser.getParserConfig().set(BasicParserSettings.SKOLEMIZE_ORIGIN, (Object)"");
        Assert.assertFalse((boolean)this.parser.getBNode().toString().startsWith("http://www.example.com"));
        Assert.assertTrue((boolean)this.parser.getBNode().toString().startsWith("_"));
        Assert.assertTrue((boolean)this.parser.getBNode("12").toString().endsWith("12"));
    }

    private class MyRDFParser
    extends AbstractRDFParser {
        private MyRDFParser() {
        }

        public RDFFormat getRDFFormat() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void parse(InputStream in, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void parse(Reader reader, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Resource getBNode() {
            return this.createNode();
        }

        public Resource getBNode(String id) {
            return this.createNode(id);
        }
    }
}

