/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.helpers;

import org.assertj.core.api.Assertions;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.BooleanRioSetting;
import org.eclipse.rdf4j.rio.helpers.RioSettingTest;
import org.junit.Ignore;
import org.junit.Test;

public class BooleanRioSettingTest
extends RioSettingTest<Boolean> {
    @Override
    @Test
    @Ignore
    public void testConvertIllegal() throws Exception {
    }

    @Test
    public void testConvertLegalStringVariants() throws Exception {
        Assertions.assertThat((Boolean)((Boolean)this.subject.convert("True"))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)this.subject.convert("Foo"))).isFalse();
        Assertions.assertThat((Boolean)((Boolean)this.subject.convert("false"))).isFalse();
        Assertions.assertThat((Boolean)((Boolean)this.subject.convert("1"))).isFalse();
    }

    @Override
    protected Boolean getDefaultValue() {
        return true;
    }

    @Override
    protected String getLegalStringValue() {
        return "TRUE";
    }

    @Override
    protected Boolean getConvertedStringValue() {
        return true;
    }

    @Override
    protected String getIllegalStringValue() {
        throw new UnsupportedOperationException("no illegal value exists for boolean-type conversion");
    }

    @Override
    protected RioSetting<Boolean> createRioSetting(String key, String description, Boolean defaultValue) {
        return new BooleanRioSetting(key, description, defaultValue);
    }
}

