/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.helpers;

import java.io.IOException;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.DC;
import org.eclipse.rdf4j.rio.helpers.NTriplesUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NTriplesUtilTest {
    private StringBuilder appendable;
    private ValueFactory f = SimpleValueFactory.getInstance();

    @Before
    public void setUp() throws Exception {
        this.appendable = new StringBuilder();
    }

    @Test
    public void testAppendWithoutEncoding() throws Exception {
        Literal l = this.f.createLiteral("\u00c4bc");
        NTriplesUtil.append((Literal)l, (Appendable)this.appendable, (boolean)true, (boolean)false);
        Assertions.assertThat((String)this.appendable.toString()).isEqualTo("\"\u00c4bc\"");
    }

    @Test
    public void testAppendWithEncoding() throws Exception {
        Literal l = this.f.createLiteral("\u00c4bc");
        NTriplesUtil.append((Literal)l, (Appendable)this.appendable, (boolean)true, (boolean)true);
        Assertions.assertThat((String)this.appendable.toString()).isEqualTo("\"\\u00C4bc\"");
    }

    @Test
    public void testSerializeTriple() throws IOException {
        Object[] triples = new Object[]{this.f.createTriple((Resource)this.f.createIRI("urn:a"), this.f.createIRI("urn:b"), (Value)this.f.createIRI("urn:c")), "<<<urn:a> <urn:b> <urn:c>>>", this.f.createTriple((Resource)this.f.createTriple((Resource)this.f.createIRI("urn:a"), this.f.createIRI("urn:b"), (Value)this.f.createIRI("urn:c")), DC.SOURCE, (Value)this.f.createLiteral("news")), "<<<<<urn:a> <urn:b> <urn:c>>> <http://purl.org/dc/elements/1.1/source> \"news\">>", this.f.createTriple((Resource)this.f.createBNode("bnode1"), this.f.createIRI("urn:x"), (Value)this.f.createTriple((Resource)this.f.createIRI("urn:a"), this.f.createIRI("urn:b"), (Value)this.f.createIRI("urn:c"))), "<<_:bnode1 <urn:x> <<<urn:a> <urn:b> <urn:c>>>>>"};
        for (int i = 0; i < triples.length; i += 2) {
            Assert.assertEquals((Object)triples[i + 1], (Object)NTriplesUtil.toNTriplesString((Triple)((Triple)triples[i])));
            Assert.assertEquals((Object)triples[i + 1], (Object)NTriplesUtil.toNTriplesString((Resource)((Resource)triples[i])));
            Assert.assertEquals((Object)triples[i + 1], (Object)NTriplesUtil.toNTriplesString((Value)((Value)triples[i])));
            NTriplesUtil.append((Triple)((Triple)triples[i]), (Appendable)this.appendable);
            Assert.assertEquals((Object)triples[i + 1], (Object)this.appendable.toString());
            this.appendable = new StringBuilder();
            NTriplesUtil.append((Resource)((Resource)triples[i]), (Appendable)this.appendable);
            Assert.assertEquals((Object)triples[i + 1], (Object)this.appendable.toString());
            this.appendable = new StringBuilder();
            NTriplesUtil.append((Value)((Value)triples[i]), (Appendable)this.appendable);
            Assert.assertEquals((Object)triples[i + 1], (Object)this.appendable.toString());
            this.appendable = new StringBuilder();
        }
    }

    @Test
    public void testParseTriple() {
        String[] triples = new String[]{"<<<http://foo.com/bar#baz%20><http://example.com/test><<<urn:foo><urn:\\u0440>\"t\u00e4st\"@de-DE>>>>", "<<http://foo.com/bar#baz%20 http://example.com/test <<urn:foo urn:\u0440 \"t\u00e4st\"@de-DE>>>>", "<< <http://foo.com/bar#baz%20>  <http://example.com/test>  <<  <urn:foo>  <urn:\\u0440> \"t\u00e4st\"@de-DE  >>  >>", "<<http://foo.com/bar#baz%20 http://example.com/test <<urn:foo urn:\u0440 \"t\u00e4st\"@de-DE>>>>", "<<<<_:bnode1foobar<urn:t\u00e4st>\"liter\u00e1l \u0437\u0430 \u043f\u0440\u043e\u0431\u0430\"^^<urn:test\\u0444\\U00000444>>><http://test/baz>\"test\\\\\\\"lit\">>", "<<<<_:bnode1foobar urn:t\u00e4st \"liter\u00e1l \u0437\u0430 \u043f\u0440\u043e\u0431\u0430\"^^<urn:test\u0444\u0444>>> http://test/baz \"test\\\"lit\">>", "<<  <<_:bnode1foobar<urn:t\u00e4st> \"liter\u00e1l \u0437\u0430 \u043f\u0440\u043e\u0431\u0430\"^^<urn:test\\u0444\\U00000444>  >>  <http://test/baz> \"test\\\\\\\"lit\" >>", "<<<<_:bnode1foobar urn:t\u00e4st \"liter\u00e1l \u0437\u0430 \u043f\u0440\u043e\u0431\u0430\"^^<urn:test\u0444\u0444>>> http://test/baz \"test\\\"lit\">>", "<<_:test_\ud800\udc00_\ud840\udc00_bnode <urn:x> <urn:y>>>", "<<_:test_\ud800\udc00_\ud840\udc00_bnode urn:x urn:y>>", "<<<<_:bnode1foobar<urn:t\u00e4st>\"liter\u00e1l \u0437\u0430 \u043f\u0440\u043e\u0431\u0430\"^^<urn:test\\u0444\\U00000444><http://test/baz>\"test\\\\\\\"lit\">>", null, "<<<<_:bnode1foobar<urn:t\u00e4st>\"liter\u00e1l \u0437\u0430 \u043f\u0440\u043e\u0431\u0430\"^^<urn:test\\u0444\\U00000444>>><http://test/baz>\"test\\\\\\\"lit\"", null, "<<\"test\" <urn:test> \"test\">>", null, "<<<urn:test> _:test \"test\">>", null, "<<<urn:a> <<<urn:1> <urn:2> <urn:3>>> <urn:b>>>", null, "<<<urn:1> <urn:2> \"\">>", "<<urn:1 urn:2 \"\">>", "<<<urn:1> <urn:2> \"\"@bg>>", "<<urn:1 urn:2 \"\"@bg>>", "<<<urn:1> <urn:2> \"\"^^<urn:type>>>", "<<urn:1 urn:2 \"\"^^<urn:type>>>"};
        for (int i = 0; i < triples.length; i += 2) {
            this.parseTriple(triples[i], triples[i + 1], t -> NTriplesUtil.parseTriple((String)t, (ValueFactory)this.f));
            this.parseTriple(triples[i], triples[i + 1], t -> (Triple)NTriplesUtil.parseValue((String)t, (ValueFactory)this.f));
            this.parseTriple(triples[i], triples[i + 1], t -> (Triple)NTriplesUtil.parseResource((String)t, (ValueFactory)this.f));
        }
    }

    private void parseTriple(String triple, String expected, Function<String, Triple> parser) {
        block2: {
            try {
                Triple t = parser.apply(triple);
                Assert.assertEquals((Object)expected, (Object)t.stringValue());
            }
            catch (IllegalArgumentException e) {
                if (expected == null) break block2;
                Assert.fail((String)("Unexpected exception for valid triple: " + triple));
            }
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseIRIvsTriple() {
        NTriplesUtil.parseURI((String)"<<<urn:a><urn:b><urn:c>>>", (ValueFactory)this.f);
    }

    @Test
    public void testGH3323Stackoverflow() {
        String badLiteral = "<<<urn:1> <urn:2> \"Ko te kamupene  S.L., he kamupene i whakapumautia i te tau 2009 a i whakatapua ki nga kaupapa korero mo etahi atu kamupene, mai i te 2012 i tiimata te hanga i ona ake hangarau a kua poipoihia e te mahi tahi me nga hinonga a iwi. Ina koa, ko te mahi tahi me te Manat\u016b o te Roto o Spain te mea nui, i runga i te ngana ki te whakawhanake i nga otinga hangarau motuhake e haangai ana ki nga hiahia o nga Hoia Haumaru o te Kawanatanga o Paniora i nga waahi o nga drones me nga anti-drones. te hononga i waenga i te trga me te Manatu o roto i te mana i roto i nga tau e 8 kua hipa kua kitea i roto i nga waahanga nui e rua: i tetahi taha, ko te tautoko a te Minita ki te maha o nga kaupapa R&D i hangaia e AEORUM me te tahua tahua me te iwi whanui. moni; a, i tetahi atu, ko te mahi tahi nui a te Hekeretari o te Whenua mo te Haumarutanga i te wa e whanakehia ana te punaha  me . He kamupene hangarau-hangarau e whakarato ana i nga otinga aunoa mo nga pokapu whakahaere me nga waka kaore he tangata, he nui te utu ki nga waahi e hiahia ana kia mamao te whakahaere me te mohio. Mo tenei, ka whakamahia e ia tana ake R&D i roto i nga waahanga o te tirohanga matakite (kitenga / mohio / taatari i nga taiao me nga tauira), te whakahaere waka (whakahaere aunoa me te mohio o nga waka rererangi robotic me nga tauira) me te mohio mohio. Ko te kaupapa uara o te , SL, e whaaia ana mo te hunga e ahuru ana i te ahuru, ko te whakarato i nga taputapu tirotiro hou kia aukati, kia tere, kia tika hoki te whakatau i nga ahuatanga uaua, kia pai ake ai te whakahaere i te ahuru me te karo i nga ahuatanga ohorere. Ko nga punaha i whakawhanakehia i roto i nga whare taiwhanga o , S.L., ka taea te whakamahi i enei waahanga e whai ake nei: \u00b7 Te Tiakitanga me te Whakahaumaru i nga Hanganga Hanga. \u00b7 Haumarutanga: he rongoa mo te whakahaere, tirotiro me te tirotiro aunoa i nga whakahaerenga ture, hei awhina i te whanuitanga o nga ahuatanga. \u00b7 Whakahaerenga ohorere, mo nga rongoa taangata me nga hoia: nga taputapu hei tirotiro mo te waa-tuuturu o nga rohe e pa ana me nga punaha mohio hei awhina i nga mahi whakatau. \u00b7 Nga Taone Tino me etahi atu whakauru: otinga aunoa hei whakapai ake i te whakahaerenga o te taiao i nga taone, nga tuawhenua me nga rohe takutai (te whakahaere waka, te taiao, nga whare, te whakahaere ururua, te tiaki ...) SL, he ake hangarau hei whirihora i te maha o nga rongoa, ka taea te urutau ki nga hiahia motuhake o ona kaihoko: te rapu me te waahi o nga taangata, te tiaki me nga hanganga whakahirahira, te aukati ahi, te tirotiro i nga taiao taone, te waahi o nga mahi koretake i nga whare / umanga, me era atu. Ko nga hangarau e whai ake nei me whakanui: \u00b7 : Te Whakawhanake i tetahi Punaha Korero Maatauranga mo te Whakahaere me te Whakahaumaru i nga Hanganga Critical. \u00b7 : Te Whakawhanake i te punaha Paanui mo te Kimi me te Whakakore i nga tuma me nga . \u00b7 :   , me te mahi tahi me te tari Irirangi o te Awhina. \u00b7 : Te Whakawhanake i te Punaha Whakatutukitanga Ar\u0101 Atu An\u014d mo te Whakaaetanga i nga Whakanui Taone me nga Hanga Tino, me te mahi tahi me nga pirihimana pirihimana e ono. I te taumata o te ao (kei waho o te fg), kei te tuu a   S.L. ki etahi kaupapa rereke me nga hoa hangarau, whakaaweawe i nga roopu me nga roopu whanui i nga whenua penei i te ,  ko nga \">>";
        NTriplesUtil.parseTriple((String)badLiteral, (ValueFactory)SimpleValueFactory.getInstance());
    }
}

