/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.helpers;

import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.rio.helpers.RDFStarUtil;
import org.junit.Assert;
import org.junit.Test;

public class RDFStarUtilTest {
    private ValueFactory vf = SimpleValueFactory.getInstance();

    @Test
    public void testEncoding() {
        IRI iri = this.vf.createIRI("urn:a");
        Assert.assertSame((Object)iri, (Object)RDFStarUtil.toRDFEncodedValue((Value)iri));
        Assert.assertFalse((boolean)RDFStarUtil.isEncodedTriple((Value)iri));
        Literal literal1 = this.vf.createLiteral("plain");
        Assert.assertSame((Object)literal1, (Object)RDFStarUtil.toRDFEncodedValue((Value)literal1));
        Assert.assertFalse((boolean)RDFStarUtil.isEncodedTriple((Value)literal1));
        Literal literal2 = this.vf.createLiteral(1984L);
        Assert.assertSame((Object)literal2, (Object)RDFStarUtil.toRDFEncodedValue((Value)literal2));
        Assert.assertFalse((boolean)RDFStarUtil.isEncodedTriple((Value)literal2));
        Literal literal3 = this.vf.createLiteral("einfach aber auf deutsch", "de");
        Assert.assertSame((Object)literal3, (Object)RDFStarUtil.toRDFEncodedValue((Value)literal3));
        Assert.assertFalse((boolean)RDFStarUtil.isEncodedTriple((Value)literal3));
        BNode bNode = this.vf.createBNode("bnode1");
        Assert.assertSame((Object)bNode, (Object)RDFStarUtil.toRDFEncodedValue((Value)bNode));
        Assert.assertFalse((boolean)RDFStarUtil.isEncodedTriple((Value)bNode));
        Triple triple = this.vf.createTriple((Resource)iri, RDF.TYPE, (Value)literal1);
        Assert.assertEquals((Object)this.vf.createIRI("urn:rdf4j:triple:PDw8dXJuOmE-IDxodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjdHlwZT4gInBsYWluIj4-"), (Object)RDFStarUtil.toRDFEncodedValue((Value)triple));
        Assert.assertFalse((boolean)RDFStarUtil.isEncodedTriple((Value)triple));
        Assert.assertTrue((boolean)RDFStarUtil.isEncodedTriple((Value)RDFStarUtil.toRDFEncodedValue((Value)triple)));
    }

    @Test
    public void testDecoding() {
        IRI iri = this.vf.createIRI("urn:a");
        Assert.assertSame((Object)iri, (Object)RDFStarUtil.fromRDFEncodedValue((Value)iri));
        Literal literal1 = this.vf.createLiteral("plain");
        Assert.assertSame((Object)literal1, (Object)RDFStarUtil.fromRDFEncodedValue((Value)literal1));
        Assert.assertFalse((boolean)RDFStarUtil.isEncodedTriple((Value)literal1));
        Literal literal2 = this.vf.createLiteral(1984L);
        Assert.assertSame((Object)literal2, (Object)RDFStarUtil.fromRDFEncodedValue((Value)literal2));
        Literal literal3 = this.vf.createLiteral("einfach aber auf deutsch", "de");
        Assert.assertSame((Object)literal3, (Object)RDFStarUtil.fromRDFEncodedValue((Value)literal3));
        Assert.assertFalse((boolean)RDFStarUtil.isEncodedTriple((Value)literal3));
        BNode bNode = this.vf.createBNode("bnode1");
        Assert.assertSame((Object)bNode, (Object)RDFStarUtil.fromRDFEncodedValue((Value)bNode));
        IRI encoded = this.vf.createIRI("urn:rdf4j:triple:PDw8dXJuOmE-IDxodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjdHlwZT4gInBsYWluIj4-");
        Value decoded = RDFStarUtil.fromRDFEncodedValue((Value)encoded);
        Assert.assertTrue((boolean)(decoded instanceof Triple));
        Assert.assertEquals((Object)iri, (Object)((Triple)decoded).getSubject());
        Assert.assertEquals((Object)RDF.TYPE, (Object)((Triple)decoded).getPredicate());
        Assert.assertEquals((Object)literal1, (Object)((Triple)decoded).getObject());
    }

    @Test
    public void testInvalidEncodedValue() {
        IRI[] invalidValues;
        for (IRI invalidValue : invalidValues = new IRI[]{this.vf.createIRI("urn:rdf4j:triple:"), this.vf.createIRI("urn:rdf4j:triple:foo"), this.vf.createIRI("urn:rdf4j:triple:\u043a\u0438\u0440\u0438\u043b\u0438\u0446\u0430"), this.vf.createIRI("urn:rdf4j:triple:PDw8dXJuOmE-"), this.vf.createIRI("urn:rdf4j:triple:PDw8dXJuOmE-IDxodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjdHlwZT4gInBsYWluIj4"), this.vf.createIRI("urn:rdf4j:triple:PDw8dXJuOmE-IDxodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjdHlwZT4gInBsYWluIj4-x")}) {
            Assert.assertTrue((boolean)RDFStarUtil.isEncodedTriple((Value)invalidValue));
            try {
                RDFStarUtil.fromRDFEncodedValue((Value)invalidValue);
                Assert.fail((String)"Must fail because of invalid value");
            }
            catch (IllegalArgumentException e) {
                Assert.assertTrue((boolean)e.getMessage().startsWith("Invalid RDF-star encoded triple"));
            }
        }
    }
}

