/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.helpers;

import org.assertj.core.api.Assertions;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.RioConfigurationException;
import org.junit.Before;
import org.junit.Test;

public abstract class RioSettingTest<T> {
    protected static final String TEST_KEY = "org.eclipse.rio.long_rio_setting_test";
    protected static final String TEST_DESCRIPTION = "test rio setting";
    protected RioSetting<T> subject;

    @Before
    public void setUp() throws Exception {
        this.subject = this.createRioSetting(TEST_KEY, TEST_DESCRIPTION, this.getDefaultValue());
    }

    @Test
    public void testDefaultValue() throws Exception {
        Assertions.assertThat((Object)this.subject.getDefaultValue()).isEqualTo(this.getDefaultValue());
    }

    @Test
    public void testConvert() throws Exception {
        Assertions.assertThat((Object)this.subject.convert(this.getLegalStringValue())).isEqualTo(this.getConvertedStringValue());
    }

    @Test
    public void testConvertIllegal() throws Exception {
        Assertions.assertThatThrownBy(() -> this.subject.convert(this.getIllegalStringValue())).isInstanceOf(RioConfigurationException.class);
    }

    protected abstract T getDefaultValue();

    protected abstract String getLegalStringValue();

    protected abstract T getConvertedStringValue();

    protected abstract String getIllegalStringValue();

    protected abstract RioSetting<T> createRioSetting(String var1, String var2, T var3);
}

